/**
 * AutoNumeric.js v4.6.2
 * © 2009-2023 Alexandre Bonneau, Robert J. Knothe
 * Released under the MIT License.
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.AutoNumeric=t():e.AutoNumeric=t()}(this,()=>(()=>{"use strict";var n={d:(e,t)=>{for(var i in t)n.o(t,i)&&!n.o(e,i)&&Object.defineProperty(e,i,{enumerable:!0,get:t[i]})},o:(e,t)=>Object.prototype.hasOwnProperty.call(e,t)},e={},t=(n.d(e,{default:()=>ae}),{});t.allowedTagList=["b","caption","cite","code","const","dd","del","div","dfn","dt","em","h1","h2","h3","h4","h5","h6","input","ins","kdb","label","li","option","output","p","q","s","sample","span","strong","td","th","u"],Object.freeze(t.allowedTagList),Object.defineProperty(t,"allowedTagList",{configurable:!1,writable:!1}),t.keyCode={Backspace:8,Tab:9,Enter:13,Shift:16,Ctrl:17,Alt:18,Pause:19,CapsLock:20,Esc:27,Space:32,PageUp:33,PageDown:34,End:35,Home:36,LeftArrow:37,UpArrow:38,RightArrow:39,DownArrow:40,Insert:45,Delete:46,num0:48,num1:49,num2:50,num3:51,num4:52,num5:53,num6:54,num7:55,num8:56,num9:57,a:65,b:66,c:67,d:68,e:69,f:70,g:71,h:72,i:73,j:74,k:75,l:76,m:77,n:78,o:79,p:80,q:81,r:82,s:83,t:84,u:85,v:86,w:87,x:88,y:89,z:90,OSLeft:91,OSRight:92,ContextMenu:93,numpad0:96,numpad1:97,numpad2:98,numpad3:99,numpad4:100,numpad5:101,numpad6:102,numpad7:103,numpad8:104,numpad9:105,MultiplyNumpad:106,PlusNumpad:107,MinusNumpad:109,DotNumpad:110,SlashNumpad:111,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,NumLock:144,ScrollLock:145,HyphenFirefox:173,MyComputer:182,MyCalculator:183,Semicolon:186,Equal:187,Comma:188,Hyphen:189,Dot:190,Slash:191,Backquote:192,LeftBracket:219,Backslash:220,RightBracket:221,Quote:222,Command:224,AltGraph:225,AndroidDefault:229},Object.freeze(t.keyCode),Object.defineProperty(t,"keyCode",{configurable:!1,writable:!1}),t.fromCharCodeKeyCode={0:"LaunchCalculator",8:"Backspace",9:"Tab",13:"Enter",16:"Shift",17:"Ctrl",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",91:"OS",92:"OSRight",93:"ContextMenu",96:"0",97:"1",98:"2",99:"3",100:"4",101:"5",102:"6",103:"7",104:"8",105:"9",106:"*",107:"+",109:"-",110:".",111:"/",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",173:"-",182:"MyComputer",183:"MyCalculator",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",224:"Meta",225:"AltGraph"},Object.freeze(t.fromCharCodeKeyCode),Object.defineProperty(t,"fromCharCodeKeyCode",{configurable:!1,writable:!1}),t.keyName={Unidentified:"Unidentified",AndroidDefault:"AndroidDefault",Alt:"Alt",AltGr:"AltGraph",CapsLock:"CapsLock",Ctrl:"Control",Fn:"Fn",FnLock:"FnLock",Hyper:"Hyper",Meta:"Meta",OSLeft:"OS",OSRight:"OS",Command:"OS",NumLock:"NumLock",ScrollLock:"ScrollLock",Shift:"Shift",Super:"Super",Symbol:"Symbol",SymbolLock:"SymbolLock",Enter:"Enter",Tab:"Tab",Space:" ",LeftArrow:"ArrowLeft",UpArrow:"ArrowUp",RightArrow:"ArrowRight",DownArrow:"ArrowDown",End:"End",Home:"Home",PageUp:"PageUp",PageDown:"PageDown",Backspace:"Backspace",Clear:"Clear",Copy:"Copy",CrSel:"CrSel",Cut:"Cut",Delete:"Delete",EraseEof:"EraseEof",ExSel:"ExSel",Insert:"Insert",Paste:"Paste",Redo:"Redo",Undo:"Undo",Accept:"Accept",Again:"Again",Attn:"Attn",Cancel:"Cancel",ContextMenu:"ContextMenu",Esc:"Escape",Execute:"Execute",Find:"Find",Finish:"Finish",Help:"Help",Pause:"Pause",Play:"Play",Props:"Props",Select:"Select",ZoomIn:"ZoomIn",ZoomOut:"ZoomOut",BrightnessDown:"BrightnessDown",BrightnessUp:"BrightnessUp",Eject:"Eject",LogOff:"LogOff",Power:"Power",PowerOff:"PowerOff",PrintScreen:"PrintScreen",Hibernate:"Hibernate",Standby:"Standby",WakeUp:"WakeUp",Compose:"Compose",Dead:"Dead",F1:"F1",F2:"F2",F3:"F3",F4:"F4",F5:"F5",F6:"F6",F7:"F7",F8:"F8",F9:"F9",F10:"F10",F11:"F11",F12:"F12",Print:"Print",num0:"0",num1:"1",num2:"2",num3:"3",num4:"4",num5:"5",num6:"6",num7:"7",num8:"8",num9:"9",a:"a",b:"b",c:"c",d:"d",e:"e",f:"f",g:"g",h:"h",i:"i",j:"j",k:"k",l:"l",m:"m",n:"n",o:"o",p:"p",q:"q",r:"r",s:"s",t:"t",u:"u",v:"v",w:"w",x:"x",y:"y",z:"z",A:"A",B:"B",C:"C",D:"D",E:"E",F:"F",G:"G",H:"H",I:"I",J:"J",K:"K",L:"L",M:"M",N:"N",O:"O",P:"P",Q:"Q",R:"R",S:"S",T:"T",U:"U",V:"V",W:"W",X:"X",Y:"Y",Z:"Z",Semicolon:";",Equal:"=",Comma:",",Hyphen:"-",Minus:"-",Plus:"+",Dot:".",Slash:"/",Backquote:"`",LeftParenthesis:"(",RightParenthesis:")",LeftBracket:"[",RightBracket:"]",Backslash:"\\",Quote:"'",numpad0:"0",numpad1:"1",numpad2:"2",numpad3:"3",numpad4:"4",numpad5:"5",numpad6:"6",numpad7:"7",numpad8:"8",numpad9:"9",NumpadDot:".",NumpadDotAlt:",",NumpadMultiply:"*",NumpadPlus:"+",NumpadMinus:"-",NumpadSubtract:"-",NumpadSlash:"/",NumpadDotObsoleteBrowsers:"Decimal",NumpadMultiplyObsoleteBrowsers:"Multiply",NumpadPlusObsoleteBrowsers:"Add",NumpadMinusObsoleteBrowsers:"Subtract",NumpadSlashObsoleteBrowsers:"Divide",_allFnKeys:["F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12"],_someNonPrintableKeys:["Tab","Enter","Shift","ShiftLeft","ShiftRight","Control","ControlLeft","ControlRight","Alt","AltLeft","AltRight","Pause","CapsLock","Escape"],_directionKeys:["PageUp","PageDown","End","Home","ArrowDown","ArrowLeft","ArrowRight","ArrowUp"]},Object.freeze(t.keyName._allFnKeys),Object.freeze(t.keyName._someNonPrintableKeys),Object.freeze(t.keyName._directionKeys),Object.freeze(t.keyName),Object.defineProperty(t,"keyName",{configurable:!1,writable:!1}),Object.freeze(t);const u=t;function s(e){return function(e){if(Array.isArray(e))return a(e)}(e)||function(){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}()||i(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function l(){return(l=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var i,n=arguments[t];for(i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}function c(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var i=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=i){var n,a,o,r,s=[],l=!0,c=!1;try{if(o=(i=i.call(e)).next,0===t){if(Object(i)!==i)return;l=!1}else for(;!(l=(n=o.call(i)).done)&&(s.push(n.value),s.length!==t);l=!0);}catch(e){c=!0,a=e}finally{try{if(!l&&null!=i.return&&(r=i.return(),Object(r)!==r))return}finally{if(c)throw a}}return s}}(e,t)||i(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function i(e,t){var i;if(e)return"string"==typeof e?a(e,t):"Map"===(i="Object"===(i=Object.prototype.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:i)||"Set"===i?Array.from(e):"Arguments"===i||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)?a(e,t):void 0}function a(e,t){(null==t||t>e.length)&&(t=e.length);for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}function h(e){return(h="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var T=function(){function o(){if(!(this instanceof o))throw new TypeError("Cannot call a class as a function")}for(var e,t=o,i=t,n=[{key:"isNull",value:function(e){return null===e}},{key:"isUndefined",value:function(e){return void 0===e}},{key:"isUndefinedOrNullOrEmpty",value:function(e){return null==e||""===e}},{key:"isString",value:function(e){return"string"==typeof e||e instanceof String}},{key:"isEmptyString",value:function(e){return""===e}},{key:"isBoolean",value:function(e){return"boolean"==typeof e}},{key:"isTrueOrFalseString",value:function(e){e=String(e).toLowerCase();return"true"===e||"false"===e}},{key:"isObject",value:function(e){return"object"===h(e)&&null!==e&&!Array.isArray(e)}},{key:"isEmptyObj",value:function(e){for(var t in e)if(Object.prototype.hasOwnProperty.call(e,t))return!1;return!0}},{key:"isNumberStrict",value:function(e){return"number"==typeof e}},{key:"isNumber",value:function(e){return!this.isArray(e)&&!isNaN(parseFloat(e))&&isFinite(e)}},{key:"isDigit",value:function(e){return/\d/.test(e)}},{key:"isNumberOrArabic",value:function(e){e=this.arabicToLatinNumbers(e,!1,!0,!0);return this.isNumber(e)}},{key:"isInt",value:function(e){return"number"==typeof e&&parseFloat(e)===parseInt(e,10)&&!isNaN(e)}},{key:"isFunction",value:function(e){return"function"==typeof e}},{key:"isIE11",value:function(){return"undefined"!=typeof window&&!!window.MSInputMethodContext&&!!document.documentMode}},{key:"contains",value:function(e,t){return!(!this.isString(e)||!this.isString(t)||""===e||""===t)&&-1!==e.indexOf(t)}},{key:"isInArray",value:function(e,t){return!(!this.isArray(t)||t===[]||this.isUndefined(e))&&-1!==t.indexOf(e)}},{key:"isArray",value:function(e){if("[object Array]"===Object.prototype.toString.call([]))return Array.isArray(e)||"object"===h(e)&&"[object Array]"===Object.prototype.toString.call(e);throw new Error("toString message changed for Object Array")}},{key:"isElement",value:function(e){return"undefined"!=typeof Element&&e instanceof Element}},{key:"isInputElement",value:function(e){return this.isElement(e)&&"input"===e.tagName.toLowerCase()}},{key:"decimalPlaces",value:function(e){e=c(e.split("."),2)[1];return this.isUndefined(e)?0:e.length}},{key:"indexFirstNonZeroDecimalPlace",value:function(e){var e=c(String(Math.abs(e)).split("."),2)[1];return this.isUndefined(e)?0:(-1===(e=e.lastIndexOf("0"))?e=0:e+=2,e)}},{key:"keyCodeNumber",value:function(e){return void 0===e.which?e.keyCode:e.which}},{key:"character",value:function(e){var t;if("Unidentified"===e.key||void 0===e.key||this.isSeleniumBot()){var i=this.keyCodeNumber(e);if(i===u.keyCode.AndroidDefault)return u.keyName.AndroidDefault;var n=u.fromCharCodeKeyCode[i],a=o.isUndefinedOrNullOrEmpty(n)?String.fromCharCode(i):n}else switch(e.key){case"Add":a=u.keyName.NumpadPlus;break;case"Apps":a=u.keyName.ContextMenu;break;case"Crsel":a=u.keyName.CrSel;break;case"Decimal":a=e.char||u.keyName.NumpadDot;break;case"Del":a="firefox"===(t=this.browser()).name&&t.version<=36||"ie"===t.name&&t.version<=9?u.keyName.Dot:u.keyName.Delete;break;case"Divide":a=u.keyName.NumpadSlash;break;case"Down":a=u.keyName.DownArrow;break;case"Esc":a=u.keyName.Esc;break;case"Exsel":a=u.keyName.ExSel;break;case"Left":a=u.keyName.LeftArrow;break;case"Meta":case"Super":a=u.keyName.OSLeft;break;case"Multiply":a=u.keyName.NumpadMultiply;break;case"Right":a=u.keyName.RightArrow;break;case"Spacebar":a=u.keyName.Space;break;case"Subtract":a=u.keyName.NumpadMinus;break;case"Up":a=u.keyName.UpArrow;break;default:a=e.key}return a}},{key:"browser",value:function(){var e,t=navigator.userAgent,i=t.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];return/trident/i.test(i[1])?{name:"ie",version:(e=/\brv[ :]+(\d+)/g.exec(t)||[])[1]||""}:"Chrome"===i[1]&&null!==(e=t.match(/\b(OPR|Edge)\/(\d+)/))?{name:e[1].replace("OPR","opera"),version:e[2]}:(i=i[2]?[i[1],i[2]]:[navigator.appName,navigator.appVersion,"-?"],null!==(e=t.match(/version\/(\d+)/i))&&i.splice(1,1,e[1]),{name:i[0].toLowerCase(),version:i[1]})}},{key:"isSeleniumBot",value:function(){return!0===window.navigator.webdriver}},{key:"isNegative",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"-",i=!(2<arguments.length&&void 0!==arguments[2])||arguments[2];return e===t||""!==e&&(o.isNumber(e)?e<0:i?this.contains(e,t):this.isNegativeStrict(e,t))}},{key:"isNegativeStrict",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"-";return e.charAt(0)===t}},{key:"isNegativeWithBrackets",value:function(e,t,i){return e.charAt(0)===t&&this.contains(e,i)}},{key:"isZeroOrHasNoValue",value:function(e){return!/[1-9]/g.test(e)}},{key:"setRawNegativeSign",value:function(e){return this.isNegativeStrict(e,"-")?e:"-".concat(e)}},{key:"replaceCharAt",value:function(e,t,i){return"".concat(e.substr(0,t)).concat(i).concat(e.substr(t+i.length))}},{key:"clampToRangeLimits",value:function(e,t){return Math.max(t.minimumValue,Math.min(t.maximumValue,e))}},{key:"countNumberCharactersOnTheCaretLeftSide",value:function(e,t,i){for(var n=new RegExp("[0-9".concat(i,"-]")),a=0,o=0;o<t;o++)n.test(e[o])&&a++;return a}},{key:"findCaretPositionInFormattedNumber",value:function(e,t,i,n){for(var a=i.length,o=e.length,r=0,s=0;s<a&&r<o&&r<t;s++)(e[r]===i[s]||"."===e[r]&&i[s]===n)&&r++;return s}},{key:"countCharInText",value:function(e,t){for(var i=0,n=0;n<t.length;n++)t[n]===e&&i++;return i}},{key:"convertCharacterCountToIndexPosition",value:function(e){return Math.max(e,e-1)}},{key:"getElementSelection",value:function(e){var t,i,n={};try{t=this.isUndefined(e.selectionStart)}catch(e){t=!1}try{t?(i=window.getSelection().getRangeAt(0),n.start=i.startOffset,n.end=i.endOffset):(n.start=e.selectionStart,n.end=e.selectionEnd),n.length=n.end-n.start}catch(e){n.start=0,n.end=0,n.length=0}return n}},{key:"setElementSelection",value:function(e,t){var i,n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;this.isUndefinedOrNullOrEmpty(n)&&(n=t),this.isInputElement(e)?e.setSelectionRange(t,n):o.isNull(e.firstChild)||((i=document.createRange()).setStart(e.firstChild,t),i.setEnd(e.firstChild,n),(t=window.getSelection()).removeAllRanges(),t.addRange(i))}},{key:"throwError",value:function(e){throw new Error(e)}},{key:"warning",value:function(e){1<arguments.length&&void 0!==arguments[1]&&!arguments[1]||console.warn("Warning: ".concat(e))}},{key:"isWheelEvent",value:function(e){return e instanceof WheelEvent}},{key:"isWheelUpEvent",value:function(e){return this.isWheelEvent(e)&&!this.isUndefinedOrNullOrEmpty(e.deltaY)||this.throwError("The event passed as a parameter is not a valid wheel event, '".concat(e.type,"' given.")),e.deltaY<0}},{key:"isWheelDownEvent",value:function(e){return this.isWheelEvent(e)&&!this.isUndefinedOrNullOrEmpty(e.deltaY)||this.throwError("The event passed as a parameter is not a valid wheel event, '".concat(e.type,"' given.")),0<e.deltaY}},{key:"forceDecimalPlaces",value:function(e,t){var i=c(String(e).split("."),2),n=i[0],i=i[1];return i?"".concat(n,".").concat(i.substr(0,t)):e}},{key:"roundToNearest",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:1e3;return 0===e?0:(0===t&&this.throwError("The `stepPlace` used to round is equal to `0`. This value must not be equal to zero."),Math.round(e/t)*t)}},{key:"modifyAndRoundToNearestAuto",value:function(e,t,i){e=Number(this.forceDecimalPlaces(e,i));var n=Math.abs(e);if(0<=n&&n<1)return n=Math.pow(10,-i),0===e?t?n:-n:(n=i-1<=(i=this.indexFirstNonZeroDecimalPlace(e))?n:Math.pow(10,-(i+1)),this.roundToNearest(t?e+n:e-n,n));e=parseInt(e,10);var a,o=Math.abs(e).toString().length;switch(o){case 1:a=0;break;case 2:case 3:a=1;break;case 4:case 5:a=2;break;default:a=o-3}i=Math.pow(10,a),n=t?e+i:e-i;return n<=10&&-10<=n?n:this.roundToNearest(n,i)}},{key:"addAndRoundToNearestAuto",value:function(e,t){return this.modifyAndRoundToNearestAuto(e,!0,t)}},{key:"subtractAndRoundToNearestAuto",value:function(e,t){return this.modifyAndRoundToNearestAuto(e,!1,t)}},{key:"arabicToLatinNumbers",value:function(e){var t=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],i=2<arguments.length&&void 0!==arguments[2]&&arguments[2],n=3<arguments.length&&void 0!==arguments[3]&&arguments[3];if(this.isNull(e))return e;if(""===(a=e.toString()))return e;if(null===a.match(/[٠١٢٣٤٥٦٧٨٩۴۵۶]/g))return t?Number(a):a;i&&(a=a.replace(/٫/,"."));var a=(a=n?a.replace(/٬/g,""):a).replace(/[٠١٢٣٤٥٦٧٨٩]/g,function(e){return e.charCodeAt(0)-1632}).replace(/[۰۱۲۳۴۵۶۷۸۹]/g,function(e){return e.charCodeAt(0)-1776}),e=Number(a);return isNaN(e)||t?e:a}},{key:"triggerEvent",value:function(e){var t,i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:document,n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,a=!(3<arguments.length&&void 0!==arguments[3])||arguments[3],o=!(4<arguments.length&&void 0!==arguments[4])||arguments[4];window.CustomEvent?t=new CustomEvent(e,{detail:n,bubbles:a,cancelable:o}):(t=document.createEvent("CustomEvent")).initCustomEvent(e,a,o,{detail:n}),i.dispatchEvent(t)}},{key:"parseStr",value:function(e){var t,i,n,a,o={};if(e=(e=0===e&&1/e<0?"-0":e).toString(),this.isNegativeStrict(e,"-")?(e=e.slice(1),o.s=-1):o.s=1,-1<(t=e.indexOf("."))&&(e=e.replace(".","")),t<0&&(t=e.length),(i=-1===e.search(/[1-9]/i)?e.length:e.search(/[1-9]/i))===(n=e.length))o.e=0,o.c=[0];else{for(a=n-1;"0"===e.charAt(a);--a)--n;for(--n,o.e=t-i-1,o.c=[],t=0;i<=n;i+=1)o.c[t]=+e.charAt(i),t+=1}return o}},{key:"testMinMax",value:function(e,t){var i=t.c,n=e.c,a=t.s,o=e.s,t=t.e,e=e.e;if(!i[0]||!n[0])return i[0]?a:n[0]?-o:0;if(a!==o)return a;var r=a<0;if(t!==e)return e<t^r?1:-1;for(a=-1,o=(t=i.length)<(e=n.length)?t:e,a+=1;a<o;a+=1)if(i[a]!==n[a])return i[a]>n[a]^r?1:-1;return t===e?0:e<t^r?1:-1}},{key:"randomString",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:5;return Math.random().toString(36).substr(2,e)}},{key:"domElement",value:function(e){return o.isString(e)?document.querySelector(e):e}},{key:"getElementValue",value:function(e){return"input"===e.tagName.toLowerCase()?e.value:this.text(e)}},{key:"setElementValue",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;"input"===e.tagName.toLowerCase()?e.value=t:e.textContent=t}},{key:"setInvalidState",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"Invalid";""!==t&&!this.isNull(t)||this.throwError("Cannot set the invalid state with an empty message."),e.setCustomValidity(t)}},{key:"setValidState",value:function(e){e.setCustomValidity("")}},{key:"cloneObject",value:function(e){return l({},e)}},{key:"camelize",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"-",i=!(2<arguments.length&&void 0!==arguments[2])||arguments[2],n=!(3<arguments.length&&void 0!==arguments[3])||arguments[3];return this.isNull(e)?null:(i=(i=(e=i?e.replace(/^data-/,""):e).split(t).map(function(e){return"".concat(e.charAt(0).toUpperCase()).concat(e.slice(1))})).join(""),n?"".concat(i.charAt(0).toLowerCase()).concat(i.slice(1)):i)}},{key:"text",value:function(e){var t=e.nodeType;return t===Node.ELEMENT_NODE||t===Node.DOCUMENT_NODE||t===Node.DOCUMENT_FRAGMENT_NODE?e.textContent:t===Node.TEXT_NODE?e.nodeValue:""}},{key:"setText",value:function(e,t){var i=e.nodeType;i!==Node.ELEMENT_NODE&&i!==Node.DOCUMENT_NODE&&i!==Node.DOCUMENT_FRAGMENT_NODE||(e.textContent=t)}},{key:"filterOut",value:function(e,t){var i=this;return e.filter(function(e){return!i.isInArray(e,t)})}},{key:"trimPaddedZerosFromDecimalPlaces",value:function(e){var t;return""===(e=String(e))?"":(t=(e=c(e.split("."),2))[0],e=e[1],this.isUndefinedOrNullOrEmpty(e)||""===(e=e.replace(/0+$/g,""))?t:"".concat(t,".").concat(e))}},{key:"getHoveredElement",value:function(){var e=s(document.querySelectorAll(":hover"));return e[e.length-1]}},{key:"arrayTrim",value:function(e,t){var i=e.length;if(!(0===i||i<t)){if(t<0)return[];e.length=parseInt(t,10)}return e}},{key:"arrayUnique",value:function(){var e;return s(new Set((e=[]).concat.apply(e,arguments)))}},{key:"mergeMaps",value:function(){for(var e=arguments.length,t=new Array(e),i=0;i<e;i++)t[i]=arguments[i];return new Map(t.reduce(function(e,t){return e.concat(s(t))},[]))}},{key:"objectKeyLookup",value:function(e,t){e=Object.entries(e).find(function(e){return e[1]===t});return void 0!==e?e[0]:null}},{key:"insertAt",value:function(e,t,i){if(i>(e=String(e)).length)throw new Error("The given index is out of the string range.");if(1!==t.length)throw new Error("The given string `char` should be only one character long.");return""===e&&0===i?t:"".concat(e.slice(0,i)).concat(t).concat(e.slice(i))}},{key:"scientificToDecimal",value:function(e){var t,i,n,a,o,r,s=Number(e);return isNaN(s)?NaN:(e=String(e),this.contains(e,"e")||this.contains(e,"E")?(t=(s=c(e.split(/e/i),2))[0],s=s[1],(i=t<0)&&(t=t.replace("-","")),(n=+s<0)&&(s=s.replace("-","")),a=(o=c(t.split(/\./),2))[0],o=o[1],r=n?(r=a.length>s?this.insertAt(a,".",a.length-s):"0.".concat("0".repeat(s-a.length)).concat(a),"".concat(r).concat(o||"")):o?(t="".concat(a).concat(o),s<o.length?this.insertAt(t,".",+s+a.length):"".concat(t).concat("0".repeat(s-o.length))):(t=t.replace(".",""),"".concat(t).concat("0".repeat(Number(s)))),i?"-".concat(r):r):e)}}],a=0;a<n.length;a++){var r=n[a];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(i,(e=function(e){if("object"!==h(e)||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0===t)return String(e);t=t.call(e,"string");if("object"!==h(t))return t;throw new TypeError("@@toPrimitive must return a primitive value.")}(r.key),"symbol"===h(e)?e:String(e)),r)}return Object.defineProperty(t,"prototype",{writable:!1}),o}();function m(e){return(m="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var B=function(){function t(e){if(!(this instanceof t))throw new TypeError("Cannot call a class as a function");if(null===e)throw new Error("Invalid AST")}for(var e,i=t,n=i.prototype,a=[{key:"evaluate",value:function(e){if(null==e)throw new Error("Invalid AST sub-tree");if("number"===e.type)return e.value;if("unaryMinus"===e.type)return-this.evaluate(e.left);var t=this.evaluate(e.left),i=this.evaluate(e.right);switch(e.type){case"op_+":return Number(t)+Number(i);case"op_-":return t-i;case"op_*":return t*i;case"op_/":return t/i;default:throw new Error("Invalid operator '".concat(e.type,"'"))}}}],o=0;o<a.length;o++){var r=a[o];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(n,(e=function(e){if("object"!==m(e)||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0===t)return String(e);t=t.call(e,"string");if("object"!==m(t))return t;throw new TypeError("@@toPrimitive must return a primitive value.")}(r.key),"symbol"===m(e)?e:String(e)),r)}return Object.defineProperty(i,"prototype",{writable:!1}),t}();function g(e){return(g="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var d=function(){function a(){if(!(this instanceof a))throw new TypeError("Cannot call a class as a function")}for(var e,t=a,i=t,n=[{key:"createNode",value:function(e,t,i){var n=new a;return n.type=e,n.left=t,n.right=i,n}},{key:"createUnaryNode",value:function(e){var t=new a;return t.type="unaryMinus",t.left=e,t.right=null,t}},{key:"createLeaf",value:function(e){var t=new a;return t.type="number",t.value=e,t}}],o=0;o<n.length;o++){var r=n[o];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(i,(e=function(e){if("object"!==g(e)||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0===t)return String(e);t=t.call(e,"string");if("object"!==g(t))return t;throw new TypeError("@@toPrimitive must return a primitive value.")}(r.key),"symbol"===g(e)?e:String(e)),r)}return Object.defineProperty(t,"prototype",{writable:!1}),a}();function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function D(e,t){for(var i,n=0;n<t.length;n++){var a=t[n];a.enumerable=a.enumerable||!1,a.configurable=!0,"value"in a&&(a.writable=!0),Object.defineProperty(e,(i=function(e){if("object"!==o(e)||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0===t)return String(e);t=t.call(e,"string");if("object"!==o(t))return t;throw new TypeError("@@toPrimitive must return a primitive value.")}(a.key),"symbol"===o(i)?i:String(i)),a)}}function M(e,t,i){return t&&D(e.prototype,t),i&&D(e,i),Object.defineProperty(e,"prototype",{writable:!1}),e}var R=M(function e(t,i,n){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");this.type=t,this.value=i,this.symbol=n});function v(e){return(v="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var U=function(){function t(e){if(!(this instanceof t))throw new TypeError("Cannot call a class as a function");this.text=e,this.textLength=e.length,this.index=0,this.token=new R("Error",0,0)}for(var e,i=t,n=i.prototype,a=[{key:"_skipSpaces",value:function(){for(;" "===this.text[this.index]&&this.index<=this.textLength;)this.index++}},{key:"getIndex",value:function(){return this.index}},{key:"getNextToken",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:".";if(this._skipSpaces(),this.textLength===this.index)this.token.type="EOT";else if(T.isDigit(this.text[this.index]))this.token.type="num",this.token.value=this._getNumber(e);else{switch(this.token.type="Error",this.text[this.index]){case"+":this.token.type="+";break;case"-":this.token.type="-";break;case"*":this.token.type="*";break;case"/":this.token.type="/";break;case"(":this.token.type="(";break;case")":this.token.type=")"}if("Error"===this.token.type)throw new Error("Unexpected token '".concat(this.token.symbol,"' at position '").concat(this.token.index,"' in the token function"));this.token.symbol=this.text[this.index],this.index++}return this.token}},{key:"_getNumber",value:function(e){this._skipSpaces();for(var t=this.index;this.index<=this.textLength&&T.isDigit(this.text[this.index]);)this.index++;for(this.text[this.index]===e&&this.index++;this.index<=this.textLength&&T.isDigit(this.text[this.index]);)this.index++;if(this.index===t)throw new Error("No number has been found while it was expected");return this.text.substring(t,this.index).replace(e,".")}}],o=0;o<a.length;o++){var r=a[o];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(n,(e=function(e){if("object"!==v(e)||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0===t)return String(e);t=t.call(e,"string");if("object"!==v(t))return t;throw new TypeError("@@toPrimitive must return a primitive value.")}(r.key),"symbol"===v(e)?e:String(e)),r)}return Object.defineProperty(i,"prototype",{writable:!1}),t}();function p(e){return(p="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var j=function(){function i(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:".";if(this instanceof i)return this.text=e,this.decimalCharacter=t,this.lexer=new U(e),this.token=this.lexer.getNextToken(this.decimalCharacter),this._exp();throw new TypeError("Cannot call a class as a function")}for(var e,t=i,n=t.prototype,a=[{key:"_exp",value:function(){var e=this._term(),t=this._moreExp();return d.createNode("op_+",e,t)}},{key:"_moreExp",value:function(){var e,t;switch(this.token.type){case"+":return this.token=this.lexer.getNextToken(this.decimalCharacter),e=this._term(),t=this._moreExp(),d.createNode("op_+",t,e);case"-":return this.token=this.lexer.getNextToken(this.decimalCharacter),e=this._term(),t=this._moreExp(),d.createNode("op_-",t,e)}return d.createLeaf(0)}},{key:"_term",value:function(){var e=this._factor(),t=this._moreTerms();return d.createNode("op_*",e,t)}},{key:"_moreTerms",value:function(){var e,t;switch(this.token.type){case"*":return this.token=this.lexer.getNextToken(this.decimalCharacter),e=this._factor(),t=this._moreTerms(),d.createNode("op_*",t,e);case"/":return this.token=this.lexer.getNextToken(this.decimalCharacter),e=this._factor(),t=this._moreTerms(),d.createNode("op_/",t,e)}return d.createLeaf(1)}},{key:"_factor",value:function(){var e;switch(this.token.type){case"num":return e=this.token.value,this.token=this.lexer.getNextToken(this.decimalCharacter),d.createLeaf(e);case"-":return this.token=this.lexer.getNextToken(this.decimalCharacter),e=this._factor(),d.createUnaryNode(e);case"(":return this.token=this.lexer.getNextToken(this.decimalCharacter),e=this._exp(),this._match(")"),e;default:throw new Error("Unexpected token '".concat(this.token.symbol,"' with type '").concat(this.token.type,"' at position '").concat(this.token.index,"' in the factor function"))}}},{key:"_match",value:function(e){var t=this.lexer.getIndex()-1;if(this.text[t]!==e)throw new Error("Unexpected token '".concat(this.token.symbol,"' at position '").concat(t,"' in the match function"));this.token=this.lexer.getNextToken(this.decimalCharacter)}}],o=0;o<a.length;o++){var r=a[o];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(n,(e=function(e){if("object"!==p(e)||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0===t)return String(e);t=t.call(e,"string");if("object"!==p(t))return t;throw new TypeError("@@toPrimitive must return a primitive value.")}(r.key),"symbol"===p(e)?e:String(e)),r)}return Object.defineProperty(t,"prototype",{writable:!1}),i}();function f(e){return function(e){if(Array.isArray(e))return r(e)}(e)||function(){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}()||z(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function y(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var i=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=i){var n,a,o,r,s=[],l=!0,c=!1;try{if(o=(i=i.call(e)).next,0===t){if(Object(i)!==i)return;l=!1}else for(;!(l=(n=o.call(i)).done)&&(s.push(n.value),s.length!==t);l=!0);}catch(e){c=!0,a=e}finally{try{if(!l&&null!=i.return&&(r=i.return(),Object(r)!==r))return}finally{if(c)throw a}}return s}}(e,t)||z(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function z(e,t){var i;if(e)return"string"==typeof e?r(e,t):"Map"===(i="Object"===(i=Object.prototype.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:i)||"Set"===i?Array.from(e):"Arguments"===i||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)?r(e,t):void 0}function r(e,t){(null==t||t>e.length)&&(t=e.length);for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}function S(){return(S=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var i,n=arguments[t];for(i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}function b(e){return(b="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function K(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,W(n.key),n)}}function w(e,t,i){(t=W(t))in e?Object.defineProperty(e,t,{value:i,enumerable:!0,configurable:!0,writable:!0}):e[t]=i}function W(e){e=function(e){if("object"!==b(e)||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0===t)return String(e);t=t.call(e,"string");if("object"!==b(t))return t;throw new TypeError("@@toPrimitive must return a primitive value.")}(e);return"symbol"===b(e)?e:String(e)}var P,O=function(){function V(){var a=this,e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!(this instanceof V))throw new TypeError("Cannot call a class as a function");var n,e=V._setArgumentsValues(e,t,i),t=e.domElement,i=e.initialValue,e=e.userOptions;if(this.domElement=t,this.defaultRawValue="",this._setSettings(e,!1),this._checkElement(),this.savedCancellableValue=null,this.historyTable=[],this.historyTableIndex=-1,this.onGoingRedo=!1,this.parentForm=this._getParentForm(),!this.runOnce&&this.settings.formatOnPageLoad)this._formatDefaultValueOnPageLoad(i);else{if(T.isNull(i))switch(this.settings.emptyInputBehavior){case V.options.emptyInputBehavior.min:n=this.settings.minimumValue;break;case V.options.emptyInputBehavior.max:n=this.settings.maximumValue;break;case V.options.emptyInputBehavior.zero:n="0";break;case V.options.emptyInputBehavior.focus:case V.options.emptyInputBehavior.press:case V.options.emptyInputBehavior.always:case V.options.emptyInputBehavior.null:n="";break;default:n=this.settings.emptyInputBehavior}else n=i;this._setElementAndRawValue(n)}this.runOnce=!0,this.hasEventListeners=!1,(this.isInputElement||this.isContentEditable)&&(this.settings.noEventListeners||this._createEventListeners(),this._setWritePermissions(!0)),this._saveInitialValues(i),this.sessionStorageAvailable=this.constructor._storageTest(),this.storageNamePrefix="AUTO_",this._setPersistentStorageName(),this.validState=!0,this.isFocused=!1,this.isWheelEvent=!1,this.isDropEvent=!1,this.isEditing=!1,this.rawValueOnFocus=void 0,this.internalModification=!1,this.attributeToWatch=this._getAttributeToWatch(),this.getterSetter=Object.getOwnPropertyDescriptor(this.domElement.__proto__,this.attributeToWatch),this._addWatcher(),this.settings.createLocalList&&this._createLocalList(),this.constructor._addToGlobalList(this),this.global={set:function(t){var i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;a.autoNumericLocalList.forEach(function(e){e.set(t,i)})},setUnformatted:function(t){var i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;a.autoNumericLocalList.forEach(function(e){e.setUnformatted(t,i)})},get:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=[];return a.autoNumericLocalList.forEach(function(e){t.push(e.get())}),a._executeCallback(t,e),t},getNumericString:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=[];return a.autoNumericLocalList.forEach(function(e){t.push(e.getNumericString())}),a._executeCallback(t,e),t},getFormatted:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=[];return a.autoNumericLocalList.forEach(function(e){t.push(e.getFormatted())}),a._executeCallback(t,e),t},getNumber:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=[];return a.autoNumericLocalList.forEach(function(e){t.push(e.getNumber())}),a._executeCallback(t,e),t},getLocalized:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=[];return a.autoNumericLocalList.forEach(function(e){t.push(e.getLocalized())}),a._executeCallback(t,e),t},reformat:function(){a.autoNumericLocalList.forEach(function(e){e.reformat()})},unformat:function(){a.autoNumericLocalList.forEach(function(e){e.unformat()})},unformatLocalized:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;a.autoNumericLocalList.forEach(function(e){e.unformatLocalized(t)})},update:function(){for(var e=arguments.length,t=new Array(e),i=0;i<e;i++)t[i]=arguments[i];a.autoNumericLocalList.forEach(function(e){e.update.apply(e,t)})},isPristine:function(){var t=!(0<arguments.length&&void 0!==arguments[0])||arguments[0],i=!0;return a.autoNumericLocalList.forEach(function(e){i&&!e.isPristine(t)&&(i=!1)}),i},clear:function(){var t=0<arguments.length&&void 0!==arguments[0]&&arguments[0];a.autoNumericLocalList.forEach(function(e){e.clear(t)})},remove:function(){a.autoNumericLocalList.forEach(function(e){e.remove()})},wipe:function(){a.autoNumericLocalList.forEach(function(e){e.wipe()})},nuke:function(){a.autoNumericLocalList.forEach(function(e){e.nuke()})},has:function(e){return e instanceof V?a.autoNumericLocalList.has(e.node()):a.autoNumericLocalList.has(e)},addObject:function(e){var t,i,e=e instanceof V?(t=e.node(),e):V.getAutoNumericElement(t=e),n=(a._hasLocalList()||a._createLocalList(),e._getLocalList());0===n.size&&(e._createLocalList(),n=e._getLocalList()),(i=n instanceof Map?T.mergeMaps(a._getLocalList(),n):(a._addToLocalList(t,e),a._getLocalList())).forEach(function(e){e._setLocalList(i)})},removeObject:function(e){var t,i=1<arguments.length&&void 0!==arguments[1]&&arguments[1],e=e instanceof V?(t=e.node(),e):V.getAutoNumericElement(t=e),n=a.autoNumericLocalList;a.autoNumericLocalList.delete(t),n.forEach(function(e){e._setLocalList(a.autoNumericLocalList)}),i||t!==a.node()?e._createLocalList():e._setLocalList(new Map)},empty:function(){var t=0<arguments.length&&void 0!==arguments[0]&&arguments[0];a.autoNumericLocalList.forEach(function(e){t?e._createLocalList():e._setLocalList(new Map)})},elements:function(){var t=[];return a.autoNumericLocalList.forEach(function(e){t.push(e.node())}),t},getList:function(){return a.autoNumericLocalList},size:function(){return a.autoNumericLocalList.size}},this.options={reset:function(){return a.settings={rawValue:a.defaultRawValue},a.update(V.defaultSettings),a},allowDecimalPadding:function(e){return a.update({allowDecimalPadding:e}),a},alwaysAllowDecimalCharacter:function(e){return a.update({alwaysAllowDecimalCharacter:e}),a},caretPositionOnFocus:function(e){return a.settings.caretPositionOnFocus=e,a},createLocalList:function(e){return a.settings.createLocalList=e,a.settings.createLocalList?a._hasLocalList()||a._createLocalList():a._deleteLocalList(),a},currencySymbol:function(e){return a.update({currencySymbol:e}),a},currencySymbolPlacement:function(e){return a.update({currencySymbolPlacement:e}),a},decimalCharacter:function(e){return a.update({decimalCharacter:e}),a},decimalCharacterAlternative:function(e){return a.settings.decimalCharacterAlternative=e,a},decimalPlaces:function(e){return T.warning("Using `options.decimalPlaces()` instead of calling the specific `options.decimalPlacesRawValue()`, `options.decimalPlacesShownOnFocus()` and `options.decimalPlacesShownOnBlur()` methods will reset those options.\nPlease call the specific methods if you do not want to reset those.",a.settings.showWarnings),a.update({decimalPlaces:e}),a},decimalPlacesRawValue:function(e){return a.update({decimalPlacesRawValue:e}),a},decimalPlacesShownOnBlur:function(e){return a.update({decimalPlacesShownOnBlur:e}),a},decimalPlacesShownOnFocus:function(e){return a.update({decimalPlacesShownOnFocus:e}),a},defaultValueOverride:function(e){return a.update({defaultValueOverride:e}),a},digitalGroupSpacing:function(e){return a.update({digitalGroupSpacing:e}),a},digitGroupSeparator:function(e){return a.update({digitGroupSeparator:e}),a},divisorWhenUnfocused:function(e){return a.update({divisorWhenUnfocused:e}),a},emptyInputBehavior:function(e){return null===a.rawValue&&e!==V.options.emptyInputBehavior.null&&(T.warning("You are trying to modify the `emptyInputBehavior` option to something different than `'null'` (".concat(e,"), but the element raw value is currently set to `null`. This would result in an invalid `rawValue`. In order to fix that, the element value has been changed to the empty string `''`."),a.settings.showWarnings),a.rawValue=""),a.update({emptyInputBehavior:e}),a},eventBubbles:function(e){return a.settings.eventBubbles=e,a},eventIsCancelable:function(e){return a.settings.eventIsCancelable=e,a},failOnUnknownOption:function(e){return a.settings.failOnUnknownOption=e,a},formatOnPageLoad:function(e){return a.settings.formatOnPageLoad=e,a},formulaMode:function(e){return a.settings.formulaMode=e,a},historySize:function(e){return a.settings.historySize=e,a},invalidClass:function(e){return a.settings.invalidClass=e,a},isCancellable:function(e){return a.settings.isCancellable=e,a},leadingZero:function(e){return a.update({leadingZero:e}),a},maximumValue:function(e){return a.update({maximumValue:e}),a},minimumValue:function(e){return a.update({minimumValue:e}),a},modifyValueOnWheel:function(e){return a.settings.modifyValueOnWheel=e,a},negativeBracketsTypeOnBlur:function(e){return a.update({negativeBracketsTypeOnBlur:e}),a},negativePositiveSignPlacement:function(e){return a.update({negativePositiveSignPlacement:e}),a},negativeSignCharacter:function(e){return a.update({negativeSignCharacter:e}),a},noEventListeners:function(e){return e===V.options.noEventListeners.noEvents&&a.settings.noEventListeners===V.options.noEventListeners.addEvents&&a._removeEventListeners(),a.update({noEventListeners:e}),a},onInvalidPaste:function(e){return a.settings.onInvalidPaste=e,a},outputFormat:function(e){return a.settings.outputFormat=e,a},overrideMinMaxLimits:function(e){return a.update({overrideMinMaxLimits:e}),a},positiveSignCharacter:function(e){return a.update({positiveSignCharacter:e}),a},rawValueDivisor:function(e){return a.update({rawValueDivisor:e}),a},readOnly:function(e){return a.settings.readOnly=e,a._setWritePermissions(),a},roundingMethod:function(e){return a.update({roundingMethod:e}),a},saveValueToSessionStorage:function(e){return a.update({saveValueToSessionStorage:e}),a},symbolWhenUnfocused:function(e){return a.update({symbolWhenUnfocused:e}),a},selectNumberOnly:function(e){return a.settings.selectNumberOnly=e,a},selectOnFocus:function(e){return a.settings.selectOnFocus=e,a},serializeSpaces:function(e){return a.settings.serializeSpaces=e,a},showOnlyNumbersOnFocus:function(e){return a.update({showOnlyNumbersOnFocus:e}),a},showPositiveSign:function(e){return a.update({showPositiveSign:e}),a},showWarnings:function(e){return a.settings.showWarnings=e,a},styleRules:function(e){return a.update({styleRules:e}),a},suffixText:function(e){return a.update({suffixText:e}),a},unformatOnHover:function(e){return a.settings.unformatOnHover=e,a},unformatOnSubmit:function(e){return a.settings.unformatOnSubmit=e,a},valuesToStrings:function(e){return a.update({valuesToStrings:e}),a},watchExternalChanges:function(e){return a.update({watchExternalChanges:e}),a},wheelOn:function(e){return a.settings.wheelOn=e,a},wheelStep:function(e){return a.settings.wheelStep=e,a}},this._triggerEvent(V.events.initialized,this.domElement,{newValue:T.getElementValue(this.domElement),newRawValue:this.rawValue,error:null,aNElement:this})}var e=V,t=[{key:"version",value:function(){return"4.6.2"}},{key:"_setArgumentsValues",value:function(e,t,i){T.isNull(e)&&T.throwError("At least one valid parameter is needed in order to initialize an AutoNumeric object");var n,a,o,r=T.isElement(e),s=T.isString(e),l=T.isObject(t),c=Array.isArray(t)&&0<t.length,u=T.isNumberOrArabic(t)||""===t,h=this._isPreDefinedOptionValid(t),m=T.isNull(t),g=T.isEmptyString(t),d=T.isObject(i),v=Array.isArray(i)&&0<i.length,p=T.isNull(i),f=this._isPreDefinedOptionValid(i);return r&&m&&p?(n=e,a=o=null):r&&u&&p?(n=e,o=t,a=null):r&&l&&p?(n=e,o=null,a=t):r&&h&&p?(n=e,o=null,a=this._getOptionObject(t)):r&&c&&p?(n=e,o=null,a=this.mergeOptions(t)):r&&(m||g)&&d?(n=e,o=null,a=i):r&&(m||g)&&v?(n=e,o=null,a=this.mergeOptions(i)):s&&m&&p?(n=document.querySelector(e),a=o=null):s&&l&&p?(n=document.querySelector(e),o=null,a=t):s&&h&&p?(n=document.querySelector(e),o=null,a=this._getOptionObject(t)):s&&c&&p?(n=document.querySelector(e),o=null,a=this.mergeOptions(t)):s&&(m||g)&&d?(n=document.querySelector(e),o=null,a=i):s&&(m||g)&&v?(n=document.querySelector(e),o=null,a=this.mergeOptions(i)):s&&u&&p?(n=document.querySelector(e),o=t,a=null):s&&u&&d?(n=document.querySelector(e),o=t,a=i):s&&u&&f?(n=document.querySelector(e),o=t,a=this._getOptionObject(i)):s&&u&&v?(n=document.querySelector(e),o=t,a=this.mergeOptions(i)):r&&u&&d?(n=e,o=t,a=i):r&&u&&f?(n=e,o=t,a=this._getOptionObject(i)):r&&u&&v?(n=e,o=t,a=this.mergeOptions(i)):T.throwError("The parameters given to the AutoNumeric object are not valid, '".concat(e,"', '").concat(t,"' and '").concat(i,"' given.")),T.isNull(n)&&T.throwError("The selector '".concat(e,"' did not select any valid DOM element. Please check on which element you called AutoNumeric.")),{domElement:n,initialValue:o,userOptions:a}}},{key:"mergeOptions",value:function(e){var t=this,i={};return e.forEach(function(e){S(i,t._getOptionObject(e))}),i}},{key:"_isPreDefinedOptionValid",value:function(e){return Object.prototype.hasOwnProperty.call(V.predefinedOptions,e)}},{key:"_getOptionObject",value:function(e){var t;return T.isString(e)?null==(t=V.getPredefinedOptions()[e])&&T.warning("The given pre-defined option [".concat(e,"] is not recognized by autoNumeric. Please check that pre-defined option name."),!0):t=e,t}},{key:"_doesFormHandlerListExists",value:function(){var e=b(window.aNFormHandlerMap);return"undefined"!==e&&"object"===e}},{key:"_createFormHandlerList",value:function(){window.aNFormHandlerMap=new Map}},{key:"_checkValuesToStringsArray",value:function(e,t){return T.isInArray(String(e),t)}},{key:"_checkValuesToStringsSettings",value:function(e,t){return this._checkValuesToStringsArray(e,Object.keys(t.valuesToStrings))}},{key:"_checkStringsToValuesSettings",value:function(e,t){return this._checkValuesToStringsArray(e,Object.values(t.valuesToStrings))}},{key:"_unformatAltHovered",value:function(e){e.hoveredWithAlt=!0,e.unformat()}},{key:"_reformatAltHovered",value:function(e){e.hoveredWithAlt=!1,e.reformat()}},{key:"_getChildANInputElement",value:function(e){var t=this,e=e.getElementsByTagName("input"),i=[];return Array.prototype.slice.call(e,0).forEach(function(e){t.test(e)&&i.push(e)}),i}},{key:"test",value:function(e){return this._isInGlobalList(T.domElement(e))}},{key:"_createWeakMap",value:function(e){window[e]=new WeakMap}},{key:"_createGlobalList",value:function(){this.autoNumericGlobalListName="autoNumericGlobalList",this._createWeakMap(this.autoNumericGlobalListName)}},{key:"_doesGlobalListExists",value:function(){var e=b(window[this.autoNumericGlobalListName]);return"undefined"!==e&&"object"===e}},{key:"_addToGlobalList",value:function(e){this._doesGlobalListExists()||this._createGlobalList();var t=e.node();if(this._isInGlobalList(t)){if(this._getFromGlobalList(t)===this)return;T.warning("A reference to the DOM element you just initialized already exists in the global AutoNumeric element list. Please make sure to not initialize the same DOM element multiple times.",e.getSettings().showWarnings)}window[this.autoNumericGlobalListName].set(t,e)}},{key:"_removeFromGlobalList",value:function(e){this._doesGlobalListExists()&&window[this.autoNumericGlobalListName].delete(e.node())}},{key:"_getFromGlobalList",value:function(e){return this._doesGlobalListExists()?window[this.autoNumericGlobalListName].get(e):null}},{key:"_isInGlobalList",value:function(e){return!!this._doesGlobalListExists()&&window[this.autoNumericGlobalListName].has(e)}},{key:"validate",value:function(e){var t=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,n=(!T.isUndefinedOrNullOrEmpty(e)&&T.isObject(e)||T.throwError("The userOptions are invalid ; it should be a valid object, [".concat(e,"] given.")),T.isObject(i)),a=(n||T.isNull(i)||T.throwError("The 'originalOptions' parameter is invalid ; it should either be a valid option object or `null`, [".concat(e,"] given.")),T.isNull(e)||this._convertOldOptionsToNewOnes(e),t=t?S({},this.getDefaultConfig(),e):e,T.isTrueOrFalseString(t.showWarnings)||T.isBoolean(t.showWarnings)||T.throwError("The debug option 'showWarnings' is invalid ; it should be either 'true' or 'false', [".concat(t.showWarnings,"] given.")),/^[0-9]+$/),o=/[0-9]+/,r=/^-?[0-9]+(\.?[0-9]+)?$/,s=/^[0-9]+(\.?[0-9]+)?$/,i=(T.isTrueOrFalseString(t.allowDecimalPadding)||T.isBoolean(t.allowDecimalPadding)||t.allowDecimalPadding===V.options.allowDecimalPadding.floats||T.isNumber(t.allowDecimalPadding)&&0<t.allowDecimalPadding||T.throwError("The decimal padding option 'allowDecimalPadding' is invalid ; it should either be `false`, `true`, `'floats'` or a positive integer superior to 0, [".concat(t.allowDecimalPadding,"] given.")),T.isNumber(t.allowDecimalPadding)&&t.allowDecimalPadding>t.decimalPlaces&&T.warning("Setting 'allowDecimalPadding' to a number [".concat(t.allowDecimalPadding,"] superior to the current 'decimalPlaces' settings [").concat(t.decimalPlaces,"] is useless, since the padding will not be shown."),t.showWarnings),t.allowDecimalPadding!==V.options.allowDecimalPadding.never&&"false"!==t.allowDecimalPadding||t.decimalPlaces===V.options.decimalPlaces.none&&t.decimalPlacesShownOnBlur===V.options.decimalPlacesShownOnBlur.none&&t.decimalPlacesShownOnFocus===V.options.decimalPlacesShownOnFocus.none||T.warning("Setting 'allowDecimalPadding' to [".concat(t.allowDecimalPadding,"] will override the current 'decimalPlaces*' settings [").concat(t.decimalPlaces,", ").concat(t.decimalPlacesShownOnBlur," and ").concat(t.decimalPlacesShownOnFocus,"]."),t.showWarnings),T.isTrueOrFalseString(t.alwaysAllowDecimalCharacter)||T.isBoolean(t.alwaysAllowDecimalCharacter)||T.throwError("The option 'alwaysAllowDecimalCharacter' is invalid ; it should either be `true` or `false`, [".concat(t.alwaysAllowDecimalCharacter,"] given.")),T.isNull(t.caretPositionOnFocus)||T.isInArray(t.caretPositionOnFocus,[V.options.caretPositionOnFocus.start,V.options.caretPositionOnFocus.end,V.options.caretPositionOnFocus.decimalLeft,V.options.caretPositionOnFocus.decimalRight])||T.throwError("The display on empty string option 'caretPositionOnFocus' is invalid ; it should either be `null`, 'focus', 'press', 'always' or 'zero', [".concat(t.caretPositionOnFocus,"] given.")),n=n?i:this._correctCaretPositionOnFocusAndSelectOnFocusOptions(e),T.isNull(n)||n.caretPositionOnFocus===V.options.caretPositionOnFocus.doNoForceCaretPosition||n.selectOnFocus!==V.options.selectOnFocus.select||T.warning("The 'selectOnFocus' option is set to 'select', which is in conflict with the 'caretPositionOnFocus' which is set to '".concat(n.caretPositionOnFocus,"'. As a result, if this has been called when instantiating an AutoNumeric object, the 'selectOnFocus' option is forced to 'doNotSelect'."),t.showWarnings),T.isInArray(t.digitGroupSeparator,[V.options.digitGroupSeparator.comma,V.options.digitGroupSeparator.dot,V.options.digitGroupSeparator.normalSpace,V.options.digitGroupSeparator.thinSpace,V.options.digitGroupSeparator.narrowNoBreakSpace,V.options.digitGroupSeparator.noBreakSpace,V.options.digitGroupSeparator.noSeparator,V.options.digitGroupSeparator.apostrophe,V.options.digitGroupSeparator.arabicThousandsSeparator,V.options.digitGroupSeparator.dotAbove,V.options.digitGroupSeparator.privateUseTwo])||T.throwError("The thousand separator character option 'digitGroupSeparator' is invalid ; it should be ',', '.', '٬', '˙', \"'\", '', ' ', ' ', ' ', ' ' or empty (''), [".concat(t.digitGroupSeparator,"] given.")),T.isTrueOrFalseString(t.showOnlyNumbersOnFocus)||T.isBoolean(t.showOnlyNumbersOnFocus)||T.throwError("The 'showOnlyNumbersOnFocus' option is invalid ; it should be either 'true' or 'false', [".concat(t.showOnlyNumbersOnFocus,"] given.")),T.isInArray(t.digitalGroupSpacing,[V.options.digitalGroupSpacing.two,V.options.digitalGroupSpacing.twoScaled,V.options.digitalGroupSpacing.three,V.options.digitalGroupSpacing.four])||2<=t.digitalGroupSpacing&&t.digitalGroupSpacing<=4||T.throwError("The grouping separator option for thousands 'digitalGroupSpacing' is invalid ; it should be '2', '2s', '3', or '4', [".concat(t.digitalGroupSpacing,"] given.")),T.isInArray(t.decimalCharacter,[V.options.decimalCharacter.comma,V.options.decimalCharacter.dot,V.options.decimalCharacter.middleDot,V.options.decimalCharacter.arabicDecimalSeparator,V.options.decimalCharacter.decimalSeparatorKeySymbol])||T.throwError("The decimal separator character option 'decimalCharacter' is invalid ; it should be '.', ',', '·', '⎖' or '٫', [".concat(t.decimalCharacter,"] given.")),t.decimalCharacter===t.digitGroupSeparator&&T.throwError("autoNumeric will not function properly when the decimal character 'decimalCharacter' [".concat(t.decimalCharacter,"] and the thousand separator 'digitGroupSeparator' [").concat(t.digitGroupSeparator,"] are the same character.")),T.isNull(t.decimalCharacterAlternative)||T.isString(t.decimalCharacterAlternative)||T.throwError("The alternate decimal separator character option 'decimalCharacterAlternative' is invalid ; it should be a string, [".concat(t.decimalCharacterAlternative,"] given.")),""===t.currencySymbol||T.isString(t.currencySymbol)||T.throwError("The currency symbol option 'currencySymbol' is invalid ; it should be a string, [".concat(t.currencySymbol,"] given.")),T.isInArray(t.currencySymbolPlacement,[V.options.currencySymbolPlacement.prefix,V.options.currencySymbolPlacement.suffix])||T.throwError("The placement of the currency sign option 'currencySymbolPlacement' is invalid ; it should either be 'p' (prefix) or 's' (suffix), [".concat(t.currencySymbolPlacement,"] given.")),T.isInArray(t.negativePositiveSignPlacement,[V.options.negativePositiveSignPlacement.prefix,V.options.negativePositiveSignPlacement.suffix,V.options.negativePositiveSignPlacement.left,V.options.negativePositiveSignPlacement.right,V.options.negativePositiveSignPlacement.none])||T.throwError("The placement of the negative sign option 'negativePositiveSignPlacement' is invalid ; it should either be 'p' (prefix), 's' (suffix), 'l' (left), 'r' (right) or 'null', [".concat(t.negativePositiveSignPlacement,"] given.")),T.isTrueOrFalseString(t.showPositiveSign)||T.isBoolean(t.showPositiveSign)||T.throwError("The show positive sign option 'showPositiveSign' is invalid ; it should be either 'true' or 'false', [".concat(t.showPositiveSign,"] given.")),T.isString(t.suffixText)&&(""===t.suffixText||!T.isNegative(t.suffixText,t.negativeSignCharacter)&&!o.test(t.suffixText))||T.throwError("The additional suffix option 'suffixText' is invalid ; it should not contains the negative sign '".concat(t.negativeSignCharacter,"' nor any numerical characters, [").concat(t.suffixText,"] given.")),T.isString(t.negativeSignCharacter)&&1===t.negativeSignCharacter.length&&!T.isUndefinedOrNullOrEmpty(t.negativeSignCharacter)&&!o.test(t.negativeSignCharacter)||T.throwError("The negative sign character option 'negativeSignCharacter' is invalid ; it should be a single character, and cannot be any numerical characters, [".concat(t.negativeSignCharacter,"] given.")),T.isString(t.positiveSignCharacter)&&1===t.positiveSignCharacter.length&&!T.isUndefinedOrNullOrEmpty(t.positiveSignCharacter)&&!o.test(t.positiveSignCharacter)||T.throwError("The positive sign character option 'positiveSignCharacter' is invalid ; it should be a single character, and cannot be any numerical characters, [".concat(t.positiveSignCharacter,"] given.\nIf you want to hide the positive sign character, you need to set the `showPositiveSign` option to `true`.")),t.negativeSignCharacter===t.positiveSignCharacter&&T.throwError("The positive 'positiveSignCharacter' and negative 'negativeSignCharacter' sign characters cannot be identical ; [".concat(t.negativeSignCharacter,"] given.")),y(T.isNull(t.negativeBracketsTypeOnBlur)?["",""]:t.negativeBracketsTypeOnBlur.split(","),2)),e=i[0],n=i[1];(T.contains(t.digitGroupSeparator,t.negativeSignCharacter)||T.contains(t.decimalCharacter,t.negativeSignCharacter)||T.contains(t.decimalCharacterAlternative,t.negativeSignCharacter)||T.contains(e,t.negativeSignCharacter)||T.contains(n,t.negativeSignCharacter)||T.contains(t.suffixText,t.negativeSignCharacter))&&T.throwError("The negative sign character option 'negativeSignCharacter' is invalid ; it should not be equal or a part of the digit separator, the decimal character, the decimal character alternative, the negative brackets or the suffix text, [".concat(t.negativeSignCharacter,"] given.")),(T.contains(t.digitGroupSeparator,t.positiveSignCharacter)||T.contains(t.decimalCharacter,t.positiveSignCharacter)||T.contains(t.decimalCharacterAlternative,t.positiveSignCharacter)||T.contains(e,t.positiveSignCharacter)||T.contains(n,t.positiveSignCharacter)||T.contains(t.suffixText,t.positiveSignCharacter))&&T.throwError("The positive sign character option 'positiveSignCharacter' is invalid ; it should not be equal or a part of the digit separator, the decimal character, the decimal character alternative, the negative brackets or the suffix text, [".concat(t.positiveSignCharacter,"] given.")),T.isNull(t.overrideMinMaxLimits)||T.isInArray(t.overrideMinMaxLimits,[V.options.overrideMinMaxLimits.ceiling,V.options.overrideMinMaxLimits.floor,V.options.overrideMinMaxLimits.ignore,V.options.overrideMinMaxLimits.invalid])||T.throwError("The override min & max limits option 'overrideMinMaxLimits' is invalid ; it should either be 'ceiling', 'floor', 'ignore' or 'invalid', [".concat(t.overrideMinMaxLimits,"] given.")),t.overrideMinMaxLimits!==V.options.overrideMinMaxLimits.invalid&&t.overrideMinMaxLimits!==V.options.overrideMinMaxLimits.ignore&&(0<t.minimumValue||t.maximumValue<0)&&T.warning("You've set a `minimumValue` or a `maximumValue` excluding the value `0`. AutoNumeric will force the users to always have a valid value in the input, hence preventing them to clear the field. If you want to allow for temporary invalid values (i.e. out-of-range), you should use the 'invalid' option for the 'overrideMinMaxLimits' setting."),T.isString(t.maximumValue)&&r.test(t.maximumValue)||T.throwError("The maximum possible value option 'maximumValue' is invalid ; it should be a string that represents a positive or negative number, [".concat(t.maximumValue,"] given.")),T.isString(t.minimumValue)&&r.test(t.minimumValue)||T.throwError("The minimum possible value option 'minimumValue' is invalid ; it should be a string that represents a positive or negative number, [".concat(t.minimumValue,"] given.")),parseFloat(t.minimumValue)>parseFloat(t.maximumValue)&&T.throwError("The minimum possible value option is greater than the maximum possible value option ; 'minimumValue' [".concat(t.minimumValue,"] should be smaller than 'maximumValue' [").concat(t.maximumValue,"].")),T.isInt(t.decimalPlaces)&&0<=t.decimalPlaces||T.isString(t.decimalPlaces)&&a.test(t.decimalPlaces)||T.throwError("The number of decimal places option 'decimalPlaces' is invalid ; it should be a positive integer, [".concat(t.decimalPlaces,"] given.")),T.isNull(t.decimalPlacesRawValue)||T.isInt(t.decimalPlacesRawValue)&&0<=t.decimalPlacesRawValue||T.isString(t.decimalPlacesRawValue)&&a.test(t.decimalPlacesRawValue)||T.throwError("The number of decimal places for the raw value option 'decimalPlacesRawValue' is invalid ; it should be a positive integer or `null`, [".concat(t.decimalPlacesRawValue,"] given.")),this._validateDecimalPlacesRawValue(t),T.isNull(t.decimalPlacesShownOnFocus)||a.test(String(t.decimalPlacesShownOnFocus))||T.throwError("The number of expanded decimal places option 'decimalPlacesShownOnFocus' is invalid ; it should be a positive integer or `null`, [".concat(t.decimalPlacesShownOnFocus,"] given.")),!T.isNull(t.decimalPlacesShownOnFocus)&&Number(t.decimalPlaces)>Number(t.decimalPlacesShownOnFocus)&&T.warning("The extended decimal places 'decimalPlacesShownOnFocus' [".concat(t.decimalPlacesShownOnFocus,"] should be greater than the 'decimalPlaces' [").concat(t.decimalPlaces,"] value. Currently, this will limit the ability of your user to manually change some of the decimal places. Do you really want to do that?"),t.showWarnings),(T.isNull(t.divisorWhenUnfocused)||s.test(t.divisorWhenUnfocused))&&0!==t.divisorWhenUnfocused&&"0"!==t.divisorWhenUnfocused&&1!==t.divisorWhenUnfocused&&"1"!==t.divisorWhenUnfocused||T.throwError("The divisor option 'divisorWhenUnfocused' is invalid ; it should be a positive number higher than one, preferably an integer, [".concat(t.divisorWhenUnfocused,"] given.")),T.isNull(t.decimalPlacesShownOnBlur)||a.test(t.decimalPlacesShownOnBlur)||T.throwError("The number of decimals shown when unfocused option 'decimalPlacesShownOnBlur' is invalid ; it should be a positive integer or `null`, [".concat(t.decimalPlacesShownOnBlur,"] given.")),T.isNull(t.symbolWhenUnfocused)||T.isString(t.symbolWhenUnfocused)||T.throwError("The symbol to show when unfocused option 'symbolWhenUnfocused' is invalid ; it should be a string, [".concat(t.symbolWhenUnfocused,"] given.")),T.isTrueOrFalseString(t.saveValueToSessionStorage)||T.isBoolean(t.saveValueToSessionStorage)||T.throwError("The save to session storage option 'saveValueToSessionStorage' is invalid ; it should be either 'true' or 'false', [".concat(t.saveValueToSessionStorage,"] given.")),T.isInArray(t.onInvalidPaste,[V.options.onInvalidPaste.error,V.options.onInvalidPaste.ignore,V.options.onInvalidPaste.clamp,V.options.onInvalidPaste.truncate,V.options.onInvalidPaste.replace])||T.throwError("The paste behavior option 'onInvalidPaste' is invalid ; it should either be 'error', 'ignore', 'clamp', 'truncate' or 'replace' (cf. documentation), [".concat(t.onInvalidPaste,"] given.")),T.isInArray(t.roundingMethod,[V.options.roundingMethod.halfUpSymmetric,V.options.roundingMethod.halfUpAsymmetric,V.options.roundingMethod.halfDownSymmetric,V.options.roundingMethod.halfDownAsymmetric,V.options.roundingMethod.halfEvenBankersRounding,V.options.roundingMethod.upRoundAwayFromZero,V.options.roundingMethod.downRoundTowardZero,V.options.roundingMethod.toCeilingTowardPositiveInfinity,V.options.roundingMethod.toFloorTowardNegativeInfinity,V.options.roundingMethod.toNearest05,V.options.roundingMethod.toNearest05Alt,V.options.roundingMethod.upToNext05,V.options.roundingMethod.downToNext05])||T.throwError("The rounding method option 'roundingMethod' is invalid ; it should either be 'S', 'A', 's', 'a', 'B', 'U', 'D', 'C', 'F', 'N05', 'CHF', 'U05' or 'D05' (cf. documentation), [".concat(t.roundingMethod,"] given.")),T.isNull(t.negativeBracketsTypeOnBlur)||T.isInArray(t.negativeBracketsTypeOnBlur,[V.options.negativeBracketsTypeOnBlur.parentheses,V.options.negativeBracketsTypeOnBlur.brackets,V.options.negativeBracketsTypeOnBlur.chevrons,V.options.negativeBracketsTypeOnBlur.curlyBraces,V.options.negativeBracketsTypeOnBlur.angleBrackets,V.options.negativeBracketsTypeOnBlur.japaneseQuotationMarks,V.options.negativeBracketsTypeOnBlur.halfBrackets,V.options.negativeBracketsTypeOnBlur.whiteSquareBrackets,V.options.negativeBracketsTypeOnBlur.quotationMarks,V.options.negativeBracketsTypeOnBlur.guillemets])||T.throwError("The brackets for negative values option 'negativeBracketsTypeOnBlur' is invalid ; it should either be '(,)', '[,]', '<,>', '{,}', '〈,〉', '｢,｣', '⸤,⸥', '⟦,⟧', '‹,›' or '«,»', [".concat(t.negativeBracketsTypeOnBlur,"] given.")),(T.isString(t.emptyInputBehavior)||T.isNumber(t.emptyInputBehavior))&&(T.isInArray(t.emptyInputBehavior,[V.options.emptyInputBehavior.focus,V.options.emptyInputBehavior.press,V.options.emptyInputBehavior.always,V.options.emptyInputBehavior.min,V.options.emptyInputBehavior.max,V.options.emptyInputBehavior.zero,V.options.emptyInputBehavior.null])||r.test(t.emptyInputBehavior))||T.throwError("The display on empty string option 'emptyInputBehavior' is invalid ; it should either be 'focus', 'press', 'always', 'min', 'max', 'zero', 'null', a number, or a string that represents a number, [".concat(t.emptyInputBehavior,"] given.")),t.emptyInputBehavior===V.options.emptyInputBehavior.zero&&(0<t.minimumValue||t.maximumValue<0)&&T.throwError("The 'emptyInputBehavior' option is set to 'zero', but this value is outside of the range defined by 'minimumValue' and 'maximumValue' [".concat(t.minimumValue,", ").concat(t.maximumValue,"].")),r.test(String(t.emptyInputBehavior))&&!this._isWithinRangeWithOverrideOption(t.emptyInputBehavior,t)&&T.throwError("The 'emptyInputBehavior' option is set to a number or a string that represents a number, but its value [".concat(t.emptyInputBehavior,"] is outside of the range defined by the 'minimumValue' and 'maximumValue' options [").concat(t.minimumValue,", ").concat(t.maximumValue,"].")),T.isTrueOrFalseString(t.eventBubbles)||T.isBoolean(t.eventBubbles)||T.throwError("The event bubbles option 'eventBubbles' is invalid ; it should be either 'true' or 'false', [".concat(t.eventBubbles,"] given.")),T.isTrueOrFalseString(t.eventIsCancelable)||T.isBoolean(t.eventIsCancelable)||T.throwError("The event is cancelable option 'eventIsCancelable' is invalid ; it should be either 'true' or 'false', [".concat(t.eventIsCancelable,"] given.")),!T.isBoolean(t.invalidClass)&&/^-?[_a-zA-Z]+[_a-zA-Z0-9-]*$/.test(t.invalidClass)||T.throwError("The name of the 'invalidClass' option is not a valid CSS class name ; it should not be empty, and should follow the '^-?[_a-zA-Z]+[_a-zA-Z0-9-]*$' regex, [".concat(t.invalidClass,"] given.")),T.isInArray(t.leadingZero,[V.options.leadingZero.allow,V.options.leadingZero.deny,V.options.leadingZero.keep])||T.throwError("The leading zero behavior option 'leadingZero' is invalid ; it should either be 'allow', 'deny' or 'keep', [".concat(t.leadingZero,"] given.")),T.isTrueOrFalseString(t.formatOnPageLoad)||T.isBoolean(t.formatOnPageLoad)||T.throwError("The format on initialization option 'formatOnPageLoad' is invalid ; it should be either 'true' or 'false', [".concat(t.formatOnPageLoad,"] given.")),T.isTrueOrFalseString(t.formulaMode)||T.isBoolean(t.formulaMode)||T.throwError("The formula mode option 'formulaMode' is invalid ; it should be either 'true' or 'false', [".concat(t.formulaMode,"] given.")),a.test(t.historySize)&&0!==t.historySize||T.throwError("The history size option 'historySize' is invalid ; it should be a positive integer, [".concat(t.historySize,"] given.")),T.isTrueOrFalseString(t.selectNumberOnly)||T.isBoolean(t.selectNumberOnly)||T.throwError("The select number only option 'selectNumberOnly' is invalid ; it should be either 'true' or 'false', [".concat(t.selectNumberOnly,"] given.")),T.isTrueOrFalseString(t.selectOnFocus)||T.isBoolean(t.selectOnFocus)||T.throwError("The select on focus option 'selectOnFocus' is invalid ; it should be either 'true' or 'false', [".concat(t.selectOnFocus,"] given.")),T.isNull(t.defaultValueOverride)||""===t.defaultValueOverride||r.test(t.defaultValueOverride)||T.throwError("The unformatted default value option 'defaultValueOverride' is invalid ; it should be a string that represents a positive or negative number, [".concat(t.defaultValueOverride,"] given.")),T.isTrueOrFalseString(t.unformatOnSubmit)||T.isBoolean(t.unformatOnSubmit)||T.throwError("The remove formatting on submit option 'unformatOnSubmit' is invalid ; it should be either 'true' or 'false', [".concat(t.unformatOnSubmit,"] given.")),T.isNull(t.valuesToStrings)||T.isObject(t.valuesToStrings)||T.throwError("The option 'valuesToStrings' is invalid ; it should be an object, ideally with 'key -> value' entries, [".concat(t.valuesToStrings,"] given.")),T.isNull(t.outputFormat)||T.isInArray(t.outputFormat,[V.options.outputFormat.string,V.options.outputFormat.number,V.options.outputFormat.dot,V.options.outputFormat.negativeDot,V.options.outputFormat.comma,V.options.outputFormat.negativeComma,V.options.outputFormat.dotNegative,V.options.outputFormat.commaNegative])||T.throwError("The custom locale format option 'outputFormat' is invalid ; it should either be null, 'string', 'number', '.', '-.', ',', '-,', '.-' or ',-', [".concat(t.outputFormat,"] given.")),T.isTrueOrFalseString(t.isCancellable)||T.isBoolean(t.isCancellable)||T.throwError("The cancellable behavior option 'isCancellable' is invalid ; it should be either 'true' or 'false', [".concat(t.isCancellable,"] given.")),T.isTrueOrFalseString(t.modifyValueOnWheel)||T.isBoolean(t.modifyValueOnWheel)||T.throwError("The increment/decrement on mouse wheel option 'modifyValueOnWheel' is invalid ; it should be either 'true' or 'false', [".concat(t.modifyValueOnWheel,"] given.")),T.isTrueOrFalseString(t.watchExternalChanges)||T.isBoolean(t.watchExternalChanges)||T.throwError("The option 'watchExternalChanges' is invalid ; it should be either 'true' or 'false', [".concat(t.watchExternalChanges,"] given.")),T.isInArray(t.wheelOn,[V.options.wheelOn.focus,V.options.wheelOn.hover])||T.throwError("The wheel behavior option 'wheelOn' is invalid ; it should either be 'focus' or 'hover', [".concat(t.wheelOn,"] given.")),(T.isString(t.wheelStep)||T.isNumber(t.wheelStep))&&("progressive"===t.wheelStep||s.test(t.wheelStep))&&0!==Number(t.wheelStep)||T.throwError("The wheel step value option 'wheelStep' is invalid ; it should either be the string 'progressive', or a number or a string that represents a positive number (excluding zero), [".concat(t.wheelStep,"] given.")),T.isInArray(t.serializeSpaces,[V.options.serializeSpaces.plus,V.options.serializeSpaces.percent])||T.throwError("The space replacement character option 'serializeSpaces' is invalid ; it should either be '+' or '%20', [".concat(t.serializeSpaces,"] given.")),T.isTrueOrFalseString(t.noEventListeners)||T.isBoolean(t.noEventListeners)||T.throwError("The option 'noEventListeners' that prevent the creation of event listeners is invalid ; it should be either 'true' or 'false', [".concat(t.noEventListeners,"] given.")),T.isNull(t.styleRules)||T.isObject(t.styleRules)&&(Object.prototype.hasOwnProperty.call(t.styleRules,"positive")||Object.prototype.hasOwnProperty.call(t.styleRules,"negative")||Object.prototype.hasOwnProperty.call(t.styleRules,"ranges")||Object.prototype.hasOwnProperty.call(t.styleRules,"userDefined"))||T.throwError("The option 'styleRules' is invalid ; it should be a correctly structured object, with one or more 'positive', 'negative', 'ranges' or 'userDefined' attributes, [".concat(t.styleRules,"] given.")),T.isNull(t.styleRules)||!Object.prototype.hasOwnProperty.call(t.styleRules,"userDefined")||T.isNull(t.styleRules.userDefined)||t.styleRules.userDefined.forEach(function(e){Object.prototype.hasOwnProperty.call(e,"callback")&&!T.isFunction(e.callback)&&T.throwError("The callback defined in the `userDefined` attribute is not a function, ".concat(b(e.callback)," given."))}),(T.isNull(t.rawValueDivisor)||s.test(t.rawValueDivisor))&&0!==t.rawValueDivisor&&"0"!==t.rawValueDivisor&&1!==t.rawValueDivisor&&"1"!==t.rawValueDivisor||T.throwError("The raw value divisor option 'rawValueDivisor' is invalid ; it should be a positive number higher than one, preferably an integer, [".concat(t.rawValueDivisor,"] given.")),T.isTrueOrFalseString(t.readOnly)||T.isBoolean(t.readOnly)||T.throwError("The option 'readOnly' is invalid ; it should be either 'true' or 'false', [".concat(t.readOnly,"] given.")),T.isTrueOrFalseString(t.unformatOnHover)||T.isBoolean(t.unformatOnHover)||T.throwError("The option 'unformatOnHover' is invalid ; it should be either 'true' or 'false', [".concat(t.unformatOnHover,"] given.")),T.isTrueOrFalseString(t.failOnUnknownOption)||T.isBoolean(t.failOnUnknownOption)||T.throwError("The debug option 'failOnUnknownOption' is invalid ; it should be either 'true' or 'false', [".concat(t.failOnUnknownOption,"] given.")),T.isTrueOrFalseString(t.createLocalList)||T.isBoolean(t.createLocalList)||T.throwError("The debug option 'createLocalList' is invalid ; it should be either 'true' or 'false', [".concat(t.createLocalList,"] given."))}},{key:"_validateDecimalPlacesRawValue",value:function(e){T.isNull(e.decimalPlacesRawValue)||(e.decimalPlacesRawValue<e.decimalPlaces&&T.warning("The number of decimal places to store in the raw value [".concat(e.decimalPlacesRawValue,"] is lower than the ones to display [").concat(e.decimalPlaces,"]. This will likely confuse your users.\nTo solve that, you'd need to either set `decimalPlacesRawValue` to `null`, or set a number of decimal places for the raw value equal of bigger than `decimalPlaces`."),e.showWarnings),e.decimalPlacesRawValue<e.decimalPlacesShownOnFocus&&T.warning("The number of decimal places to store in the raw value [".concat(e.decimalPlacesRawValue,"] is lower than the ones shown on focus [").concat(e.decimalPlacesShownOnFocus,"]. This will likely confuse your users.\nTo solve that, you'd need to either set `decimalPlacesRawValue` to `null`, or set a number of decimal places for the raw value equal of bigger than `decimalPlacesShownOnFocus`."),e.showWarnings),e.decimalPlacesRawValue<e.decimalPlacesShownOnBlur&&T.warning("The number of decimal places to store in the raw value [".concat(e.decimalPlacesRawValue,"] is lower than the ones shown when unfocused [").concat(e.decimalPlacesShownOnBlur,"]. This will likely confuse your users.\nTo solve that, you'd need to either set `decimalPlacesRawValue` to `null`, or set a number of decimal places for the raw value equal of bigger than `decimalPlacesShownOnBlur`."),e.showWarnings))}},{key:"areSettingsValid",value:function(e){var t=!0;try{this.validate(e,!0)}catch(e){t=!1}return t}},{key:"getDefaultConfig",value:function(){return V.defaultSettings}},{key:"getPredefinedOptions",value:function(){return V.predefinedOptions}},{key:"_generateOptionsObjectFromOptionsArray",value:function(e){var t,i=this;return T.isUndefinedOrNullOrEmpty(e)||0===e.length?t=null:(t={},1===e.length&&Array.isArray(e[0])?e[0].forEach(function(e){S(t,i._getOptionObject(e))}):1<=e.length&&e.forEach(function(e){S(t,i._getOptionObject(e))})),t}},{key:"format",value:function(e){if(T.isUndefined(e)||null===e)return null;e=T.isElement(e)?T.getElementValue(e):e;T.isString(e)||T.isNumber(e)||T.throwError('The value "'.concat(e,'" being "set" is not numeric and therefore cannot be used appropriately.'));for(var t=arguments.length,i=new Array(1<t?t-1:0),n=1;n<t;n++)i[n-1]=arguments[n];var a=this._generateOptionsObjectFromOptionsArray(i),a=S({},this.getDefaultConfig(),a),o=(a.isNegativeSignAllowed=e<0,a.isPositiveSignAllowed=0<=e,this._setBrackets(a),this._cachesUsualRegularExpressions(a,{}),this._toNumericValue(e,a));return isNaN(Number(o))&&T.throwError("The value [".concat(o,"] that you are trying to format is not a recognized number.")),this._isWithinRangeWithOverrideOption(o,a)||(T.triggerEvent(V.events.formatted,document,{oldValue:null,newValue:null,oldRawValue:null,newRawValue:null,isPristine:null,error:"Range test failed",aNElement:null},!0,!0),T.throwError("The value [".concat(o,"] being set falls outside of the minimumValue [").concat(a.minimumValue,"] and maximumValue [").concat(a.maximumValue,"] range set for this element"))),a.valuesToStrings&&this._checkValuesToStringsSettings(e,a)?a.valuesToStrings[e]:(this._correctNegativePositiveSignPlacementOption(a),this._calculateDecimalPlacesOnInit(a),T.isUndefinedOrNullOrEmpty(a.rawValueDivisor)||0===a.rawValueDivisor||""===o||null===o||(o*=a.rawValueDivisor),o=this._roundFormattedValueShownOnFocus(o,a),o=this._modifyNegativeSignAndDecimalCharacterForFormattedValue(o,a),this._addGroupSeparators(o,a,!1,o))}},{key:"formatAndSet",value:function(e){var t=this.format(e,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null);return T.setElementValue(e,t),t}},{key:"unformat",value:function(e){if(T.isNumberStrict(e))return e;e=T.isElement(e)?T.getElementValue(e):e;if(""===e)return"";if(T.isUndefined(e)||null===e)return null;(T.isArray(e)||T.isObject(e))&&T.throwError("A number or a string representing a number is needed to be able to unformat it, [".concat(e,"] given."));for(var t=arguments.length,i=new Array(1<t?t-1:0),n=1;n<t;n++)i[n-1]=arguments[n];var a,o=this._generateOptionsObjectFromOptionsArray(i),o=S({},this.getDefaultConfig(),o);return o.isNegativeSignAllowed=!1,o.isPositiveSignAllowed=!0,e=e.toString(),o.valuesToStrings&&this._checkStringsToValuesSettings(e,o)?T.objectKeyLookup(o.valuesToStrings,e):(T.isNegative(e,o.negativeSignCharacter)?(o.isNegativeSignAllowed=!0,o.isPositiveSignAllowed=!1):T.isNull(o.negativeBracketsTypeOnBlur)||(a=y(o.negativeBracketsTypeOnBlur.split(","),2),o.firstBracket=a[0],o.lastBracket=a[1],e.charAt(0)===o.firstBracket&&e.charAt(e.length-1)===o.lastBracket&&(o.isNegativeSignAllowed=!0,o.isPositiveSignAllowed=!1,e=this._removeBrackets(e,o,!1))),e=this._convertToNumericString(e,o),T.isNumber(Number(e))&&(e=T.scientificToDecimal(e)),new RegExp("[^+-0123456789.]","gi").test(e)?NaN:(this._correctNegativePositiveSignPlacementOption(o),o.decimalPlacesRawValue?o.originalDecimalPlacesRawValue=o.decimalPlacesRawValue:o.originalDecimalPlacesRawValue=o.decimalPlaces,this._calculateDecimalPlacesOnInit(o),T.isUndefinedOrNullOrEmpty(o.rawValueDivisor)||0===o.rawValueDivisor||""===e||null===e||(e/=o.rawValueDivisor),e=(e=this._roundRawValue(e,o)).replace(o.decimalCharacter,"."),this._toLocale(e,o.outputFormat,o)))}},{key:"unformatAndSet",value:function(e){var t=this.unformat(e,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null);return T.setElementValue(e,t),t}},{key:"localize",value:function(e){var t,i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,e=T.isElement(e)?T.getElementValue(e):e;return""===e?"":(T.isNull(i)&&(i=V.defaultSettings),e=this.unformat(e,i),0===Number(e)&&i.leadingZero!==V.options.leadingZero.keep&&(e="0"),t=(T.isNull(i)?i:V.defaultSettings).outputFormat,this._toLocale(e,t,i))}},{key:"localizeAndSet",value:function(e){var t=this.localize(e,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null);return T.setElementValue(e,t),t}},{key:"isManagedByAutoNumeric",value:function(e){return this._isInGlobalList(T.domElement(e))}},{key:"getAutoNumericElement",value:function(e){e=T.domElement(e);return this.isManagedByAutoNumeric(e)?this._getFromGlobalList(e):null}},{key:"set",value:function(e,t){var i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,n=!(3<arguments.length&&void 0!==arguments[3])||arguments[3],e=T.domElement(e);return this.isManagedByAutoNumeric(e)?this.getAutoNumericElement(e).set(t,i,n):(e=!(!T.isNull(i)&&Object.prototype.hasOwnProperty.call(i,"showWarnings"))||i.showWarnings,T.warning("Impossible to find an AutoNumeric object for the given DOM element or selector.",e),null)}},{key:"getNumericString",value:function(e){return this._get(e,"getNumericString",1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"getFormatted",value:function(e){return this._get(e,"getFormatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"getNumber",value:function(e){return this._get(e,"getNumber",1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"_get",value:function(e,t){var i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,e=T.domElement(e);return this.isManagedByAutoNumeric(e)||T.throwError("Impossible to find an AutoNumeric object for the given DOM element or selector."),this.getAutoNumericElement(e)[t](i)}},{key:"getLocalized",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,e=T.domElement(e);return this.isManagedByAutoNumeric(e)||T.throwError("Impossible to find an AutoNumeric object for the given DOM element or selector."),this.getAutoNumericElement(e).getLocalized(t,i)}},{key:"_stripAllNonNumberCharacters",value:function(e,t,i,n){return this._stripAllNonNumberCharactersExceptCustomDecimalChar(e,t,i,n).replace(t.decimalCharacter,".")}},{key:"_stripAllNonNumberCharactersExceptCustomDecimalChar",value:function(e,t,i,n){var a,o,r=(e=(e=this._normalizeCurrencySuffixAndNegativeSignCharacters(e,t)).replace(t.allowedAutoStrip,"")).match(t.numRegAutoStrip);return e=r?[r[1],r[2],r[3]].join(""):"",t.leadingZero!==V.options.leadingZero.allow&&t.leadingZero!==V.options.leadingZero.keep||(r="",o=(a=y(e.split(t.decimalCharacter),2))[0],a=a[1],T.contains(o=o,t.negativeSignCharacter)&&(r=t.negativeSignCharacter,o=o.replace(t.negativeSignCharacter,"")),""===r&&o.length>t.mIntPos&&"0"===o.charAt(0)&&(o=o.slice(1)),""!==r&&o.length>t.mIntNeg&&"0"===o.charAt(0)&&(o=o.slice(1)),e="".concat(r).concat(o).concat(T.isUndefined(a)?"":t.decimalCharacter+a)),i&&t.leadingZero===V.options.leadingZero.deny||!n&&t.leadingZero===V.options.leadingZero.allow?e.replace(t.stripReg,"$1$2"):e}},{key:"_toggleNegativeBracket",value:function(e,t,i){return i?this._removeBrackets(e,t):this._addBrackets(e,t)}},{key:"_addBrackets",value:function(e,t){return T.isNull(t.negativeBracketsTypeOnBlur)?e:"".concat(t.firstBracket).concat(e.replace(t.negativeSignCharacter,"")).concat(t.lastBracket)}},{key:"_removeBrackets",value:function(e,t){var i=!(2<arguments.length&&void 0!==arguments[2])||arguments[2],n=T.isNull(t.negativeBracketsTypeOnBlur)||e.charAt(0)!==t.firstBracket?e:(n=(n=e.replace(t.firstBracket,"")).replace(t.lastBracket,""),i?(n=n.replace(t.currencySymbol,""),this._mergeCurrencySignNegativePositiveSignAndValue(n,t,!0,!1)):"".concat(t.negativeSignCharacter).concat(n));return n}},{key:"_setBrackets",value:function(e){var t,i;T.isNull(e.negativeBracketsTypeOnBlur)?(e.firstBracket="",e.lastBracket=""):(t=(i=y(e.negativeBracketsTypeOnBlur.split(","),2))[0],i=i[1],e.firstBracket=t,e.lastBracket=i)}},{key:"_convertToNumericString",value:function(e,t){e=this._removeBrackets(e,t,!1),e=(e=this._normalizeCurrencySuffixAndNegativeSignCharacters(e,t)).replace(new RegExp("[".concat(t.digitGroupSeparator,"]"),"g"),""),"."!==t.decimalCharacter&&(e=e.replace(t.decimalCharacter,".")),T.isNegative(e)&&e.lastIndexOf("-")===e.length-1&&(e=e.replace("-",""),e="-".concat(e)),t.showPositiveSign&&(e=e.replace(t.positiveSignCharacter,""));t=t.leadingZero!==V.options.leadingZero.keep,t=T.arabicToLatinNumbers(e,t,!1,!1);return isNaN(t)?e:t.toString()}},{key:"_normalizeCurrencySuffixAndNegativeSignCharacters",value:function(e,t){return e=String(e),t.currencySymbol!==V.options.currencySymbol.none&&(e=e.replace(t.currencySymbol,"")),t.suffixText!==V.options.suffixText.none&&(e=e.replace(t.suffixText,"")),t.negativeSignCharacter!==V.options.negativeSignCharacter.hyphen?e.replace(t.negativeSignCharacter,"-"):e}},{key:"_toLocale",value:function(e,t,i){if(T.isNull(t)||t===V.options.outputFormat.string)return e;var n;switch(t){case V.options.outputFormat.number:n=Number(e);break;case V.options.outputFormat.dotNegative:n=T.isNegative(e)?e.replace("-","")+"-":e;break;case V.options.outputFormat.comma:case V.options.outputFormat.negativeComma:n=e.replace(".",",");break;case V.options.outputFormat.commaNegative:n=e.replace(".",","),n=T.isNegative(n)?n.replace("-","")+"-":n;break;case V.options.outputFormat.dot:case V.options.outputFormat.negativeDot:n=e;break;default:T.throwError("The given outputFormat [".concat(t,"] option is not recognized."))}return t!==V.options.outputFormat.number&&"-"!==i.negativeSignCharacter?n.replace("-",i.negativeSignCharacter):n}},{key:"_modifyNegativeSignAndDecimalCharacterForFormattedValue",value:function(e,t){return"-"!==t.negativeSignCharacter&&(e=e.replace("-",t.negativeSignCharacter)),"."!==t.decimalCharacter?e.replace(".",t.decimalCharacter):e}},{key:"_isElementValueEmptyOrOnlyTheNegativeSign",value:function(e,t){return""===e||e===t.negativeSignCharacter}},{key:"_orderValueCurrencySymbolAndSuffixText",value:function(e,t,i){var n;if(t.emptyInputBehavior===V.options.emptyInputBehavior.always||i)switch(t.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.left:case V.options.negativePositiveSignPlacement.prefix:case V.options.negativePositiveSignPlacement.none:n=e+t.currencySymbol+t.suffixText;break;default:n=t.currencySymbol+e+t.suffixText}else n=e;return n}},{key:"_addGroupSeparators",value:function(e,t,i,n){var a=4<arguments.length&&void 0!==arguments[4]?arguments[4]:null,o=T.isNull(a)?T.isNegative(e,t.negativeSignCharacter)||T.isNegativeWithBrackets(e,t.firstBracket,t.lastBracket):a<0;if(e=this._stripAllNonNumberCharactersExceptCustomDecimalChar(e,t,!1,i),this._isElementValueEmptyOrOnlyTheNegativeSign(e,t))return this._orderValueCurrencySymbolAndSuffixText(e,t,!0);var r,s=T.isZeroOrHasNoValue(e);switch(o&&(e=e.replace("-","")),t.digitalGroupSpacing=t.digitalGroupSpacing.toString(),t.digitalGroupSpacing){case V.options.digitalGroupSpacing.two:r=/(\d)((\d)(\d{2}?)+)$/;break;case V.options.digitalGroupSpacing.twoScaled:r=/(\d)((?:\d{2}){0,2}\d{3}(?:(?:\d{2}){2}\d{3})*?)$/;break;case V.options.digitalGroupSpacing.four:r=/(\d)((\d{4}?)+)$/;break;default:V.options.digitalGroupSpacing.three,r=/(\d)((\d{3}?)+)$/}var l,c=y(e.split(t.decimalCharacter),2),u=c[0],c=c[1];if(t.decimalCharacterAlternative&&T.isUndefined(c)&&(u=(l=y(e.split(t.decimalCharacterAlternative),2))[0],c=l[1]),""!==t.digitGroupSeparator)for(;r.test(u);)u=u.replace(r,"$1".concat(t.digitGroupSeparator,"$2"));return e=0===(l=i?t.decimalPlacesShownOnFocus:t.decimalPlacesShownOnBlur)||T.isUndefined(c)?u:(c.length>l&&(c=c.substring(0,l)),"".concat(u).concat(t.decimalCharacter).concat(c)),e=V._mergeCurrencySignNegativePositiveSignAndValue(e,t,o,s),T.isNull(a)&&(a=n),null!==t.negativeBracketsTypeOnBlur&&(a<0||T.isNegativeStrict(e,t.negativeSignCharacter))&&(e=this._toggleNegativeBracket(e,t,i)),t.suffixText?"".concat(e).concat(t.suffixText):e}},{key:"_mergeCurrencySignNegativePositiveSignAndValue",value:function(e,t,i,n){var a,o="";if(i?o=t.negativeSignCharacter:t.showPositiveSign&&!n&&(o=t.positiveSignCharacter),t.currencySymbolPlacement===V.options.currencySymbolPlacement.prefix)if(t.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&t.showPositiveSign&&!n))switch(t.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.prefix:case V.options.negativePositiveSignPlacement.left:a="".concat(o).concat(t.currencySymbol).concat(e);break;case V.options.negativePositiveSignPlacement.right:a="".concat(t.currencySymbol).concat(o).concat(e);break;case V.options.negativePositiveSignPlacement.suffix:a="".concat(t.currencySymbol).concat(e).concat(o)}else a=t.currencySymbol+e;else if(t.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix)if(t.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&t.showPositiveSign&&!n))switch(t.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.suffix:case V.options.negativePositiveSignPlacement.right:a="".concat(e).concat(t.currencySymbol).concat(o);break;case V.options.negativePositiveSignPlacement.left:a="".concat(e).concat(o).concat(t.currencySymbol);break;case V.options.negativePositiveSignPlacement.prefix:a="".concat(o).concat(e).concat(t.currencySymbol)}else a=e+t.currencySymbol;return a}},{key:"_truncateZeros",value:function(e,t){var i;switch(t){case 0:i=/(\.(?:\d*[1-9])?)0*$/;break;case 1:i=/(\.\d(?:\d*[1-9])?)0*$/;break;default:i=new RegExp("(\\.\\d{".concat(t,"}(?:\\d*[1-9])?)0*"))}return e=e.replace(i,"$1"),0===t?e.replace(/\.$/,""):e}},{key:"_roundRawValue",value:function(e,t){return this._roundValue(e,t,t.decimalPlacesRawValue)}},{key:"_roundFormattedValueShownOnFocus",value:function(e,t){return this._roundValue(e,t,Number(t.decimalPlacesShownOnFocus))}},{key:"_roundFormattedValueShownOnBlur",value:function(e,t){return this._roundValue(e,t,Number(t.decimalPlacesShownOnBlur))}},{key:"_roundFormattedValueShownOnFocusOrBlur",value:function(e,t,i){return i?this._roundFormattedValueShownOnFocus(e,t):this._roundFormattedValueShownOnBlur(e,t)}},{key:"_roundValue",value:function(e,t,i){if(T.isNull(e))return e;if(e=""===e?"0":e.toString(),t.roundingMethod===V.options.roundingMethod.toNearest05||t.roundingMethod===V.options.roundingMethod.toNearest05Alt||t.roundingMethod===V.options.roundingMethod.upToNext05||t.roundingMethod===V.options.roundingMethod.downToNext05)return this._roundCloseTo05(e,t);var n=y(V._prepareValueForRounding(e,t),2),a=n[0],n=(e=n[1]).lastIndexOf("."),o=-1===n,r=y(e.split("."),2),s=r[0];if(!(0<r[1]||t.allowDecimalPadding!==V.options.allowDecimalPadding.never&&t.allowDecimalPadding!==V.options.allowDecimalPadding.floats))return 0===Number(e)?s:"".concat(a).concat(s);var l=t.allowDecimalPadding===V.options.allowDecimalPadding.always||t.allowDecimalPadding===V.options.allowDecimalPadding.floats?i:0<t.allowDecimalPadding?t.allowDecimalPadding:0,r=o?e.length-1:n,c=e.length-1-r,u="";if(c<=i)if(u=e,c<l){o&&(u="".concat(u).concat(t.decimalCharacter));for(var h="000000";c<l;)u+=h=h.substring(0,l-c),c+=h.length}else l<c?u=this._truncateZeros(u,l):0===c&&0===l&&(u=u.replace(/\.$/,""));else{var s=o?i-1:Number(i)+Number(n),r=Number(e.charAt(s+1)),m=e.substring(0,s+1).split(""),o="."===e.charAt(s)?e.charAt(s-1)%2:e.charAt(s)%2;if(this._shouldRoundUp(r,t,a,o))for(var g=m.length-1;0<=g;--g)if("."!==m[g]){if(m[g]=+m[g]+1,m[g]<10)break;0<g&&(m[g]="0")}m=m.slice(0,s+1),u=this._truncateZeros(m.join(""),l)}return 0===Number(u)?u:"".concat(a).concat(u)}},{key:"_roundCloseTo05",value:function(e,t){switch(t.roundingMethod){case V.options.roundingMethod.toNearest05:case V.options.roundingMethod.toNearest05Alt:e=(Math.round(20*e)/20).toString();break;case V.options.roundingMethod.upToNext05:e=(Math.ceil(20*e)/20).toString();break;default:e=(Math.floor(20*e)/20).toString()}return T.contains(e,".")?e.length-e.indexOf(".")<3?e+"0":e:e+".00"}},{key:"_prepareValueForRounding",value:function(e,t){var i="";return(e=T.isNegativeStrict(e,"-")?e.replace(i="-",""):e).match(/^\d/)||(e="0".concat(e)),[i=0===Number(e)?"":i,e=0<Number(e)&&t.leadingZero!==V.options.leadingZero.keep||0<e.length&&t.leadingZero===V.options.leadingZero.allow?e.replace(/^0*(\d)/,"$1"):e]}},{key:"_shouldRoundUp",value:function(e,t,i,n){return 4<e&&t.roundingMethod===V.options.roundingMethod.halfUpSymmetric||4<e&&t.roundingMethod===V.options.roundingMethod.halfUpAsymmetric&&""===i||5<e&&t.roundingMethod===V.options.roundingMethod.halfUpAsymmetric&&"-"===i||5<e&&t.roundingMethod===V.options.roundingMethod.halfDownSymmetric||5<e&&t.roundingMethod===V.options.roundingMethod.halfDownAsymmetric&&""===i||4<e&&t.roundingMethod===V.options.roundingMethod.halfDownAsymmetric&&"-"===i||5<e&&t.roundingMethod===V.options.roundingMethod.halfEvenBankersRounding||5===e&&t.roundingMethod===V.options.roundingMethod.halfEvenBankersRounding&&1===n||0<e&&t.roundingMethod===V.options.roundingMethod.toCeilingTowardPositiveInfinity&&""===i||0<e&&t.roundingMethod===V.options.roundingMethod.toFloorTowardNegativeInfinity&&"-"===i||0<e&&t.roundingMethod===V.options.roundingMethod.upRoundAwayFromZero}},{key:"_truncateDecimalPlaces",value:function(e,t,i,n){var i=y((e=i?this._roundFormattedValueShownOnFocus(e,t):e).split(t.decimalCharacter),2),a=i[0],i=i[1];return i&&i.length>n?0<n?(i=i.substring(0,n),"".concat(a).concat(t.decimalCharacter).concat(i)):a:e}},{key:"_checkIfInRangeWithOverrideOption",value:function(e,t){if(T.isNull(e)&&t.emptyInputBehavior===V.options.emptyInputBehavior.null||t.overrideMinMaxLimits===V.options.overrideMinMaxLimits.ignore||t.overrideMinMaxLimits===V.options.overrideMinMaxLimits.invalid)return[!0,!0];e=(e=e.toString()).replace(",",".");var i,n=T.parseStr(t.minimumValue),a=T.parseStr(t.maximumValue),o=T.parseStr(e);switch(t.overrideMinMaxLimits){case V.options.overrideMinMaxLimits.floor:i=[-1<T.testMinMax(n,o),!0];break;case V.options.overrideMinMaxLimits.ceiling:i=[!0,T.testMinMax(a,o)<1];break;default:i=[-1<T.testMinMax(n,o),T.testMinMax(a,o)<1]}return i}},{key:"_isWithinRangeWithOverrideOption",value:function(e,t){e=y(this._checkIfInRangeWithOverrideOption(e,t),2),t=e[0],e=e[1];return t&&e}},{key:"_cleanValueForRangeParse",value:function(e){return e=e.toString().replace(",","."),T.parseStr(e)}},{key:"_isMinimumRangeRespected",value:function(e,t){return-1<T.testMinMax(T.parseStr(t.minimumValue),this._cleanValueForRangeParse(e))}},{key:"_isMaximumRangeRespected",value:function(e,t){return T.testMinMax(T.parseStr(t.maximumValue),this._cleanValueForRangeParse(e))<1}},{key:"_readCookie",value:function(e){for(var t=e+"=",i=document.cookie.split(";"),n="",a=0;a<i.length;a+=1){for(n=i[a];" "===n.charAt(0);)n=n.substring(1,n.length);if(0===n.indexOf(t))return n.substring(t.length,n.length)}return null}},{key:"_storageTest",value:function(){var e="modernizr";try{return sessionStorage.setItem(e,e),sessionStorage.removeItem(e),!0}catch(e){return!1}}},{key:"_correctNegativePositiveSignPlacementOption",value:function(e){if(T.isNull(e.negativePositiveSignPlacement))if(T.isUndefined(e)||!T.isUndefinedOrNullOrEmpty(e.negativePositiveSignPlacement)||T.isUndefinedOrNullOrEmpty(e.currencySymbol))e.negativePositiveSignPlacement=V.options.negativePositiveSignPlacement.left;else switch(e.currencySymbolPlacement){case V.options.currencySymbolPlacement.suffix:e.negativePositiveSignPlacement=V.options.negativePositiveSignPlacement.prefix;break;case V.options.currencySymbolPlacement.prefix:e.negativePositiveSignPlacement=V.options.negativePositiveSignPlacement.left}}},{key:"_correctCaretPositionOnFocusAndSelectOnFocusOptions",value:function(e){return T.isNull(e)?null:(!T.isUndefinedOrNullOrEmpty(e.caretPositionOnFocus)&&T.isUndefinedOrNullOrEmpty(e.selectOnFocus)&&(e.selectOnFocus=V.options.selectOnFocus.doNotSelect),T.isUndefinedOrNullOrEmpty(e.caretPositionOnFocus)&&!T.isUndefinedOrNullOrEmpty(e.selectOnFocus)&&e.selectOnFocus===V.options.selectOnFocus.select&&(e.caretPositionOnFocus=V.options.caretPositionOnFocus.doNoForceCaretPosition),e)}},{key:"_calculateDecimalPlacesOnInit",value:function(e){this._validateDecimalPlacesRawValue(e),e.decimalPlacesShownOnFocus===V.options.decimalPlacesShownOnFocus.useDefault&&(e.decimalPlacesShownOnFocus=e.decimalPlaces),e.decimalPlacesShownOnBlur===V.options.decimalPlacesShownOnBlur.useDefault&&(e.decimalPlacesShownOnBlur=e.decimalPlaces),e.decimalPlacesRawValue===V.options.decimalPlacesRawValue.useDefault&&(e.decimalPlacesRawValue=e.decimalPlaces);var t=0;e.rawValueDivisor&&e.rawValueDivisor!==V.options.rawValueDivisor.none&&(t=String(e.rawValueDivisor).length-1)<0&&(t=0),e.decimalPlacesRawValue=Math.max(Math.max(e.decimalPlacesShownOnBlur,e.decimalPlacesShownOnFocus)+t,Number(e.originalDecimalPlacesRawValue)+t)}},{key:"_calculateDecimalPlacesOnUpdate",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,i=(this._validateDecimalPlacesRawValue(e),T.isNull(t)&&T.throwError("When updating the settings, the previous ones should be passed as an argument."),"decimalPlaces"in e);(i||"decimalPlacesRawValue"in e||"decimalPlacesShownOnFocus"in e||"decimalPlacesShownOnBlur"in e||"rawValueDivisor"in e)&&(i?("decimalPlacesShownOnFocus"in e&&e.decimalPlacesShownOnFocus!==V.options.decimalPlacesShownOnFocus.useDefault||(e.decimalPlacesShownOnFocus=e.decimalPlaces),"decimalPlacesShownOnBlur"in e&&e.decimalPlacesShownOnBlur!==V.options.decimalPlacesShownOnBlur.useDefault||(e.decimalPlacesShownOnBlur=e.decimalPlaces),"decimalPlacesRawValue"in e&&e.decimalPlacesRawValue!==V.options.decimalPlacesRawValue.useDefault||(e.decimalPlacesRawValue=e.decimalPlaces)):(T.isUndefined(e.decimalPlacesShownOnFocus)&&(e.decimalPlacesShownOnFocus=t.decimalPlacesShownOnFocus),T.isUndefined(e.decimalPlacesShownOnBlur)&&(e.decimalPlacesShownOnBlur=t.decimalPlacesShownOnBlur)),i=0,e.rawValueDivisor&&e.rawValueDivisor!==V.options.rawValueDivisor.none&&(i=String(e.rawValueDivisor).length-1)<0&&(i=0),e.decimalPlaces||e.decimalPlacesRawValue?e.decimalPlacesRawValue=Math.max(Math.max(e.decimalPlacesShownOnBlur,e.decimalPlacesShownOnFocus)+i,Number(e.decimalPlacesRawValue)+i):e.decimalPlacesRawValue=Math.max(Math.max(e.decimalPlacesShownOnBlur,e.decimalPlacesShownOnFocus)+i,Number(t.originalDecimalPlacesRawValue)+i))}},{key:"_cachesUsualRegularExpressions",value:function(e,t){var i=e.negativeSignCharacter!==V.options.negativeSignCharacter.hyphen?"([-\\".concat(e.negativeSignCharacter,"]?)"):"(-?)";t.aNegRegAutoStrip=i,e.allowedAutoStrip=new RegExp("[^-0123456789\\".concat(e.decimalCharacter,"]"),"g"),e.numRegAutoStrip=new RegExp("".concat(i,"(?:\\").concat(e.decimalCharacter,"?([0-9]+\\").concat(e.decimalCharacter,"[0-9]+)|([0-9]*(?:\\").concat(e.decimalCharacter,"[0-9]*)?))")),e.stripReg=new RegExp("^".concat(t.aNegRegAutoStrip,"0*([0-9])")),e.formulaChars=new RegExp("[0-9".concat(e.decimalCharacter,"+\\-*/() ]"))}},{key:"_convertOldOptionsToNewOnes",value:function(e){var t,i={aSep:"digitGroupSeparator",nSep:"showOnlyNumbersOnFocus",dGroup:"digitalGroupSpacing",aDec:"decimalCharacter",altDec:"decimalCharacterAlternative",aSign:"currencySymbol",pSign:"currencySymbolPlacement",pNeg:"negativePositiveSignPlacement",aSuffix:"suffixText",oLimits:"overrideMinMaxLimits",vMax:"maximumValue",vMin:"minimumValue",mDec:"decimalPlacesOverride",eDec:"decimalPlacesShownOnFocus",scaleDecimal:"decimalPlacesShownOnBlur",aStor:"saveValueToSessionStorage",mRound:"roundingMethod",aPad:"allowDecimalPadding",nBracket:"negativeBracketsTypeOnBlur",wEmpty:"emptyInputBehavior",lZero:"leadingZero",aForm:"formatOnPageLoad",sNumber:"selectNumberOnly",anDefault:"defaultValueOverride",unSetOnSubmit:"unformatOnSubmit",outputType:"outputFormat",debug:"showWarnings",allowDecimalPadding:!0,alwaysAllowDecimalCharacter:!0,caretPositionOnFocus:!0,createLocalList:!0,currencySymbol:!0,currencySymbolPlacement:!0,decimalCharacter:!0,decimalCharacterAlternative:!0,decimalPlaces:!0,decimalPlacesRawValue:!0,decimalPlacesShownOnBlur:!0,decimalPlacesShownOnFocus:!0,defaultValueOverride:!0,digitalGroupSpacing:!0,digitGroupSeparator:!0,divisorWhenUnfocused:!0,emptyInputBehavior:!0,eventBubbles:!0,eventIsCancelable:!0,failOnUnknownOption:!0,formatOnPageLoad:!0,formulaMode:!0,historySize:!0,isCancellable:!0,leadingZero:!0,maximumValue:!0,minimumValue:!0,modifyValueOnWheel:!0,negativeBracketsTypeOnBlur:!0,negativePositiveSignPlacement:!0,negativeSignCharacter:!0,noEventListeners:!0,onInvalidPaste:!0,outputFormat:!0,overrideMinMaxLimits:!0,positiveSignCharacter:!0,rawValueDivisor:!0,readOnly:!0,roundingMethod:!0,saveValueToSessionStorage:!0,selectNumberOnly:!0,selectOnFocus:!0,serializeSpaces:!0,showOnlyNumbersOnFocus:!0,showPositiveSign:!0,showWarnings:!0,styleRules:!0,suffixText:!0,symbolWhenUnfocused:!0,unformatOnHover:!0,unformatOnSubmit:!0,valuesToStrings:!0,watchExternalChanges:!0,wheelOn:!0,wheelStep:!0,allowedAutoStrip:!0,formulaChars:!0,isNegativeSignAllowed:!0,isPositiveSignAllowed:!0,mIntNeg:!0,mIntPos:!0,numRegAutoStrip:!0,originalDecimalPlaces:!0,originalDecimalPlacesRawValue:!0,stripReg:!0};for(t in e)Object.prototype.hasOwnProperty.call(e,t)&&!0!==i[t]&&(Object.prototype.hasOwnProperty.call(i,t)?(T.warning("You are using the deprecated option name '".concat(t,"'. Please use '").concat(i[t],"' instead from now on. The old option name will be dropped very soon™."),!0),e[i[t]]=e[t],delete e[t]):e.failOnUnknownOption&&T.throwError("Option name '".concat(t,"' is unknown. Please fix the options passed to autoNumeric")));"mDec"in e&&T.warning("The old `mDec` option has been deprecated in favor of more accurate options ; `decimalPlaces`, `decimalPlacesRawValue`, `decimalPlacesShownOnFocus` and `decimalPlacesShownOnBlur`.",!0)}},{key:"_setNegativePositiveSignPermissions",value:function(e){e.isNegativeSignAllowed=e.minimumValue<0,e.isPositiveSignAllowed=0<=e.maximumValue}},{key:"_toNumericValue",value:function(e,t){var i;return T.isNumber(Number(e))?i=T.scientificToDecimal(e):(i=this._convertToNumericString(e.toString(),t),T.isNumber(Number(i))||(T.warning('The given value "'.concat(e,'" cannot be converted to a numeric one and therefore cannot be used appropriately.'),t.showWarnings),i=NaN)),i}},{key:"_checkIfInRange",value:function(e,t,i){e=T.parseStr(e);return-1<T.testMinMax(t,e)&&T.testMinMax(i,e)<1}},{key:"_shouldSkipEventKey",value:function(e){var t=T.isInArray(e,u.keyName._allFnKeys),i=e===u.keyName.OSLeft||e===u.keyName.OSRight,n=e===u.keyName.ContextMenu,a=T.isInArray(e,u.keyName._someNonPrintableKeys),o=e===u.keyName.NumLock||e===u.keyName.ScrollLock||e===u.keyName.Insert||e===u.keyName.Command,e=e===u.keyName.Unidentified;return t||i||n||a||e||o}},{key:"_serialize",value:function(e){var t,n=this,a=1<arguments.length&&void 0!==arguments[1]&&arguments[1],o=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"unformatted",i=3<arguments.length&&void 0!==arguments[3]?arguments[3]:"+",r=4<arguments.length&&void 0!==arguments[4]?arguments[4]:null,s=[];return"object"===b(e)&&"form"===e.nodeName.toLowerCase()&&Array.prototype.slice.call(e.elements).forEach(function(t){if(t.name&&!t.disabled&&-1===["file","reset","submit","button"].indexOf(t.type))if("select-multiple"===t.type)Array.prototype.slice.call(t.options).forEach(function(e){e.selected&&s.push(a?{name:t.name,value:e.value}:"".concat(encodeURIComponent(t.name),"=").concat(encodeURIComponent(e.value)))});else if(-1===["checkbox","radio"].indexOf(t.type)||t.checked){var e;if(n.isManagedByAutoNumeric(t))switch(o){case"unformatted":i=n.getAutoNumericElement(t),T.isNull(i)||(e=n.unformat(t,i.getSettings()));break;case"localized":var i=n.getAutoNumericElement(t);T.isNull(i)||(i=T.cloneObject(i.getSettings()),T.isNull(r)||(i.outputFormat=r),e=n.localize(t,i));break;default:e=t.value}else e=t.value;T.isUndefined(e)&&T.throwError("This error should never be hit. If it has, something really wrong happened!"),s.push(a?{name:t.name,value:e}:"".concat(encodeURIComponent(t.name),"=").concat(encodeURIComponent(e)))}}),a?t=s:(t=s.join("&"),"+"===i&&(t=t.replace(/%20/g,"+"))),t}},{key:"_serializeNumericString",value:function(e){return this._serialize(e,!1,"unformatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeFormatted",value:function(e){return this._serialize(e,!1,"formatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeLocalized",value:function(e){return this._serialize(e,!1,"localized",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+",2<arguments.length&&void 0!==arguments[2]?arguments[2]:null)}},{key:"_serializeNumericStringArray",value:function(e){return this._serialize(e,!0,"unformatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeFormattedArray",value:function(e){return this._serialize(e,!0,"formatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeLocalizedArray",value:function(e){return this._serialize(e,!0,"localized",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+",2<arguments.length&&void 0!==arguments[2]?arguments[2]:null)}}];return K(e.prototype,[{key:"_saveInitialValues",value:function(e){this.initialValueHtmlAttribute=T.scientificToDecimal(this.domElement.getAttribute("value")),T.isNull(this.initialValueHtmlAttribute)&&(this.initialValueHtmlAttribute=""),this.initialValue=e,T.isNull(this.initialValue)&&(this.initialValue="")}},{key:"_createEventListeners",value:function(){var t=this;this.formulaMode=!1,this._onFocusInFunc=function(e){t._onFocusIn(e)},this._onFocusInAndMouseEnterFunc=function(e){t._onFocusInAndMouseEnter(e)},this._onFocusFunc=function(){t._onFocus()},this._onKeydownFunc=function(e){t._onKeydown(e)},this._onKeypressFunc=function(e){t._onKeypress(e)},this._onKeyupFunc=function(e){t._onKeyup(e)},this._onFocusOutAndMouseLeaveFunc=function(e){t._onFocusOutAndMouseLeave(e)},this._onPasteFunc=function(e){t._onPaste(e)},this._onWheelFunc=function(e){t._onWheel(e)},this._onDropFunc=function(e){t._onDrop(e)},this._onKeydownGlobalFunc=function(e){t._onKeydownGlobal(e)},this._onKeyupGlobalFunc=function(e){t._onKeyupGlobal(e)},this.domElement.addEventListener("focusin",this._onFocusInFunc,!1),this.domElement.addEventListener("focus",this._onFocusInAndMouseEnterFunc,!1),this.domElement.addEventListener("focus",this._onFocusFunc,!1),this.domElement.addEventListener("mouseenter",this._onFocusInAndMouseEnterFunc,!1),this.domElement.addEventListener("keydown",this._onKeydownFunc,!1),this.domElement.addEventListener("keypress",this._onKeypressFunc,!1),this.domElement.addEventListener("keyup",this._onKeyupFunc,!1),this.domElement.addEventListener("blur",this._onFocusOutAndMouseLeaveFunc,!1),this.domElement.addEventListener("mouseleave",this._onFocusOutAndMouseLeaveFunc,!1),this.domElement.addEventListener("paste",this._onPasteFunc,!1),this.domElement.addEventListener("wheel",this._onWheelFunc,!1),this.domElement.addEventListener("drop",this._onDropFunc,!1),this._setupFormListener(),this.hasEventListeners=!0,V._doesGlobalListExists()||(document.addEventListener("keydown",this._onKeydownGlobalFunc,!1),document.addEventListener("keyup",this._onKeyupGlobalFunc,!1))}},{key:"_removeEventListeners",value:function(){this.domElement.removeEventListener("focusin",this._onFocusInFunc,!1),this.domElement.removeEventListener("focus",this._onFocusInAndMouseEnterFunc,!1),this.domElement.removeEventListener("focus",this._onFocusFunc,!1),this.domElement.removeEventListener("mouseenter",this._onFocusInAndMouseEnterFunc,!1),this.domElement.removeEventListener("blur",this._onFocusOutAndMouseLeaveFunc,!1),this.domElement.removeEventListener("mouseleave",this._onFocusOutAndMouseLeaveFunc,!1),this.domElement.removeEventListener("keydown",this._onKeydownFunc,!1),this.domElement.removeEventListener("keypress",this._onKeypressFunc,!1),this.domElement.removeEventListener("keyup",this._onKeyupFunc,!1),this.domElement.removeEventListener("paste",this._onPasteFunc,!1),this.domElement.removeEventListener("wheel",this._onWheelFunc,!1),this.domElement.removeEventListener("drop",this._onDropFunc,!1),this._removeFormListener(),this.hasEventListeners=!1,document.removeEventListener("keydown",this._onKeydownGlobalFunc,!1),document.removeEventListener("keyup",this._onKeyupGlobalFunc,!1)}},{key:"_updateEventListeners",value:function(){this.settings.noEventListeners||this.hasEventListeners||this._createEventListeners(),this.settings.noEventListeners&&this.hasEventListeners&&this._removeEventListeners()}},{key:"_setupFormListener",value:function(){var e=this;T.isNull(this.parentForm)||(this._onFormSubmitFunc=function(){e._onFormSubmit()},this._onFormResetFunc=function(){e._onFormReset()},this._hasParentFormCounter()?this._incrementParentFormCounter():(this._initializeFormCounterToOne(),this.parentForm.addEventListener("submit",this._onFormSubmitFunc,!1),this.parentForm.addEventListener("reset",this._onFormResetFunc,!1),this._storeFormHandlerFunction()))}},{key:"_removeFormListener",value:function(){var e;T.isNull(this.parentForm)||(1===(e=this._getParentFormCounter())?(this.parentForm.removeEventListener("submit",this._getFormHandlerFunction().submitFn,!1),this.parentForm.removeEventListener("reset",this._getFormHandlerFunction().resetFn,!1),this._removeFormDataSetInfo()):1<e?this._decrementParentFormCounter():T.throwError("The AutoNumeric object count on the form is incoherent."))}},{key:"_hasParentFormCounter",value:function(){return"anCount"in this.parentForm.dataset}},{key:"_getParentFormCounter",value:function(){return Number(this.parentForm.dataset.anCount)}},{key:"_initializeFormCounterToOne",value:function(){this._getFormElement(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null).dataset.anCount=1}},{key:"_incrementParentFormCounter",value:function(){this._getFormElement(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null).dataset.anCount++}},{key:"_decrementParentFormCounter",value:function(){this.parentForm.dataset.anCount--}},{key:"_hasFormHandlerFunction",value:function(){return"anFormHandler"in this._getFormElement(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null).dataset}},{key:"_getFormElement",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return T.isNull(e)?this.parentForm:e}},{key:"_storeFormHandlerFunction",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=(this.constructor._doesFormHandlerListExists()||this.constructor._createFormHandlerList(),T.randomString());this._getFormElement(e).dataset.anFormHandler=t,window.aNFormHandlerMap.set(t,{submitFn:this._onFormSubmitFunc,resetFn:this._onFormResetFunc})}},{key:"_getFormHandlerKey",value:function(){this._hasFormHandlerFunction()||T.throwError("Unable to retrieve the form handler name");var e=this.parentForm.dataset.anFormHandler;return""===e&&T.throwError("The form handler name is invalid"),e}},{key:"_getFormHandlerFunction",value:function(){var e=this._getFormHandlerKey();return window.aNFormHandlerMap.get(e)}},{key:"_removeFormDataSetInfo",value:function(){this._decrementParentFormCounter(),window.aNFormHandlerMap.delete(this._getFormHandlerKey()),this.parentForm.removeAttribute("data-an-count"),this.parentForm.removeAttribute("data-an-form-handler")}},{key:"_setWritePermissions",value:function(){0<arguments.length&&void 0!==arguments[0]&&arguments[0]&&this.domElement.readOnly||this.settings.readOnly?this._setReadOnly():this._setReadWrite()}},{key:"_setReadOnly",value:function(){this.isInputElement?this.domElement.readOnly=!0:this.domElement.setAttribute("contenteditable",!1)}},{key:"_setReadWrite",value:function(){this.isInputElement?this.domElement.readOnly=!1:this.domElement.setAttribute("contenteditable",!0)}},{key:"_addWatcher",value:function(){var e,t,i,n=this;T.isUndefined(this.getterSetter)||(e=this.getterSetter,t=e.set,i=e.get,Object.defineProperty(this.domElement,this.attributeToWatch,{configurable:!0,get:function(){return i.call(n.domElement)},set:function(e){t.call(n.domElement,e),n.settings.watchExternalChanges&&!n.internalModification&&n.set(e)}}))}},{key:"_removeWatcher",value:function(){var e,t,i,n=this;T.isUndefined(this.getterSetter)||(e=this.getterSetter,t=e.set,i=e.get,Object.defineProperty(this.domElement,this.attributeToWatch,{configurable:!0,get:function(){return i.call(n.domElement)},set:function(e){t.call(n.domElement,e)}}))}},{key:"_getAttributeToWatch",value:function(){var e,t;return this.isInputElement?e="value":(t=this.domElement.nodeType)===Node.ELEMENT_NODE||t===Node.DOCUMENT_NODE||t===Node.DOCUMENT_FRAGMENT_NODE?e="textContent":t===Node.TEXT_NODE&&(e="nodeValue"),e}},{key:"_historyTableAdd",value:function(){var e,t=0===this.historyTable.length;(t||this.rawValue!==this._historyTableCurrentValueUsed())&&(e=!0,t||((t=this.historyTableIndex+1)<this.historyTable.length&&this.rawValue===this.historyTable[t].value?e=!1:T.arrayTrim(this.historyTable,this.historyTableIndex+1)),this.historyTableIndex++,e&&(t=T.getElementSelection(this.domElement),this.selectionStart=t.start,this.selectionEnd=t.end,this.historyTable.push({value:this.rawValue,start:this.selectionStart+1,end:this.selectionEnd+1}),1<this.historyTable.length)&&(this.historyTable[this.historyTableIndex-1].start=this.selectionStart,this.historyTable[this.historyTableIndex-1].end=this.selectionEnd),this.historyTable.length>this.settings.historySize)&&this._historyTableForget()}},{key:"_historyTableUndoOrRedo",value:function(){var e;0<arguments.length&&void 0!==arguments[0]&&!arguments[0]?(e=this.historyTableIndex+1<this.historyTable.length)&&this.historyTableIndex++:(e=0<this.historyTableIndex)&&this.historyTableIndex--,e&&(e=this.historyTable[this.historyTableIndex],this.set(e.value,null,!1),T.setElementSelection(this.domElement,e.start,e.end))}},{key:"_historyTableUndo",value:function(){this._historyTableUndoOrRedo(!0)}},{key:"_historyTableRedo",value:function(){this._historyTableUndoOrRedo(!1)}},{key:"_historyTableForget",value:function(){for(var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:1,t=[],i=0;i<e;i++)t.push(this.historyTable.shift()),this.historyTableIndex--,this.historyTableIndex<0&&(this.historyTableIndex=0);return 1===t.length?t[0]:t}},{key:"_historyTableCurrentValueUsed",value:function(){var e=this.historyTableIndex;return T.isUndefinedOrNullOrEmpty(this.historyTable[e=e<0?0:e])?"":this.historyTable[e].value}},{key:"_parseStyleRules",value:function(){var n=this;T.isUndefinedOrNullOrEmpty(this.settings.styleRules)||""===this.rawValue||(T.isUndefinedOrNullOrEmpty(this.settings.styleRules.positive)||(0<=this.rawValue?this._addCSSClass(this.settings.styleRules.positive):this._removeCSSClass(this.settings.styleRules.positive)),T.isUndefinedOrNullOrEmpty(this.settings.styleRules.negative)||(this.rawValue<0?this._addCSSClass(this.settings.styleRules.negative):this._removeCSSClass(this.settings.styleRules.negative)),T.isUndefinedOrNullOrEmpty(this.settings.styleRules.ranges)||0===this.settings.styleRules.ranges.length||this.settings.styleRules.ranges.forEach(function(e){n.rawValue>=e.min&&n.rawValue<e.max?n._addCSSClass(e.class):n._removeCSSClass(e.class)}),T.isUndefinedOrNullOrEmpty(this.settings.styleRules.userDefined))||0===this.settings.styleRules.userDefined.length||this.settings.styleRules.userDefined.forEach(function(e){var i;T.isFunction(e.callback)?T.isString(e.classes)?e.callback(n.rawValue)?n._addCSSClass(e.classes):n._removeCSSClass(e.classes):T.isArray(e.classes)?2===e.classes.length?e.callback(n.rawValue)?(n._addCSSClass(e.classes[0]),n._removeCSSClass(e.classes[1])):(n._removeCSSClass(e.classes[0]),n._addCSSClass(e.classes[1])):2<e.classes.length?(i=e.callback(n.rawValue),T.isArray(i)?e.classes.forEach(function(e,t){T.isInArray(t,i)?n._addCSSClass(e):n._removeCSSClass(e)}):T.isInt(i)?e.classes.forEach(function(e,t){t===i?n._addCSSClass(e):n._removeCSSClass(e)}):T.isNull(i)?e.classes.forEach(function(e){n._removeCSSClass(e)}):T.throwError("The callback result is not an array nor a valid array index, ".concat(b(i)," given."))):T.throwError("The classes attribute is not valid for the `styleRules` option."):T.isUndefinedOrNullOrEmpty(e.classes)?e.callback(n):T.throwError("The callback/classes structure is not valid for the `styleRules` option."):T.warning("The given `styleRules` callback is not a function, ".concat(b(e.callback)," given."),n.settings.showWarnings)})}},{key:"_addCSSClass",value:function(e){this.domElement.classList.add(e)}},{key:"_removeCSSClass",value:function(e){this.domElement.classList.remove(e)}},{key:"update",value:function(){for(var t=this,e=arguments.length,i=new Array(e),n=0;n<e;n++)i[n]=arguments[n];Array.isArray(i)&&Array.isArray(i[0])&&(i=i[0]);var a=T.cloneObject(this.settings),o=this.rawValue,r={};T.isUndefinedOrNullOrEmpty(i)||0===i.length?r=null:1<=i.length&&i.forEach(function(e){t.constructor._isPreDefinedOptionValid(e)&&(e=t.constructor._getOptionObject(e)),S(r,e)});try{this._setSettings(r,!0),this._setWritePermissions(),this._updateEventListeners(),this.set(o)}catch(e){this._setSettings(a,!0),T.throwError("Unable to update the settings, those are invalid: [".concat(e,"]"))}return this}},{key:"getSettings",value:function(){return this.settings}},{key:"set",value:function(e){var t,i,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,a=!(2<arguments.length&&void 0!==arguments[2])||arguments[2];if(T.isUndefined(e))T.warning("You are trying to set an 'undefined' value ; an error could have occurred.",this.settings.showWarnings);else if(T.isNull(n)||this._setSettings(n,!0),null===e&&this.settings.emptyInputBehavior!==V.options.emptyInputBehavior.null)T.warning("You are trying to set the `null` value while the `emptyInputBehavior` option is set to ".concat(this.settings.emptyInputBehavior,". If you want to be able to set the `null` value, you need to change the 'emptyInputBehavior' option to `'null'`."),this.settings.showWarnings);else if(null===e)this._setElementAndRawValue(null,null,a),this._saveValueToPersistentStorage();else if(t=this.constructor._toNumericValue(e,this.settings),isNaN(Number(t)))T.warning("The value you are trying to set results in `NaN`. The element value is set to the empty string instead.",this.settings.showWarnings),this.setValue("",a);else{if(""===t)switch(this.settings.emptyInputBehavior){case V.options.emptyInputBehavior.zero:t=0;break;case V.options.emptyInputBehavior.min:t=this.settings.minimumValue;break;case V.options.emptyInputBehavior.max:t=this.settings.maximumValue;break;default:T.isNumber(this.settings.emptyInputBehavior)&&(t=Number(this.settings.emptyInputBehavior))}""!==t?(e=(n=y(this.constructor._checkIfInRangeWithOverrideOption(t,this.settings),2))[0],n=n[1],e&&n&&this.settings.valuesToStrings&&this._checkValuesToStrings(t)?(this._setElementAndRawValue(this.settings.valuesToStrings[t],t,a),this._saveValueToPersistentStorage()):(T.isZeroOrHasNoValue(t)&&(t="0"),e&&n?(i=this.constructor._roundRawValue(t,this.settings),i=this._trimLeadingAndTrailingZeros(i.replace(this.settings.decimalCharacter,".")),t=this._getRawValueToFormat(t),t=this.isFocused?this.constructor._roundFormattedValueShownOnFocus(t,this.settings):(this.settings.divisorWhenUnfocused&&(t=(t/=this.settings.divisorWhenUnfocused).toString()),this.constructor._roundFormattedValueShownOnBlur(t,this.settings)),t=this.constructor._modifyNegativeSignAndDecimalCharacterForFormattedValue(t,this.settings),t=this.constructor._addGroupSeparators(t,this.settings,this.isFocused,this.rawValue,i),!this.isFocused&&this.settings.symbolWhenUnfocused&&(t="".concat(t).concat(this.settings.symbolWhenUnfocused)),(this.settings.decimalPlacesShownOnFocus||this.settings.divisorWhenUnfocused)&&this._saveValueToPersistentStorage(),this._setElementAndRawValue(t,i,a),this._setValidOrInvalidState(i)):(this._triggerRangeEvents(e,n),T.throwError("The value [".concat(t,"] being set falls outside of the minimumValue [").concat(this.settings.minimumValue,"] and maximumValue [").concat(this.settings.maximumValue,"] range set for this element")),this._removeValueFromPersistentStorage(),this.setValue("",a)))):(i=this.settings.emptyInputBehavior===V.options.emptyInputBehavior.always?this.settings.currencySymbol:"",this._setElementAndRawValue(i,"",a))}return this}},{key:"setUnformatted",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;return null===e||T.isUndefined(e)||(T.isNull(t)||this._setSettings(t,!0),t=this.constructor._removeBrackets(e,this.settings),t=this.constructor._stripAllNonNumberCharacters(t,this.settings,!0,this.isFocused),T.isNumber(t)||T.throwError("The value is not a valid one, it's not a numeric string nor a recognized currency."),this.constructor._isWithinRangeWithOverrideOption(t,this.settings)?this.setValue(e):T.throwError("The value is out of the range limits [".concat(this.settings.minimumValue,", ").concat(this.settings.maximumValue,"]."))),this}},{key:"setValue",value:function(e){return this._setElementAndRawValue(e,!(1<arguments.length&&void 0!==arguments[1])||arguments[1]),this}},{key:"_setRawValue",value:function(e){var t,i=!(1<arguments.length&&void 0!==arguments[1])||arguments[1];this.rawValue!==e&&(t=this.rawValue,this.rawValue=e,!T.isNull(this.settings.rawValueDivisor)&&0!==this.settings.rawValueDivisor&&""!==e&&null!==e&&this._isUserManuallyEditingTheValue()&&(this.rawValue/=this.settings.rawValueDivisor),this._triggerEvent(V.events.rawValueModified,this.domElement,{oldRawValue:t,newRawValue:this.rawValue,isPristine:this.isPristine(!0),error:null,aNElement:this}),this._parseStyleRules(),i)&&this._historyTableAdd()}},{key:"_setElementValue",value:function(e){var t=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],i=T.getElementValue(this.domElement);return e!==i&&(this.internalModification=!0,T.setElementValue(this.domElement,e),this.internalModification=!1,t)&&this._triggerEvent(V.events.formatted,this.domElement,{oldValue:i,newValue:e,oldRawValue:this.rawValue,newRawValue:this.rawValue,isPristine:this.isPristine(!1),error:null,aNElement:this}),this}},{key:"_setElementAndRawValue",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,i=!(2<arguments.length&&void 0!==arguments[2])||arguments[2];return T.isNull(t)?t=e:T.isBoolean(t)&&(i=t,t=e),this._setElementValue(e),this._setRawValue(t,i),this}},{key:"_getRawValueToFormat",value:function(e){return T.isNull(this.settings.rawValueDivisor)||0===this.settings.rawValueDivisor||""===e||null===e?e:e*this.settings.rawValueDivisor}},{key:"_checkValuesToStrings",value:function(e){return this.constructor._checkValuesToStringsArray(e,this.valuesToStringsKeys)}},{key:"_isUserManuallyEditingTheValue",value:function(){return this.isFocused&&this.isEditing||this.isDropEvent}},{key:"_executeCallback",value:function(e,t){!T.isNull(t)&&T.isFunction(t)&&t(e,this)}},{key:"_triggerEvent",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:document;T.triggerEvent(e,t,2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,this.settings.eventBubbles,this.settings.eventIsCancelable)}},{key:"get",value:function(){return this.getNumericString(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null)}},{key:"getNumericString",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=T.isNull(this.rawValue)?null:T.trimPaddedZerosFromDecimalPlaces(this.rawValue);return this._executeCallback(t,e),t}},{key:"getFormatted",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=("value"in this.domElement||"textContent"in this.domElement||T.throwError("Unable to get the formatted string from the element."),T.getElementValue(this.domElement));return this._executeCallback(t,e),t}},{key:"getNumber",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=null===this.rawValue?null:this.constructor._toLocale(this.getNumericString(),"number",this.settings);return this._executeCallback(t,e),t}},{key:"getLocalized",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,i=(T.isFunction(e)&&T.isNull(t)&&(t=e,e=null),(i=T.isEmptyString(this.rawValue)?"":""+Number(this.rawValue))&&0===Number(i)&&this.settings.leadingZero!==V.options.leadingZero.keep&&(i="0"),e=T.isNull(e)?this.settings.outputFormat:e,this.constructor._toLocale(i,e,this.settings));return this._executeCallback(i,t),i}},{key:"reformat",value:function(){return this.set(this.rawValue),this}},{key:"unformat",value:function(){return this._setElementValue(this.getNumericString()),this}},{key:"unformatLocalized",value:function(){return this._setElementValue(this.getLocalized(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null)),this}},{key:"isPristine",value:function(){return 0<arguments.length&&void 0!==arguments[0]&&!arguments[0]?this.initialValueHtmlAttribute===this.getFormatted():this.initialValue===this.getNumericString()}},{key:"select",value:function(){return this.settings.selectNumberOnly?this.selectNumber():this._defaultSelectAll(),this}},{key:"_defaultSelectAll",value:function(){T.setElementSelection(this.domElement,0,T.getElementValue(this.domElement).length)}},{key:"selectNumber",value:function(){var e,t=T.getElementValue(this.domElement),i=t.length,n=this.settings.currencySymbol.length,a=this.settings.currencySymbolPlacement,o=T.isNegative(t,this.settings.negativeSignCharacter)?1:0,r=this.settings.suffixText.length,t=a===V.options.currencySymbolPlacement.suffix?0:this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.left&&1==o&&0<n?n+1:n;if(a===V.options.currencySymbolPlacement.prefix)e=i-r;else switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.left:e=i-(r+n);break;case V.options.negativePositiveSignPlacement.right:e=0<n?i-(n+o+r):i-(n+r);break;default:e=i-(n+r)}return T.setElementSelection(this.domElement,t,e),this}},{key:"selectInteger",value:function(){var e=0,t=0<=this.rawValue,i=(this.settings.currencySymbolPlacement!==V.options.currencySymbolPlacement.prefix&&(this.settings.currencySymbolPlacement!==V.options.currencySymbolPlacement.suffix||this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.prefix&&this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none)||(this.settings.showPositiveSign&&t||!t&&this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.left)&&(e+=1),this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.prefix&&(e+=this.settings.currencySymbol.length),T.getElementValue(this.domElement)),n=i.indexOf(this.settings.decimalCharacter);return-1===n&&(n=this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix?i.length-this.settings.currencySymbol.length:i.length,t||this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.suffix&&this.settings.currencySymbolPlacement!==V.options.currencySymbolPlacement.suffix||--n,n-=this.settings.suffixText.length),T.setElementSelection(this.domElement,e,n),this}},{key:"selectDecimal",value:function(){var e=T.getElementValue(this.domElement).indexOf(this.settings.decimalCharacter),t=-1===e?e=0:(t=this.isFocused?this.settings.decimalPlacesShownOnFocus:this.settings.decimalPlacesShownOnBlur,(e+=1)+Number(t));return T.setElementSelection(this.domElement,e,t),this}},{key:"node",value:function(){return this.domElement}},{key:"parent",value:function(){return this.domElement.parentNode}},{key:"detach",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,e=T.isNull(e)?this.domElement:e.node();return this._removeFromLocalList(e),this}},{key:"attach",value:function(e){var t=!(1<arguments.length&&void 0!==arguments[1])||arguments[1];return this._addToLocalList(e.node()),t&&e.update(this.settings),this}},{key:"formatOther",value:function(e){return this._formatOrUnformatOther(!0,e,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"unformatOther",value:function(e){return this._formatOrUnformatOther(!1,e,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"_formatOrUnformatOther",value:function(e,t){var i,n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,n=T.isNull(n)?this.settings:this._cloneAndMergeSettings(n);return T.isElement(t)?(i=T.getElementValue(t),i=e?V.format(i,n):V.unformat(i,n),T.setElementValue(t,i),null):e?V.format(t,n):V.unformat(t,n)}},{key:"init",value:function(e){var n,a,o=this,r=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],t=!1,i=[];return T.isString(e)?i=f(document.querySelectorAll(e)):T.isElement(e)?(i.push(e),t=!0):T.isArray(e)?i=e:T.throwError("The given parameters to the 'init' function are invalid."),0===i.length?(T.warning("No valid DOM elements were given hence no AutoNumeric object were instantiated.",!0),[]):(n=this._getLocalList(),a=[],i.forEach(function(e){var t=o.settings.createLocalList,i=(r&&(o.settings.createLocalList=!1),new V(e,T.getElementValue(e),o.settings));r&&(i._setLocalList(n),o._addToLocalList(e,i),o.settings.createLocalList=t),a.push(i)}),t?a[0]:a)}},{key:"clear",value:function(){var e;return 0<arguments.length&&void 0!==arguments[0]&&arguments[0]?(e={emptyInputBehavior:V.options.emptyInputBehavior.focus},this.set("",e)):this.set(""),this}},{key:"remove",value:function(){this._removeValueFromPersistentStorage(),this._removeEventListeners(),this._removeWatcher(),this._removeFromLocalList(this.domElement),this.constructor._removeFromGlobalList(this)}},{key:"wipe",value:function(){this._setElementValue("",!1),this.remove()}},{key:"nuke",value:function(){this.remove(),this.domElement.parentNode.removeChild(this.domElement)}},{key:"form",value:function(){var e,t;return(0<arguments.length&&void 0!==arguments[0]&&arguments[0]||T.isUndefinedOrNullOrEmpty(this.parentForm))&&(e=this._getParentForm(),T.isNull(e)||e===this.parentForm||(t=this._getFormAutoNumericChildren(this.parentForm),this.parentForm.dataset.anCount=t.length,this._hasFormHandlerFunction(e)?this._incrementParentFormCounter(e):(this._storeFormHandlerFunction(e),this._initializeFormCounterToOne(e))),this.parentForm=e),this.parentForm}},{key:"_getFormAutoNumericChildren",value:function(e){var t=this;return f(e.querySelectorAll("input")).filter(function(e){return t.constructor.isManagedByAutoNumeric(e)})}},{key:"_getParentForm",value:function(){if("body"===this.domElement.tagName.toLowerCase())return null;var e,t=this.domElement;do{if(t=t.parentNode,T.isNull(t))return null}while("body"!==(e=t.tagName?t.tagName.toLowerCase():"")&&"form"!==e);return"form"===e?t:null}},{key:"formNumericString",value:function(){return this.constructor._serializeNumericString(this.form(),this.settings.serializeSpaces)}},{key:"formFormatted",value:function(){return this.constructor._serializeFormatted(this.form(),this.settings.serializeSpaces)}},{key:"formLocalized",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,e=T.isNull(e)?this.settings.outputFormat:e;return this.constructor._serializeLocalized(this.form(),this.settings.serializeSpaces,e)}},{key:"formArrayNumericString",value:function(){return this.constructor._serializeNumericStringArray(this.form(),this.settings.serializeSpaces)}},{key:"formArrayFormatted",value:function(){return this.constructor._serializeFormattedArray(this.form(),this.settings.serializeSpaces)}},{key:"formArrayLocalized",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,e=T.isNull(e)?this.settings.outputFormat:e;return this.constructor._serializeLocalizedArray(this.form(),this.settings.serializeSpaces,e)}},{key:"formJsonNumericString",value:function(){return JSON.stringify(this.formArrayNumericString())}},{key:"formJsonFormatted",value:function(){return JSON.stringify(this.formArrayFormatted())}},{key:"formJsonLocalized",value:function(){return JSON.stringify(this.formArrayLocalized(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null))}},{key:"formUnformat",value:function(){return this.constructor._getChildANInputElement(this.form()).forEach(function(e){V.getAutoNumericElement(e).unformat()}),this}},{key:"formUnformatLocalized",value:function(){return this.constructor._getChildANInputElement(this.form()).forEach(function(e){V.getAutoNumericElement(e).unformatLocalized()}),this}},{key:"formReformat",value:function(){return this.constructor._getChildANInputElement(this.form()).forEach(function(e){V.getAutoNumericElement(e).reformat()}),this}},{key:"formSubmitNumericString",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return T.isNull(e)?(this.formUnformat(),this.form().submit(),this.formReformat()):T.isFunction(e)?e(this.formNumericString()):T.throwError("The given callback is not a function."),this}},{key:"formSubmitFormatted",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return T.isNull(e)?this.form().submit():T.isFunction(e)?e(this.formFormatted()):T.throwError("The given callback is not a function."),this}},{key:"formSubmitLocalized",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;return T.isNull(t)?(this.formUnformatLocalized(),this.form().submit(),this.formReformat()):T.isFunction(t)?t(this.formLocalized(e)):T.throwError("The given callback is not a function."),this}},{key:"formSubmitArrayNumericString",value:function(e){return T.isFunction(e)?e(this.formArrayNumericString()):T.throwError("The given callback is not a function."),this}},{key:"formSubmitArrayFormatted",value:function(e){return T.isFunction(e)?e(this.formArrayFormatted()):T.throwError("The given callback is not a function."),this}},{key:"formSubmitArrayLocalized",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;return T.isFunction(e)?e(this.formArrayLocalized(t)):T.throwError("The given callback is not a function."),this}},{key:"formSubmitJsonNumericString",value:function(e){return T.isFunction(e)?e(this.formJsonNumericString()):T.throwError("The given callback is not a function."),this}},{key:"formSubmitJsonFormatted",value:function(e){return T.isFunction(e)?e(this.formJsonFormatted()):T.throwError("The given callback is not a function."),this}},{key:"formSubmitJsonLocalized",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;return T.isFunction(e)?e(this.formJsonLocalized(t)):T.throwError("The given callback is not a function."),this}},{key:"_createLocalList",value:function(){this.autoNumericLocalList=new Map,this._addToLocalList(this.domElement)}},{key:"_deleteLocalList",value:function(){delete this.autoNumericLocalList}},{key:"_setLocalList",value:function(e){this.autoNumericLocalList=e}},{key:"_getLocalList",value:function(){return this.autoNumericLocalList}},{key:"_hasLocalList",value:function(){return this.autoNumericLocalList instanceof Map&&0!==this.autoNumericLocalList.size}},{key:"_addToLocalList",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;T.isNull(t)&&(t=this),T.isUndefined(this.autoNumericLocalList)?T.throwError("The local list provided does not exists when trying to add an element. [".concat(this.autoNumericLocalList,"] given.")):this.autoNumericLocalList.set(e,t)}},{key:"_removeFromLocalList",value:function(e){T.isUndefined(this.autoNumericLocalList)?this.settings.createLocalList&&T.throwError("The local list provided does not exists when trying to remove an element. [".concat(this.autoNumericLocalList,"] given.")):this.autoNumericLocalList.delete(e)}},{key:"_mergeSettings",value:function(){for(var e=arguments.length,t=new Array(e),i=0;i<e;i++)t[i]=arguments[i];S.apply(void 0,[this.settings].concat(t))}},{key:"_cloneAndMergeSettings",value:function(){for(var e={},t=arguments.length,i=new Array(t),n=0;n<t;n++)i[n]=arguments[n];return S.apply(void 0,[e,this.settings].concat(i)),e}},{key:"_updatePredefinedOptions",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;return T.isNull(t)?this.update(e):(this._mergeSettings(e,t),this.update(this.settings)),this}},{key:"french",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return this._updatePredefinedOptions(V.getPredefinedOptions().French,e),this}},{key:"northAmerican",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return this._updatePredefinedOptions(V.getPredefinedOptions().NorthAmerican,e),this}},{key:"british",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return this._updatePredefinedOptions(V.getPredefinedOptions().British,e),this}},{key:"swiss",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return this._updatePredefinedOptions(V.getPredefinedOptions().Swiss,e),this}},{key:"japanese",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return this._updatePredefinedOptions(V.getPredefinedOptions().Japanese,e),this}},{key:"spanish",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return this._updatePredefinedOptions(V.getPredefinedOptions().Spanish,e),this}},{key:"chinese",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return this._updatePredefinedOptions(V.getPredefinedOptions().Chinese,e),this}},{key:"brazilian",value:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return this._updatePredefinedOptions(V.getPredefinedOptions().Brazilian,e),this}},{key:"_runCallbacksFoundInTheSettingsObject",value:function(){for(var e in this.settings){var t;Object.prototype.hasOwnProperty.call(this.settings,e)&&("function"==typeof(t=this.settings[e])?this.settings[e]=t(this,e):(t=this.domElement.getAttribute(e),t=T.camelize(t),"function"==typeof this.settings[t]&&(this.settings[e]=t(this,e))))}}},{key:"_setTrailingNegativeSignInfo",value:function(){this.isTrailingNegative=this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.suffix||this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix&&(this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.left||this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.right)}},{key:"_modifyNegativeSignAndDecimalCharacterForRawValue",value:function(e){return"."!==this.settings.decimalCharacter&&(e=e.replace(this.settings.decimalCharacter,".")),(e="-"!==this.settings.negativeSignCharacter&&this.settings.isNegativeSignAllowed?e.replace(this.settings.negativeSignCharacter,"-"):e).match(/\d/)||(e+="0"),e}},{key:"_initialCaretPosition",value:function(e){T.isNull(this.settings.caretPositionOnFocus)&&this.settings.selectOnFocus===V.options.selectOnFocus.doNotSelect&&T.throwError("`_initialCaretPosition()` should never be called when the `caretPositionOnFocus` option is `null`.");var t,i=this.rawValue<0,n=T.isZeroOrHasNoValue(e),a=e.length,o=0,r=0,s=0,l=(this.settings.caretPositionOnFocus!==V.options.caretPositionOnFocus.start&&(o=(e=(e=(e=e.replace(this.settings.negativeSignCharacter,"")).replace(this.settings.positiveSignCharacter,"")).replace(this.settings.currencySymbol,"")).length,l=T.contains(e,this.settings.decimalCharacter),this.settings.caretPositionOnFocus!==V.options.caretPositionOnFocus.decimalLeft&&this.settings.caretPositionOnFocus!==V.options.caretPositionOnFocus.decimalRight||(s=l?(r=e.indexOf(this.settings.decimalCharacter),this.settings.decimalCharacter.length):(r=o,0))),""),c=(i?l=this.settings.negativeSignCharacter:this.settings.showPositiveSign&&!n&&(l=this.settings.positiveSignCharacter),l.length),u=this.settings.currencySymbol.length;if(this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.prefix){if(this.settings.caretPositionOnFocus===V.options.caretPositionOnFocus.start)if(this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&this.settings.showPositiveSign&&!n))switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.prefix:case V.options.negativePositiveSignPlacement.left:case V.options.negativePositiveSignPlacement.right:t=c+u;break;case V.options.negativePositiveSignPlacement.suffix:t=u}else t=u;else if(this.settings.caretPositionOnFocus===V.options.caretPositionOnFocus.end)if(this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&this.settings.showPositiveSign&&!n))switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.prefix:case V.options.negativePositiveSignPlacement.left:case V.options.negativePositiveSignPlacement.right:t=a;break;case V.options.negativePositiveSignPlacement.suffix:t=u+o}else t=a;else if(this.settings.caretPositionOnFocus===V.options.caretPositionOnFocus.decimalLeft)if(this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&this.settings.showPositiveSign&&!n))switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.prefix:case V.options.negativePositiveSignPlacement.left:case V.options.negativePositiveSignPlacement.right:t=c+u+r;break;case V.options.negativePositiveSignPlacement.suffix:t=u+r}else t=u+r;else if(this.settings.caretPositionOnFocus===V.options.caretPositionOnFocus.decimalRight)if(this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&this.settings.showPositiveSign&&!n))switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.prefix:case V.options.negativePositiveSignPlacement.left:case V.options.negativePositiveSignPlacement.right:t=c+u+r+s;break;case V.options.negativePositiveSignPlacement.suffix:t=u+r+s}else t=u+r+s}else if(this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix)if(this.settings.caretPositionOnFocus===V.options.caretPositionOnFocus.start)if(this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&this.settings.showPositiveSign&&!n))switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.suffix:case V.options.negativePositiveSignPlacement.right:case V.options.negativePositiveSignPlacement.left:t=0;break;case V.options.negativePositiveSignPlacement.prefix:t=c}else t=0;else if(this.settings.caretPositionOnFocus===V.options.caretPositionOnFocus.end)if(this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&this.settings.showPositiveSign&&!n))switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.suffix:case V.options.negativePositiveSignPlacement.right:case V.options.negativePositiveSignPlacement.left:t=o;break;case V.options.negativePositiveSignPlacement.prefix:t=c+o}else t=o;else if(this.settings.caretPositionOnFocus===V.options.caretPositionOnFocus.decimalLeft)if(this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&this.settings.showPositiveSign&&!n))switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.suffix:case V.options.negativePositiveSignPlacement.right:case V.options.negativePositiveSignPlacement.left:t=r;break;case V.options.negativePositiveSignPlacement.prefix:t=c+r}else t=r;else if(this.settings.caretPositionOnFocus===V.options.caretPositionOnFocus.decimalRight)if(this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.none&&(i||!i&&this.settings.showPositiveSign&&!n))switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.suffix:case V.options.negativePositiveSignPlacement.right:case V.options.negativePositiveSignPlacement.left:t=r+s;break;case V.options.negativePositiveSignPlacement.prefix:t=c+r+s}else t=r+s;return t}},{key:"_triggerRangeEvents",value:function(e,t){e||this._triggerEvent(V.events.minRangeExceeded,this.domElement),t||this._triggerEvent(V.events.maxRangeExceeded,this.domElement)}},{key:"_setInvalidState",value:function(){this.isInputElement?T.setInvalidState(this.domElement):this._addCSSClass(this.settings.invalidClass),this._triggerEvent(V.events.invalidValue,this.domElement),this.validState=!1}},{key:"_setValidState",value:function(){this.isInputElement?T.setValidState(this.domElement):this._removeCSSClass(this.settings.invalidClass),this.validState||this._triggerEvent(V.events.correctedValue,this.domElement),this.validState=!0}},{key:"_setValidOrInvalidState",value:function(e){var t;this.settings.overrideMinMaxLimits===V.options.overrideMinMaxLimits.invalid&&(t=this.constructor._isMinimumRangeRespected(e,this.settings),e=this.constructor._isMaximumRangeRespected(e,this.settings),t&&e?this._setValidState():this._setInvalidState(),this._triggerRangeEvents(t,e))}},{key:"_keepAnOriginalSettingsCopy",value:function(){this.originalDigitGroupSeparator=this.settings.digitGroupSeparator,this.originalCurrencySymbol=this.settings.currencySymbol,this.originalSuffixText=this.settings.suffixText}},{key:"_trimLeadingAndTrailingZeros",value:function(e){if(""!==e&&null!==e){if(this.settings.leadingZero!==V.options.leadingZero.keep){if(0===Number(e))return"0";e=e.replace(/^(-)?0+(?=\d)/g,"$1")}e=(e=T.contains(e,".")?e.replace(/(\.[0-9]*?)0+$/,"$1"):e).replace(/\.$/,"")}return e}},{key:"_setPersistentStorageName",value:function(){this.settings.saveValueToSessionStorage&&(""===this.domElement.name||T.isUndefined(this.domElement.name)?this.rawValueStorageName="".concat(this.storageNamePrefix).concat(this.domElement.id):this.rawValueStorageName="".concat(this.storageNamePrefix).concat(decodeURIComponent(this.domElement.name)))}},{key:"_saveValueToPersistentStorage",value:function(){this.settings.saveValueToSessionStorage&&(this.sessionStorageAvailable?sessionStorage.setItem(this.rawValueStorageName,this.rawValue):document.cookie="".concat(this.rawValueStorageName,"=").concat(this.rawValue,"; expires= ; path=/"))}},{key:"_getValueFromPersistentStorage",value:function(){return this.settings.saveValueToSessionStorage?this.sessionStorageAvailable?sessionStorage.getItem(this.rawValueStorageName):this.constructor._readCookie(this.rawValueStorageName):(T.warning("`_getValueFromPersistentStorage()` is called but `settings.saveValueToSessionStorage` is false. There must be an error that needs fixing.",this.settings.showWarnings),null)}},{key:"_removeValueFromPersistentStorage",value:function(){var e;this.settings.saveValueToSessionStorage&&(this.sessionStorageAvailable?sessionStorage.removeItem(this.rawValueStorageName):((e=new Date).setTime(e.getTime()-864e5),e="; expires=".concat(e.toUTCString()),document.cookie="".concat(this.rawValueStorageName,"='' ;").concat(e,"; path=/")))}},{key:"_getDefaultValue",value:function(e){e=e.getAttribute("value");return T.isNull(e)?"":e}},{key:"_onFocusInAndMouseEnter",value:function(e){var t,i,n;this.isEditing=!1,!this.formulaMode&&this.settings.unformatOnHover&&"mouseenter"===e.type&&e.altKey?this.constructor._unformatAltHovered(this):("focus"===e.type&&(this.isFocused=!0,this.rawValueOnFocus=this.rawValue),"focus"===e.type&&this.settings.unformatOnHover&&this.hoveredWithAlt&&this.constructor._reformatAltHovered(this),("focus"===e.type||"mouseenter"===e.type&&!this.isFocused)&&(t=null,this.settings.emptyInputBehavior===V.options.emptyInputBehavior.focus&&this.rawValue<0&&null!==this.settings.negativeBracketsTypeOnBlur&&this.settings.isNegativeSignAllowed&&(t=this.constructor._removeBrackets(T.getElementValue(this.domElement),this.settings)),""!==(i=this._getRawValueToFormat(this.rawValue))&&(n=this.constructor._roundFormattedValueShownOnFocusOrBlur(i,this.settings,this.isFocused),t=this.settings.showOnlyNumbersOnFocus===V.options.showOnlyNumbersOnFocus.onlyNumbers?(this.settings.digitGroupSeparator="",this.settings.currencySymbol="",this.settings.suffixText="",n.replace(".",this.settings.decimalCharacter)):T.isNull(n)?"":this.constructor._addGroupSeparators(n.replace(".",this.settings.decimalCharacter),this.settings,this.isFocused,i)),T.isNull(t)?this.valueOnFocus="":this.valueOnFocus=t,this.lastVal=this.valueOnFocus,n=this.constructor._isElementValueEmptyOrOnlyTheNegativeSign(this.valueOnFocus,this.settings),i=this.constructor._orderValueCurrencySymbolAndSuffixText(this.valueOnFocus,this.settings,!0),n=n&&""!==i&&this.settings.emptyInputBehavior===V.options.emptyInputBehavior.focus,T.isNull(t=n?i:t)||this._setElementValue(t),n)&&i===this.settings.currencySymbol&&this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix&&T.setElementSelection(e.target,0))}},{key:"_onFocus",value:function(){this.settings.isCancellable&&this._saveCancellableValue()}},{key:"_onFocusIn",value:function(e){this.settings.selectOnFocus?this.select():T.isNull(this.settings.caretPositionOnFocus)||T.setElementSelection(e.target,this._initialCaretPosition(T.getElementValue(this.domElement)))}},{key:"_enterFormulaMode",value:function(){this.settings.formulaMode&&(this.formulaMode=!0,T.setElementValue(this.domElement,"="),T.setElementSelection(this.domElement,1))}},{key:"_exitFormulaMode",value:function(){var t=(t=T.getElementValue(this.domElement)).replace(/^\s*=/,"");try{var e=new j(t,this.settings.decimalCharacter),i=(new B).evaluate(e)}catch(e){return this._triggerEvent(V.events.invalidFormula,this.domElement,{formula:t,aNElement:this}),this.reformat(),void(this.formulaMode=!1)}this._triggerEvent(V.events.validFormula,this.domElement,{formula:t,result:i,aNElement:this}),this.set(i),this.formulaMode=!1}},{key:"_acceptNonPrintableKeysInFormulaMode",value:function(){return this.eventKey===u.keyName.Backspace||this.eventKey===u.keyName.Delete||this.eventKey===u.keyName.LeftArrow||this.eventKey===u.keyName.RightArrow||this.eventKey===u.keyName.Home||this.eventKey===u.keyName.End}},{key:"_onKeydown",value:function(e){if(this.formatted=!1,this.isEditing=!0,!this.formulaMode&&!this.isFocused&&this.settings.unformatOnHover&&e.altKey&&this.domElement===T.getHoveredElement())this.constructor._unformatAltHovered(this);else{if(this._updateEventKeyInfo(e),this.keydownEventCounter+=1,1===this.keydownEventCounter&&(this.initialValueOnFirstKeydown=T.getElementValue(e.target),this.initialRawValueOnFirstKeydown=this.rawValue),this.formulaMode){if(this.eventKey===u.keyName.Esc)return this.formulaMode=!1,void this.reformat();if(this.eventKey===u.keyName.Enter)return void this._exitFormulaMode();if(this._acceptNonPrintableKeysInFormulaMode())return}else if(this.eventKey===u.keyName.Equal)return void this._enterFormulaMode();var t,i;this.domElement.readOnly||this.settings.readOnly||this.domElement.disabled||(this.eventKey===u.keyName.Esc&&(e.preventDefault(),this.settings.isCancellable&&this.rawValue!==this.savedCancellableValue&&(this.set(this.savedCancellableValue),this._triggerEvent(V.events.native.input,e.target)),this.select()),t=T.getElementValue(e.target),this.eventKey===u.keyName.Enter&&this.rawValue!==this.rawValueOnFocus&&(this._triggerEvent(V.events.native.change,e.target),this.valueOnFocus=t,this.rawValueOnFocus=this.rawValue,this.settings.isCancellable)&&this._saveCancellableValue(),this._updateInternalProperties(e),this._processNonPrintableKeysAndShortcuts(e))?this.processed=!0:this.eventKey!==u.keyName.Backspace&&this.eventKey!==u.keyName.Delete||(i=this._processCharacterDeletion(e),this.processed=!0,i?(this._formatValue(e),(t=T.getElementValue(e.target))!==this.lastVal&&this.throwInput&&(this._triggerEvent(V.events.native.input,e.target),e.preventDefault()),this.lastVal=t,this.throwInput=!0):e.preventDefault())}}},{key:"_onKeypress",value:function(e){if(this.formulaMode)return this._acceptNonPrintableKeysInFormulaMode()||this.settings.formulaChars.test(this.eventKey)?void 0:void e.preventDefault();var t;this.eventKey===u.keyName.Insert||(t=this.processed,this._updateInternalProperties(e),this._processNonPrintableKeysAndShortcuts(e))||(!t&&this._processCharacterInsertion()?(this._formatValue(e),(t=T.getElementValue(e.target))!==this.lastVal&&this.throwInput?this._triggerEvent(V.events.native.input,e.target):this.eventKey!==this.settings.decimalCharacter&&this.eventKey!==this.settings.decimalCharacterAlternative||T.getElementSelection(e.target).start!==T.getElementSelection(e.target).end||T.getElementSelection(e.target).start!==t.indexOf(this.settings.decimalCharacter)||(t=T.getElementSelection(e.target).start+1,T.setElementSelection(e.target,t)),e.preventDefault(),this.lastVal=T.getElementValue(e.target),this.throwInput=!0,this._setValidOrInvalidState(this.rawValue)):e.preventDefault())}},{key:"_onKeyup",value:function(e){if(this.isEditing=!1,this.keydownEventCounter=0,!this.formulaMode)if(this.settings.isCancellable&&this.eventKey===u.keyName.Esc)e.preventDefault();else{if(this._updateEventKeyInfo(e),this.eventKey===u.keyName.Z||this.eventKey===u.keyName.z){if(e.ctrlKey&&e.shiftKey)return e.preventDefault(),this._historyTableRedo(),this._triggerEvent(V.events.native.input,e.target),void(this.onGoingRedo=!0);if(e.ctrlKey&&!e.shiftKey){if(!this.onGoingRedo)return e.preventDefault(),this._historyTableUndo(),void this._triggerEvent(V.events.native.input,e.target);this.onGoingRedo=!1}}else if((this.eventKey===u.keyName.Y||this.eventKey===u.keyName.y)&&e.ctrlKey)return e.preventDefault(),this._historyTableRedo(),this._triggerEvent(V.events.native.input,e.target),void(this.onGoingRedo=!0);var t,i;this.onGoingRedo&&(e.ctrlKey||e.shiftKey)&&(this.onGoingRedo=!1),(e.ctrlKey||e.metaKey)&&this.eventKey===u.keyName.x&&(t=T.getElementSelection(this.domElement).start,i=this.constructor._toNumericValue(T.getElementValue(e.target),this.settings),this.set(i),this._setCaretPosition(t)),this.eventKey===u.keyName.Alt&&this.settings.unformatOnHover&&this.hoveredWithAlt?this.constructor._reformatAltHovered(this):!e.ctrlKey&&!e.metaKey||this.eventKey!==u.keyName.Backspace&&this.eventKey!==u.keyName.Delete?(this._updateInternalProperties(e),i=this._processNonPrintableKeysAndShortcuts(e),delete this.valuePartsBeforePaste,t=T.getElementValue(e.target),i||""===t&&""===this.initialValueOnFirstKeydown||(t===this.settings.currencySymbol?this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix?T.setElementSelection(e.target,0):T.setElementSelection(e.target,this.settings.currencySymbol.length):this.eventKey===u.keyName.Tab&&T.setElementSelection(e.target,0,t.length),(t===this.settings.suffixText||""===this.rawValue&&""!==this.settings.currencySymbol&&""!==this.settings.suffixText)&&T.setElementSelection(e.target,0),null!==this.settings.decimalPlacesShownOnFocus&&this._saveValueToPersistentStorage(),this.formatted||this._formatValue(e),this._setValidOrInvalidState(this.rawValue),this._saveRawValueForAndroid(),t!==this.initialValueOnFirstKeydown&&this._triggerEvent(V.events.formatted,e.target,{oldValue:this.initialValueOnFirstKeydown,newValue:t,oldRawValue:this.initialRawValueOnFirstKeydown,newRawValue:this.rawValue,isPristine:this.isPristine(!1),error:null,aNElement:this}),1<this.historyTable.length&&(i=T.getElementSelection(this.domElement),this.selectionStart=i.start,this.selectionEnd=i.end,this.historyTable[this.historyTableIndex].start=this.selectionStart,this.historyTable[this.historyTableIndex].end=this.selectionEnd))):(t=T.getElementValue(e.target),this._setRawValue(this._formatOrUnformatOther(!1,t)))}}},{key:"_saveRawValueForAndroid",value:function(){var e;this.eventKey===u.keyName.AndroidDefault&&(e=this.constructor._stripAllNonNumberCharactersExceptCustomDecimalChar(this.getFormatted(),this.settings,!0,this.isFocused),e=this.constructor._convertToNumericString(e,this.settings),this._setRawValue(e))}},{key:"_onFocusOutAndMouseLeave",value:function(e){if(this.isEditing=!1,"mouseleave"!==e.type||!this.formulaMode)if(this.settings.unformatOnHover&&"mouseleave"===e.type&&this.hoveredWithAlt)this.constructor._reformatAltHovered(this);else if("mouseleave"===e.type&&!this.isFocused||"blur"===e.type){"blur"===e.type&&this.formulaMode&&this._exitFormulaMode(),this._saveValueToPersistentStorage(),this.settings.showOnlyNumbersOnFocus===V.options.showOnlyNumbersOnFocus.onlyNumbers&&(this.settings.digitGroupSeparator=this.originalDigitGroupSeparator,this.settings.currencySymbol=this.originalCurrencySymbol,this.settings.suffixText=this.originalSuffixText);var t=this._getRawValueToFormat(this.rawValue),i=T.isNull(t),n=y(this.constructor._checkIfInRangeWithOverrideOption(t,this.settings),2),a=n[0],n=n[1],o=!1;if(""===t||i||(this._triggerRangeEvents(a,n),this.settings.valuesToStrings&&this._checkValuesToStrings(t)&&(this._setElementValue(this.settings.valuesToStrings[t]),o=!0)),!o){var r=i||""===t?t:String(t);if(""===t||i){if(""===t)switch(this.settings.emptyInputBehavior){case V.options.emptyInputBehavior.zero:this._setRawValue("0"),r=this.constructor._roundValue("0",this.settings,0);break;case V.options.emptyInputBehavior.min:this._setRawValue(this.settings.minimumValue),r=this.constructor._roundFormattedValueShownOnFocusOrBlur(this.settings.minimumValue,this.settings,this.isFocused);break;case V.options.emptyInputBehavior.max:this._setRawValue(this.settings.maximumValue),r=this.constructor._roundFormattedValueShownOnFocusOrBlur(this.settings.maximumValue,this.settings,this.isFocused);break;default:T.isNumber(this.settings.emptyInputBehavior)&&(this._setRawValue(this.settings.emptyInputBehavior),r=this.constructor._roundFormattedValueShownOnFocusOrBlur(this.settings.emptyInputBehavior,this.settings,this.isFocused))}}else a&&n&&!this.constructor._isElementValueEmptyOrOnlyTheNegativeSign(t,this.settings)?(r=this._modifyNegativeSignAndDecimalCharacterForRawValue(r),this.settings.divisorWhenUnfocused&&!T.isNull(r)&&(r=(r/=this.settings.divisorWhenUnfocused).toString()),r=this.constructor._roundFormattedValueShownOnBlur(r,this.settings),r=this.constructor._modifyNegativeSignAndDecimalCharacterForFormattedValue(r,this.settings)):this._triggerRangeEvents(a,n);o=this.constructor._orderValueCurrencySymbolAndSuffixText(r,this.settings,!1);(o=this.constructor._isElementValueEmptyOrOnlyTheNegativeSign(r,this.settings)||i&&this.settings.emptyInputBehavior===V.options.emptyInputBehavior.null?o:this.constructor._addGroupSeparators(r,this.settings,!1,t))===t&&""!==t&&this.settings.allowDecimalPadding!==V.options.allowDecimalPadding.never&&this.settings.allowDecimalPadding!==V.options.allowDecimalPadding.floats||(this.settings.symbolWhenUnfocused&&""!==t&&null!==t&&(o="".concat(o).concat(this.settings.symbolWhenUnfocused)),this._setElementValue(o))}this._setValidOrInvalidState(this.rawValue),"blur"===e.type&&this._onBlur(e)}}},{key:"_onPaste",value:function(e){if(e.preventDefault(),!(this.settings.readOnly||this.domElement.readOnly||this.domElement.disabled)){window.clipboardData&&window.clipboardData.getData?t=window.clipboardData.getData("Text"):e.clipboardData&&e.clipboardData.getData?t=e.clipboardData.getData("text/plain"):T.throwError("Unable to retrieve the pasted value. Please use a modern browser (i.e. Firefox or Chromium).");var t,i=e.target.tagName?e.target:e.explicitOriginalTarget,n=T.getElementValue(i),a=i.selectionStart||0,o=i.selectionEnd||0,r=o-a;if(r===n.length)return e=this._preparePastedText(t),"."===(e=T.arabicToLatinNumbers(e,!1,!1,!1))||""===e||"."!==e&&!T.isNumber(e)?(this.formatted=!0,void(this.settings.onInvalidPaste===V.options.onInvalidPaste.error&&T.throwError("The pasted value '".concat(t,"' is not a valid paste content.")))):(this.set(e),this.formatted=!0,void this._triggerEvent(V.events.native.input,i));var e=T.isNegativeStrict(t,this.settings.negativeSignCharacter),s=(e&&(t=t.slice(1,t.length)),this._preparePastedText(t)),l="."===s?".":T.arabicToLatinNumbers(s,!1,!1,!1);if("."===l||T.isNumber(l)&&""!==l){var s=T.isNegativeStrict(this.getNumericString(),this.settings.negativeSignCharacter),c=!(!e||s)&&(s=!0),e=n.slice(0,a),u=n.slice(o,n.length),h=(N=a!==o?this._preparePastedText(e+u):this._preparePastedText(n),s&&(N=T.setRawNegativeSign(N)),P=T.convertCharacterCountToIndexPosition(T.countNumberCharactersOnTheCaretLeftSide(n,a,this.settings.decimalCharacter)),c&&P++,N.slice(0,P)),m=N.slice(P,N.length),g=!1,d=("."===l&&(T.contains(h,".")&&(g=!0,h=h.replace(".","")),m=m.replace(".","")),!1);switch(""===h&&"-"===m&&(h="-",d=!(m="")),this.settings.onInvalidPaste){case V.options.onInvalidPaste.truncate:case V.options.onInvalidPaste.replace:for(var v=T.parseStr(this.settings.minimumValue),p=T.parseStr(this.settings.maximumValue),f=N,y=0,S=h;y<l.length&&(S+=l[y],this.constructor._checkIfInRange(N=S+m,v,p));)f=N,y++;if(P+=y,d&&P++,this.settings.onInvalidPaste===V.options.onInvalidPaste.truncate)N=f,g&&P--;else{for(var b=P,w=f.length;y<l.length&&b<w;){if("."!==f[b]){if(N=T.replaceCharAt(f,b,l[y]),!this.constructor._checkIfInRange(N,v,p))break;f=N,y++}b++}P=b,g&&P--,N=f}break;case V.options.onInvalidPaste.error:case V.options.onInvalidPaste.ignore:case V.options.onInvalidPaste.clamp:default:var P,O,k,N="".concat(h).concat(l).concat(m);a===o?P=T.convertCharacterCountToIndexPosition(T.countNumberCharactersOnTheCaretLeftSide(n,a,this.settings.decimalCharacter))+l.length:""===m?(P=T.convertCharacterCountToIndexPosition(T.countNumberCharactersOnTheCaretLeftSide(n,a,this.settings.decimalCharacter))+l.length,d&&P++):(O=T.convertCharacterCountToIndexPosition(T.countNumberCharactersOnTheCaretLeftSide(n,o,this.settings.decimalCharacter)),k=T.getElementValue(i).slice(a,o),P=O-r+T.countCharInText(this.settings.digitGroupSeparator,k)+l.length),c&&P++,g&&P--}if(T.isNumber(N)&&""!==N){var E,_=!1,C=!1;try{this.set(N),_=!0}catch(e){switch(this.settings.onInvalidPaste){case V.options.onInvalidPaste.clamp:E=T.clampToRangeLimits(N,this.settings);try{this.set(E)}catch(e){T.throwError("Fatal error: Unable to set the clamped value '".concat(E,"'."))}_=C=!0,N=E;break;case V.options.onInvalidPaste.error:case V.options.onInvalidPaste.truncate:case V.options.onInvalidPaste.replace:T.throwError("The pasted value '".concat(t,"' results in a value '").concat(N,"' that is outside of the minimum [").concat(this.settings.minimumValue,"] and maximum [").concat(this.settings.maximumValue,"] value range."));case V.options.onInvalidPaste.ignore:default:return}}var F,x=T.getElementValue(i);if(_)switch(this.settings.onInvalidPaste){case V.options.onInvalidPaste.clamp:if(C){this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix?T.setElementSelection(i,x.length-this.settings.currencySymbol.length):T.setElementSelection(i,x.length);break}case V.options.onInvalidPaste.error:case V.options.onInvalidPaste.ignore:case V.options.onInvalidPaste.truncate:case V.options.onInvalidPaste.replace:default:F=T.findCaretPositionInFormattedNumber(N,P,x,this.settings.decimalCharacter),T.setElementSelection(i,F)}_&&n!==x&&this._triggerEvent(V.events.native.input,i)}else this.settings.onInvalidPaste===V.options.onInvalidPaste.error&&T.throwError("The pasted value '".concat(t,"' would result into an invalid content '").concat(N,"'."))}else this.formatted=!0,this.settings.onInvalidPaste===V.options.onInvalidPaste.error&&T.throwError("The pasted value '".concat(t,"' is not a valid paste content."))}}},{key:"_onBlur",value:function(e){this.isFocused=!1,this.isEditing=!1,T.trimPaddedZerosFromDecimalPlaces(this.rawValue)!==T.trimPaddedZerosFromDecimalPlaces(this.rawValueOnFocus)&&this._triggerEvent(V.events.native.change,e.target),this.rawValueOnFocus=void 0}},{key:"_onWheel",value:function(e){this.formulaMode||this.settings.readOnly||this.domElement.readOnly||this.domElement.disabled||this.settings.modifyValueOnWheel&&(this.settings.wheelOn===V.options.wheelOn.focus?this.isFocused?e.shiftKey||this.wheelAction(e):e.shiftKey&&this.wheelAction(e):this.settings.wheelOn===V.options.wheelOn.hover?e.shiftKey?(e.preventDefault(),window.scrollBy(0,T.isNegativeStrict(String(e.deltaY))?-50:50)):this.wheelAction(e):T.throwError("Unknown `wheelOn` option."))}},{key:"wheelAction",value:function(e){this.isWheelEvent=!0;var t,i,n=e.target.selectionStart||0,a=e.target.selectionEnd||0,o=this.rawValue;T.isUndefinedOrNullOrEmpty(o)?0<this.settings.minimumValue||this.settings.maximumValue<0?T.isWheelUpEvent(e)?t=this.settings.minimumValue:T.isWheelDownEvent(e)?t=this.settings.maximumValue:T.throwError("The event is not a 'wheel' event."):t=0:t=o,t=+t,T.isNumber(this.settings.wheelStep)?(i=+this.settings.wheelStep,T.isWheelUpEvent(e)?t+=i:T.isWheelDownEvent(e)&&(t-=i)):T.isWheelUpEvent(e)?t=T.addAndRoundToNearestAuto(t,this.settings.decimalPlacesRawValue):T.isWheelDownEvent(e)&&(t=T.subtractAndRoundToNearestAuto(t,this.settings.decimalPlacesRawValue)),(t=T.clampToRangeLimits(t,this.settings))!==+o&&(this.set(t),this._triggerEvent(V.events.native.input,e.target)),e.preventDefault(),this._setSelection(n,a),this.isWheelEvent=!1}},{key:"_onDrop",value:function(e){var t;this.formulaMode||(this.isDropEvent=!0,e.preventDefault(),t=T.isIE11()?"text":"text/plain",e=e.dataTransfer.getData(t),t=this.unformatOther(e),this.set(t),this.isDropEvent=!1)}},{key:"_onFormSubmit",value:function(){var t=this;return this._getFormAutoNumericChildren(this.parentForm).map(function(e){return t.constructor.getAutoNumericElement(e)}).forEach(function(e){return e._unformatOnSubmit()}),!0}},{key:"_onFormReset",value:function(){var i=this;this._getFormAutoNumericChildren(this.parentForm).map(function(e){return i.constructor.getAutoNumericElement(e)}).forEach(function(e){var t=i._getDefaultValue(e.node());setTimeout(function(){return e.set(t)},0)})}},{key:"_unformatOnSubmit",value:function(){this.settings.unformatOnSubmit&&this._setElementValue(this.rawValue)}},{key:"_onKeydownGlobal",value:function(e){T.character(e)===u.keyName.Alt&&(e=T.getHoveredElement(),V.isManagedByAutoNumeric(e))&&!(e=V.getAutoNumericElement(e)).formulaMode&&e.settings.unformatOnHover&&this.constructor._unformatAltHovered(e)}},{key:"_onKeyupGlobal",value:function(e){T.character(e)===u.keyName.Alt&&(e=T.getHoveredElement(),V.isManagedByAutoNumeric(e))&&!(e=V.getAutoNumericElement(e)).formulaMode&&e.settings.unformatOnHover&&this.constructor._reformatAltHovered(e)}},{key:"_isElementTagSupported",value:function(){return T.isElement(this.domElement)||T.throwError("The DOM element is not valid, ".concat(this.domElement," given.")),T.isInArray(this.domElement.tagName.toLowerCase(),this.allowedTagList)}},{key:"_isInputElement",value:function(){return"input"===this.domElement.tagName.toLowerCase()}},{key:"_isInputTypeSupported",value:function(){return"text"===this.domElement.type||"hidden"===this.domElement.type||"tel"===this.domElement.type||T.isUndefinedOrNullOrEmpty(this.domElement.type)}},{key:"_checkElement",value:function(){var e=this.domElement.tagName.toLowerCase();this._isElementTagSupported()||T.throwError("The <".concat(e,"> tag is not supported by autoNumeric")),this._isInputElement()?(this._isInputTypeSupported()||T.throwError('The input type "'.concat(this.domElement.type,'" is not supported by autoNumeric')),this.isInputElement=!0):(this.isInputElement=!1,this.isContentEditable=this.domElement.hasAttribute("contenteditable")&&"true"===this.domElement.getAttribute("contenteditable"))}},{key:"_formatDefaultValueOnPageLoad",value:function(){var e,t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,i=!0;if(T.isNull(t)?(e=T.getElementValue(this.domElement).trim(),this.domElement.setAttribute("value",e)):e=t,this.isInputElement||this.isContentEditable){var n,t=this.constructor._toNumericValue(e,this.settings);if(this.domElement.hasAttribute("value")&&""!==this.domElement.getAttribute("value")?(null!==this.settings.defaultValueOverride&&this.settings.defaultValueOverride.toString()!==e||null===this.settings.defaultValueOverride&&""!==e&&e!==this.domElement.getAttribute("value")||""!==e&&"hidden"===this.domElement.getAttribute("type")&&!T.isNumber(t))&&(this.settings.saveValueToSessionStorage&&(null!==this.settings.decimalPlacesShownOnFocus||this.settings.divisorWhenUnfocused)&&this._setRawValue(this._getValueFromPersistentStorage()),this.settings.saveValueToSessionStorage||(n=this.constructor._removeBrackets(e,this.settings),(this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.suffix||this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.prefix&&this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix)&&""!==this.settings.negativeSignCharacter&&T.isNegative(e,this.settings.negativeSignCharacter)?this._setRawValue("-".concat(this.constructor._stripAllNonNumberCharacters(n,this.settings,!0,this.isFocused))):this._setRawValue(this.constructor._stripAllNonNumberCharacters(n,this.settings,!0,this.isFocused))),i=!1):isNaN(Number(t))||1/0===t?T.throwError("The value [".concat(e,"] used in the input is not a valid value autoNumeric can work with.")):(this.set(t),i=!1),""===e)switch(this.settings.emptyInputBehavior){case V.options.emptyInputBehavior.focus:case V.options.emptyInputBehavior.null:case V.options.emptyInputBehavior.press:break;case V.options.emptyInputBehavior.always:this._setElementValue(this.settings.currencySymbol);break;case V.options.emptyInputBehavior.min:this.set(this.settings.minimumValue);break;case V.options.emptyInputBehavior.max:this.set(this.settings.maximumValue);break;case V.options.emptyInputBehavior.zero:this.set("0");break;default:this.set(this.settings.emptyInputBehavior)}else i&&e===this.domElement.getAttribute("value")&&this.set(e)}else null!==this.settings.defaultValueOverride&&this.settings.defaultValueOverride!==e||this.set(e)}},{key:"_calculateVMinAndVMaxIntegerSizes",value:function(){var e=y(this.settings.maximumValue.toString().split("."),1)[0],t=y(this.settings.minimumValue||0===this.settings.minimumValue?this.settings.minimumValue.toString().split("."):[],1)[0],e=e.replace(this.settings.negativeSignCharacter,""),t=t.replace(this.settings.negativeSignCharacter,"");this.settings.mIntPos=Math.max(e.length,1),this.settings.mIntNeg=Math.max(t.length,1)}},{key:"_calculateValuesToStringsKeys",value:function(){this.settings.valuesToStrings?this.valuesToStringsKeys=Object.keys(this.settings.valuesToStrings):this.valuesToStringsKeys=[]}},{key:"_transformOptionsValuesToDefaultTypes",value:function(){for(var e in this.settings){var t;Object.prototype.hasOwnProperty.call(this.settings,e)&&("true"!==(t=this.settings[e])&&"false"!==t||(this.settings[e]="true"===t),"number"==typeof t)&&(this.settings[e]=t.toString())}}},{key:"_setSettings",value:function(e){var t=1<arguments.length&&void 0!==arguments[1]&&arguments[1];!t&&T.isNull(e)||this.constructor._convertOldOptionsToNewOnes(e),t?("decimalPlacesRawValue"in e&&(this.settings.originalDecimalPlacesRawValue=e.decimalPlacesRawValue),"decimalPlaces"in e&&(this.settings.originalDecimalPlaces=e.decimalPlaces),this.constructor._calculateDecimalPlacesOnUpdate(e,this.settings),this._mergeSettings(e)):(this.settings={},this._mergeSettings(this.constructor.getDefaultConfig(),this.domElement.dataset,e,{rawValue:this.defaultRawValue}),this.caretFix=!1,this.throwInput=!0,this.allowedTagList=u.allowedTagList,this.runOnce=!1,this.hoveredWithAlt=!1),this._transformOptionsValuesToDefaultTypes(),this._runCallbacksFoundInTheSettingsObject(),this.constructor._correctNegativePositiveSignPlacementOption(this.settings),this.constructor._correctCaretPositionOnFocusAndSelectOnFocusOptions(this.settings),this.constructor._setNegativePositiveSignPermissions(this.settings),t||(T.isNull(e)||!e.decimalPlaces?this.settings.originalDecimalPlaces=null:this.settings.originalDecimalPlaces=e.decimalPlaces,this.settings.originalDecimalPlacesRawValue=this.settings.decimalPlacesRawValue,this.constructor._calculateDecimalPlacesOnInit(this.settings)),this._calculateVMinAndVMaxIntegerSizes(),this._setTrailingNegativeSignInfo(),this.regex={},this.constructor._cachesUsualRegularExpressions(this.settings,this.regex),this.constructor._setBrackets(this.settings),this._calculateValuesToStringsKeys(),T.isEmptyObj(this.settings)&&T.throwError("Unable to set the settings, those are invalid ; an empty object was given."),this.constructor.validate(this.settings,!1,e),this._keepAnOriginalSettingsCopy()}},{key:"_preparePastedText",value:function(e){return this.constructor._stripAllNonNumberCharacters(e,this.settings,!0,this.isFocused)}},{key:"_updateInternalProperties",value:function(){this.selection=T.getElementSelection(this.domElement),this.processed=!1}},{key:"_updateEventKeyInfo",value:function(e){this.eventKey=T.character(e)}},{key:"_saveCancellableValue",value:function(){this.savedCancellableValue=this.rawValue}},{key:"_setSelection",value:function(e,t){e=Math.max(e,0),t=Math.min(t,T.getElementValue(this.domElement).length),this.selection={start:e,end:t,length:t-e},T.setElementSelection(this.domElement,e,t)}},{key:"_setCaretPosition",value:function(e){this._setSelection(e,e)}},{key:"_getLeftAndRightPartAroundTheSelection",value:function(){var e=T.getElementValue(this.domElement);return[e.substring(0,this.selection.start),e.substring(this.selection.end,e.length)]}},{key:"_getUnformattedLeftAndRightPartAroundTheSelection",value:function(){var e,t=y(this._getLeftAndRightPartAroundTheSelection(),2),i=t[0],t=t[1];return""===i&&""===t?["",""]:(e=!0,this.eventKey!==u.keyName.Hyphen&&this.eventKey!==u.keyName.Minus||0!==Number(i)||(e=!1),this.isTrailingNegative&&(T.isNegative(t,this.settings.negativeSignCharacter)&&!T.isNegative(i,this.settings.negativeSignCharacter)||""===t&&T.isNegative(i,this.settings.negativeSignCharacter,!0))&&(i=i.replace(this.settings.negativeSignCharacter,""),t=t.replace(this.settings.negativeSignCharacter,""),i=i.replace("-",""),t=t.replace("-",""),i="-".concat(i)),[i=V._stripAllNonNumberCharactersExceptCustomDecimalChar(i,this.settings,e,this.isFocused),t=V._stripAllNonNumberCharactersExceptCustomDecimalChar(t,this.settings,!1,this.isFocused)])}},{key:"_normalizeParts",value:function(e,t){var i,n=!0,n=(this.eventKey!==u.keyName.Hyphen&&this.eventKey!==u.keyName.Minus||0!==Number(e)||(n=!1),this.isTrailingNegative&&T.isNegative(t,this.settings.negativeSignCharacter)&&!T.isNegative(e,this.settings.negativeSignCharacter)&&(e="-".concat(e),t=t.replace(this.settings.negativeSignCharacter,"")),e=V._stripAllNonNumberCharactersExceptCustomDecimalChar(e,this.settings,n,this.isFocused),t=V._stripAllNonNumberCharactersExceptCustomDecimalChar(t,this.settings,!1,this.isFocused),(e=this.settings.leadingZero!==V.options.leadingZero.deny||this.eventKey!==u.keyName.num0&&this.eventKey!==u.keyName.numpad0||0!==Number(e)||T.contains(e,this.settings.decimalCharacter)||""===t?e:e.substring(0,e.length-1))+t);return this.settings.decimalCharacter&&(i=n.match(new RegExp("^".concat(this.regex.aNegRegAutoStrip,"\\").concat(this.settings.decimalCharacter))))&&(n=(e=e.replace(i[1],i[1]+"0"))+t),[e,t,n]}},{key:"_setValueParts",value:function(e,t){var i=2<arguments.length&&void 0!==arguments[2]&&arguments[2],e=y(this._normalizeParts(e,t),3),t=e[0],n=e[1],e=e[2],a=y(V._checkIfInRangeWithOverrideOption(e,this.settings),2),o=a[0],a=a[1];if(o&&a){var r,s=V._truncateDecimalPlaces(e,this.settings,i,this.settings.decimalPlacesRawValue).replace(this.settings.decimalCharacter,".");if(""===s||s===this.settings.negativeSignCharacter){switch(this.settings.emptyInputBehavior){case V.options.emptyInputBehavior.focus:case V.options.emptyInputBehavior.press:case V.options.emptyInputBehavior.always:r="";break;case V.options.emptyInputBehavior.min:r=this.settings.minimumValue;break;case V.options.emptyInputBehavior.max:r=this.settings.maximumValue;break;case V.options.emptyInputBehavior.zero:r="0";break;case V.options.emptyInputBehavior.null:r=null;break;default:r=this.settings.emptyInputBehavior}this._setRawValue(r)}else this._setRawValue(this._trimLeadingAndTrailingZeros(s));s=V._truncateDecimalPlaces(e,this.settings,i,this.settings.decimalPlacesShownOnFocus),e=t.length;return 1===(e=e>s.length?s.length:e)&&"0"===t&&this.settings.leadingZero===V.options.leadingZero.deny&&(e=""===n||"0"===t&&""!==n?1:0),this._setElementValue(s,!1),this._setCaretPosition(e),!0}return this._triggerRangeEvents(o,a),!1}},{key:"_getSignPosition",value:function(){var e,t;return this.settings.currencySymbol?(e=this.settings.currencySymbol.length,t=T.getElementValue(this.domElement),this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.prefix?this.settings.negativeSignCharacter&&t&&t.charAt(0)===this.settings.negativeSignCharacter?[1,e+1]:[0,e]:[(t=t.length)-e,t]):[1e3,-1]}},{key:"_expandSelectionOnSign",value:function(){var e=y(this._getSignPosition(),2),t=e[0],e=e[1],i=this.selection;i.start<e&&i.end>t&&((i.start<t||i.end>e)&&T.getElementValue(this.domElement).substring(Math.max(i.start,t),Math.min(i.end,e)).match(/^\s*$/)?i.start<t?this._setSelection(i.start,t):this._setSelection(e,i.end):this._setSelection(Math.min(i.start,t),Math.max(i.end,e)))}},{key:"_checkPaste",value:function(){var e,t,i;this.formatted||T.isUndefined(this.valuePartsBeforePaste)||(e=this.valuePartsBeforePaste,i=(t=y(this._getLeftAndRightPartAroundTheSelection(),2))[0],t=t[1],delete this.valuePartsBeforePaste,i=i.substr(0,e[0].length)+V._stripAllNonNumberCharactersExceptCustomDecimalChar(i.substr(e[0].length),this.settings,!0,this.isFocused),this._setValueParts(i,t,!0))||(this._setElementValue(e.join(""),!1),this._setCaretPosition(e[0].length))}},{key:"_processNonPrintableKeysAndShortcuts",value:function(e){var t;return(e.ctrlKey||e.metaKey)&&"keyup"===e.type&&!T.isUndefined(this.valuePartsBeforePaste)||e.shiftKey&&this.eventKey===u.keyName.Insert?(this._checkPaste(),!1):!!this.constructor._shouldSkipEventKey(this.eventKey)||((e.ctrlKey||e.metaKey)&&this.eventKey===u.keyName.a?(this.settings.selectNumberOnly&&(e.preventDefault(),this.selectNumber()),!0):!e.ctrlKey&&!e.metaKey||this.eventKey!==u.keyName.c&&this.eventKey!==u.keyName.v&&this.eventKey!==u.keyName.x?e.ctrlKey||e.metaKey?!(this.eventKey===u.keyName.Z||this.eventKey===u.keyName.z):this.eventKey===u.keyName.LeftArrow||this.eventKey===u.keyName.RightArrow?("keydown"!==e.type||e.shiftKey||(t=T.getElementValue(this.domElement),this.eventKey!==u.keyName.LeftArrow||t.charAt(this.selection.start-2)!==this.settings.digitGroupSeparator&&t.charAt(this.selection.start-2)!==this.settings.decimalCharacter?this.eventKey!==u.keyName.RightArrow||t.charAt(this.selection.start+1)!==this.settings.digitGroupSeparator&&t.charAt(this.selection.start+1)!==this.settings.decimalCharacter||this._setCaretPosition(this.selection.start+1):this._setCaretPosition(this.selection.start-1)),!0):T.isInArray(this.eventKey,u.keyName._directionKeys):("keydown"===e.type&&this._expandSelectionOnSign(),this.eventKey!==u.keyName.v&&this.eventKey!==u.keyName.Insert||("keydown"===e.type||"keypress"===e.type?T.isUndefined(this.valuePartsBeforePaste)&&(this.valuePartsBeforePaste=this._getLeftAndRightPartAroundTheSelection()):this._checkPaste()),"keydown"===e.type||"keypress"===e.type||this.eventKey===u.keyName.c))}},{key:"_processCharacterDeletionIfTrailingNegativeSign",value:function(e){var e=y(e,2),t=e[0],i=e[1],n=T.getElementValue(this.domElement),a=T.isNegative(n,this.settings.negativeSignCharacter);if(this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.suffix&&(this.eventKey===u.keyName.Backspace?(this.caretFix=this.selection.start>=n.indexOf(this.settings.suffixText)&&""!==this.settings.suffixText,"-"===n.charAt(this.selection.start-1)?t=t.substring(1):this.selection.start<=n.length-this.settings.suffixText.length&&(t=t.substring(0,t.length-1))):(this.caretFix=this.selection.start>=n.indexOf(this.settings.suffixText)&&""!==this.settings.suffixText,this.selection.start>=n.indexOf(this.settings.currencySymbol)+this.settings.currencySymbol.length&&(i=i.substring(1,i.length)),T.isNegative(t,this.settings.negativeSignCharacter)&&"-"===n.charAt(this.selection.start)&&(t=t.substring(1)))),this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix)switch(this.settings.negativePositiveSignPlacement){case V.options.negativePositiveSignPlacement.left:this.caretFix=this.selection.start>=n.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length,this.eventKey===u.keyName.Backspace?this.selection.start===n.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length&&a?t=t.substring(1):"-"!==t&&(this.selection.start<=n.indexOf(this.settings.negativeSignCharacter)||!a)&&(t=t.substring(0,t.length-1)):("-"===t[0]&&(i=i.substring(1)),this.selection.start===n.indexOf(this.settings.negativeSignCharacter)&&a&&(t=t.substring(1)));break;case V.options.negativePositiveSignPlacement.right:this.caretFix=this.selection.start>=n.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length,this.eventKey===u.keyName.Backspace?this.selection.start===n.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length?t=t.substring(1):("-"!==t&&this.selection.start<=n.indexOf(this.settings.negativeSignCharacter)-this.settings.currencySymbol.length||""!==t&&!a)&&(t=t.substring(0,t.length-1)):(this.caretFix=this.selection.start>=n.indexOf(this.settings.currencySymbol)&&""!==this.settings.currencySymbol,this.selection.start===n.indexOf(this.settings.negativeSignCharacter)&&(t=t.substring(1)),i=i.substring(1))}return[t,i]}},{key:"_processCharacterDeletion",value:function(e){var t,i,n;return this.selection.length?(this._expandSelectionOnSign(),i=(n=y(this._getUnformattedLeftAndRightPartAroundTheSelection(),2))[0],n=n[1]):(i=(t=y(this._getUnformattedLeftAndRightPartAroundTheSelection(),2))[0],n=t[1],""===i&&""===n&&(this.throwInput=!1),this.isTrailingNegative&&T.isNegative(T.getElementValue(this.domElement),this.settings.negativeSignCharacter)?(i=(t=y(this._processCharacterDeletionIfTrailingNegativeSign([i,n]),2))[0],n=t[1]):this.eventKey===u.keyName.Backspace?i=i.substring(0,i.length-1):n=n.substring(1,n.length)),!!this.constructor._isWithinRangeWithOverrideOption("".concat(i).concat(n),this.settings)&&T.getElementValue(e.target)!==this.settings.currencySymbol&&(this._setValueParts(i,n),!0)}},{key:"_isDecimalCharacterInsertionAllowed",value:function(){return String(this.settings.decimalPlacesShownOnFocus)!==String(V.options.decimalPlacesShownOnFocus.none)&&String(this.settings.decimalPlaces)!==String(V.options.decimalPlaces.none)}},{key:"_processCharacterInsertion",value:function(){var e,t=y(this._getUnformattedLeftAndRightPartAroundTheSelection(),2),i=t[0],t=t[1];if(this.eventKey!==u.keyName.AndroidDefault&&(this.throwInput=!0),this.eventKey===this.settings.decimalCharacter||this.settings.decimalCharacterAlternative&&this.eventKey===this.settings.decimalCharacterAlternative){if(!this._isDecimalCharacterInsertionAllowed()||!this.settings.decimalCharacter)return!1;if(this.settings.alwaysAllowDecimalCharacter)i=i.replace(this.settings.decimalCharacter,""),t=t.replace(this.settings.decimalCharacter,"");else{if(T.contains(i,this.settings.decimalCharacter))return!0;if(0<t.indexOf(this.settings.decimalCharacter))return!0;0===t.indexOf(this.settings.decimalCharacter)&&(t=t.substr(1))}return this.settings.negativeSignCharacter&&T.contains(t,this.settings.negativeSignCharacter)&&(i="".concat(this.settings.negativeSignCharacter).concat(i),t=t.replace(this.settings.negativeSignCharacter,"")),this._setValueParts(i+this.settings.decimalCharacter,t),!0}return"-"!==this.eventKey&&"+"!==this.eventKey||!this.settings.isNegativeSignAllowed?0<=(e=Number(this.eventKey))&&e<=9?(this.settings.isNegativeSignAllowed&&""===i&&T.contains(t,"-")&&(i="-",t=t.substring(1,t.length)),this.settings.maximumValue<=0&&this.settings.minimumValue<this.settings.maximumValue&&!T.contains(T.getElementValue(this.domElement),this.settings.negativeSignCharacter)&&"0"!==this.eventKey&&(i="-".concat(i)),this._setValueParts("".concat(i).concat(this.eventKey),t),!0):this.throwInput=!1:(""===i&&T.contains(t,"-")?t=t.replace("-",""):i=T.isNegativeStrict(i,"-")?i.replace("-",""):"".concat(this.settings.negativeSignCharacter).concat(i),this._setValueParts(i,t),!0)}},{key:"_formatValue",value:function(e){var t=T.getElementValue(this.domElement),i=y(this._getUnformattedLeftAndRightPartAroundTheSelection(),1)[0],n=(""!==this.settings.digitGroupSeparator&&(""===this.settings.digitGroupSeparator||T.contains(t,this.settings.digitGroupSeparator))||""!==this.settings.currencySymbol&&(""===this.settings.currencySymbol||T.contains(t,this.settings.currencySymbol))||(n=y(t.split(this.settings.decimalCharacter),1)[0],a="",T.isNegative(n,this.settings.negativeSignCharacter)&&(a=this.settings.negativeSignCharacter,n=n.replace(this.settings.negativeSignCharacter,""),i=i.replace("-","")),""===a&&n.length>this.settings.mIntPos&&"0"===i.charAt(0)&&(i=i.slice(1)),a===this.settings.negativeSignCharacter&&n.length>this.settings.mIntNeg&&"0"===i.charAt(0)&&(i=i.slice(1)),this.isTrailingNegative)||(i="".concat(a).concat(i)),this.constructor._addGroupSeparators(t,this.settings,this.isFocused,this.rawValue)),a=n.length;if(n){var o,r,s,l=i.split("");(this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.suffix||this.settings.negativePositiveSignPlacement!==V.options.negativePositiveSignPlacement.prefix&&this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix)&&l[0]===this.settings.negativeSignCharacter&&!this.settings.isNegativeSignAllowed&&(l.shift(),this.eventKey===u.keyName.Backspace||this.eventKey===u.keyName.Delete)&&this.caretFix&&((this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix&&this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.left||this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.suffix)&&(l.push(this.settings.negativeSignCharacter),this.caretFix="keydown"===e.type),this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix)&&this.settings.negativePositiveSignPlacement===V.options.negativePositiveSignPlacement.right&&(o=this.settings.currencySymbol.split(""),r=["\\","^","$",".","|","?","*","+","(",")","["],s=[],o.forEach(function(e,t){t=o[e],T.isInArray(t,r)?s.push("\\"+t):s.push(t)}),this.eventKey===u.keyName.Backspace&&"-"===this.settings.negativeSignCharacter&&s.push("-"),l.push(s.join("")),this.caretFix="keydown"===e.type);for(var c=0;c<l.length;c++)l[c].match("\\d")||(l[c]="\\"+l[c]);i=this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix?new RegExp("^.*?".concat(l.join(".*?"))):new RegExp("^.*?[".concat(this.settings.currencySymbol,"]").concat(l.join(".*?"))),e=n.match(i);e?(a=e[0].length,(0===(a=this.settings.showPositiveSign&&0===(a=0===a&&e.input.charAt(0)===this.settings.positiveSignCharacter?1===e.input.indexOf(this.settings.currencySymbol)?this.settings.currencySymbol.length+1:1:a)&&e.input.charAt(this.settings.currencySymbol.length)===this.settings.positiveSignCharacter?this.settings.currencySymbol.length+1:a)&&n.charAt(0)!==this.settings.negativeSignCharacter||1===a&&n.charAt(0)===this.settings.negativeSignCharacter)&&this.settings.currencySymbol&&this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.prefix&&(a=this.settings.currencySymbol.length+(T.isNegativeStrict(n,this.settings.negativeSignCharacter)?1:0))):(this.settings.currencySymbol&&this.settings.currencySymbolPlacement===V.options.currencySymbolPlacement.suffix&&(a-=this.settings.currencySymbol.length),this.settings.suffixText&&(a-=this.settings.suffixText.length))}n!==t&&(this._setElementValue(n,!1),this._setCaretPosition(a)),this.formatted=!0}}]),K(e,t),Object.defineProperty(e,"prototype",{writable:!1}),V}();function G(e,t){t=t||{bubbles:!1,cancelable:!1,detail:void 0};var i=document.createEvent("CustomEvent");return i.initCustomEvent(e,t.bubbles,t.cancelable,t.detail),i}w(O,"options",void 0),w(O,"events",void 0),w(O,"defaultSettings",void 0),w(O,"predefinedOptions",void 0),O.multiple=function(e){var i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,t=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,n=[];if(T.isObject(i)&&(t=i,i=null),T.isString(e)?e=f(document.querySelectorAll(e)):T.isObject(e)?(Object.prototype.hasOwnProperty.call(e,"rootElement")||T.throwError("The object passed to the 'multiple' function is invalid ; no 'rootElement' attribute found."),a=f(e.rootElement.querySelectorAll("input")),e=Object.prototype.hasOwnProperty.call(e,"exclude")?(Array.isArray(e.exclude)||T.throwError("The 'exclude' array passed to the 'multiple' function is invalid."),T.filterOut(a,e.exclude)):a):T.isArray(e)||T.throwError("The given parameters to the 'multiple' function are invalid."),0===e.length)return a=!0,!T.isNull(t)&&T.isBoolean(t.showWarnings)&&(a=t.showWarnings),T.warning("No valid DOM elements were given hence no AutoNumeric objects were instantiated.",a),[];var a=T.isArray(i)&&1<=i.length,o=!1,r=!1;a&&(a=b(Number(i[0])),(o="number"===a&&!isNaN(Number(i[0])))||"string"!==a&&!isNaN(a)&&"object"!==a||(r=!0));var s,l,c,a=!1,u=(T.isArray(t)&&1<=t.length&&("string"===(s=b(t[0]))||"object"===s)&&(a=!0),l=r?O.mergeOptions(i):a?O.mergeOptions(t):t,T.isNumber(i));return o&&(c=i.length),e.forEach(function(e,t){n.push(new O(e,u?i:o&&t<=c?i[t]:null,l))}),n},Array.from||(Array.from=function(e){return[].slice.call(e)}),"undefined"!=typeof window&&"function"!=typeof window.CustomEvent&&(G.prototype=window.Event.prototype,window.CustomEvent=G),O.events={correctedValue:"autoNumeric:correctedValue",initialized:"autoNumeric:initialized",invalidFormula:"autoNumeric:invalidFormula",invalidValue:"autoNumeric:invalidValue",formatted:"autoNumeric:formatted",rawValueModified:"autoNumeric:rawValueModified",minRangeExceeded:"autoNumeric:minExceeded",maxRangeExceeded:"autoNumeric:maxExceeded",native:{input:"input",change:"change"},validFormula:"autoNumeric:validFormula"},Object.freeze(O.events.native),Object.freeze(O.events),Object.defineProperty(O,"events",{configurable:!1,writable:!1}),O.options={allowDecimalPadding:{always:!0,never:!1,floats:"floats"},alwaysAllowDecimalCharacter:{alwaysAllow:!0,doNotAllow:!1},caretPositionOnFocus:{start:"start",end:"end",decimalLeft:"decimalLeft",decimalRight:"decimalRight",doNoForceCaretPosition:null},createLocalList:{createList:!0,doNotCreateList:!1},currencySymbol:{none:"",currencySign:"¤",austral:"₳",australCentavo:"¢",baht:"฿",cedi:"₵",cent:"¢",colon:"₡",cruzeiro:"₢",dollar:"$",dong:"₫",drachma:"₯",dram:"​֏",european:"₠",euro:"€",florin:"ƒ",franc:"₣",guarani:"₲",hryvnia:"₴",kip:"₭",att:"ອັດ",lepton:"Λ.",lira:"₺",liraOld:"₤",lari:"₾",mark:"ℳ",mill:"₥",naira:"₦",peseta:"₧",peso:"₱",pfennig:"₰",pound:"£",real:"R$ ",riel:"៛",ruble:"₽",rupee:"₹",rupeeOld:"₨",shekel:"₪",shekelAlt:"ש״ח‎‎",taka:"৳",tenge:"₸",togrog:"₮",won:"₩",yen:"¥"},currencySymbolPlacement:{prefix:"p",suffix:"s"},decimalCharacter:{comma:",",dot:".",middleDot:"·",arabicDecimalSeparator:"٫",decimalSeparatorKeySymbol:"⎖"},decimalCharacterAlternative:{none:null,comma:",",dot:"."},decimalPlaces:{none:0,one:1,two:2,three:3,four:4,five:5,six:6},decimalPlacesRawValue:{useDefault:null,none:0,one:1,two:2,three:3,four:4,five:5,six:6},decimalPlacesShownOnBlur:{useDefault:null,none:0,one:1,two:2,three:3,four:4,five:5,six:6},decimalPlacesShownOnFocus:{useDefault:null,none:0,one:1,two:2,three:3,four:4,five:5,six:6},defaultValueOverride:{doNotOverride:null},digitalGroupSpacing:{two:"2",twoScaled:"2s",three:"3",four:"4"},digitGroupSeparator:{comma:",",dot:".",normalSpace:" ",thinSpace:" ",narrowNoBreakSpace:" ",noBreakSpace:" ",noSeparator:"",apostrophe:"'",arabicThousandsSeparator:"٬",dotAbove:"˙",privateUseTwo:"’"},divisorWhenUnfocused:{none:null,percentage:100,permille:1e3,basisPoint:1e4},emptyInputBehavior:{focus:"focus",press:"press",always:"always",zero:"zero",min:"min",max:"max",null:"null"},eventBubbles:{bubbles:!0,doesNotBubble:!1},eventIsCancelable:{isCancelable:!0,isNotCancelable:!1},failOnUnknownOption:{fail:!0,ignore:!1},formatOnPageLoad:{format:!0,doNotFormat:!1},formulaMode:{enabled:!0,disabled:!1},historySize:{verySmall:5,small:10,medium:20,large:50,veryLarge:100,insane:Number.MAX_SAFE_INTEGER},invalidClass:"an-invalid",isCancellable:{cancellable:!0,notCancellable:!1},leadingZero:{allow:"allow",deny:"deny",keep:"keep"},maximumValue:{tenTrillions:"10000000000000",oneBillion:"1000000000",zero:"0"},minimumValue:{tenTrillions:"-10000000000000",oneBillion:"-1000000000",zero:"0"},modifyValueOnWheel:{modifyValue:!0,doNothing:!1},negativeBracketsTypeOnBlur:{parentheses:"(,)",brackets:"[,]",chevrons:"<,>",curlyBraces:"{,}",angleBrackets:"〈,〉",japaneseQuotationMarks:"｢,｣",halfBrackets:"⸤,⸥",whiteSquareBrackets:"⟦,⟧",quotationMarks:"‹,›",guillemets:"«,»",none:null},negativePositiveSignPlacement:{prefix:"p",suffix:"s",left:"l",right:"r",none:null},negativeSignCharacter:{hyphen:"-",minus:"−",heavyMinus:"➖",fullWidthHyphen:"－",circledMinus:"⊖",squaredMinus:"⊟",triangleMinus:"⨺",plusMinus:"±",minusPlus:"∓",dotMinus:"∸",minusTilde:"≂",not:"¬"},noEventListeners:{noEvents:!0,addEvents:!1},onInvalidPaste:{error:"error",ignore:"ignore",clamp:"clamp",truncate:"truncate",replace:"replace"},outputFormat:{string:"string",number:"number",dot:".",negativeDot:"-.",comma:",",negativeComma:"-,",dotNegative:".-",commaNegative:",-",none:null},overrideMinMaxLimits:{ceiling:"ceiling",floor:"floor",ignore:"ignore",invalid:"invalid",doNotOverride:null},positiveSignCharacter:{plus:"+",fullWidthPlus:"＋",heavyPlus:"➕",doublePlus:"⧺",triplePlus:"⧻",circledPlus:"⊕",squaredPlus:"⊞",trianglePlus:"⨹",plusMinus:"±",minusPlus:"∓",dotPlus:"∔",altHebrewPlus:"﬩",normalSpace:" ",thinSpace:" ",narrowNoBreakSpace:" ",noBreakSpace:" "},rawValueDivisor:{none:null,percentage:100,permille:1e3,basisPoint:1e4},readOnly:{readOnly:!0,readWrite:!1},roundingMethod:{halfUpSymmetric:"S",halfUpAsymmetric:"A",halfDownSymmetric:"s",halfDownAsymmetric:"a",halfEvenBankersRounding:"B",upRoundAwayFromZero:"U",downRoundTowardZero:"D",toCeilingTowardPositiveInfinity:"C",toFloorTowardNegativeInfinity:"F",toNearest05:"N05",toNearest05Alt:"CHF",upToNext05:"U05",downToNext05:"D05"},saveValueToSessionStorage:{save:!0,doNotSave:!1},selectNumberOnly:{selectNumbersOnly:!0,selectAll:!1},selectOnFocus:{select:!0,doNotSelect:!1},serializeSpaces:{plus:"+",percent:"%20"},showOnlyNumbersOnFocus:{onlyNumbers:!0,showAll:!1},showPositiveSign:{show:!0,hide:!1},showWarnings:{show:!0,hide:!1},styleRules:{none:null,positiveNegative:{positive:"autoNumeric-positive",negative:"autoNumeric-negative"},range0To100With4Steps:{ranges:[{min:0,max:25,class:"autoNumeric-red"},{min:25,max:50,class:"autoNumeric-orange"},{min:50,max:75,class:"autoNumeric-yellow"},{min:75,max:100,class:"autoNumeric-green"}]},evenOdd:{userDefined:[{callback:function(e){return e%2==0},classes:["autoNumeric-even","autoNumeric-odd"]}]},rangeSmallAndZero:{userDefined:[{callback:function(e){return-1<=e&&e<0?0:0===Number(e)?1:0<e&&e<=1?2:null},classes:["autoNumeric-small-negative","autoNumeric-zero","autoNumeric-small-positive"]}]}},suffixText:{none:"",percentage:"%",permille:"‰",basisPoint:"‱"},symbolWhenUnfocused:{none:null,percentage:"%",permille:"‰",basisPoint:"‱"},unformatOnHover:{unformat:!0,doNotUnformat:!1},unformatOnSubmit:{unformat:!0,keepCurrentValue:!1},valuesToStrings:{none:null,zeroDash:{0:"-"},oneAroundZero:{"-1":"Min",1:"Max"}},watchExternalChanges:{watch:!0,doNotWatch:!1},wheelOn:{focus:"focus",hover:"hover"},wheelStep:{progressive:"progressive"}},P=O.options,Object.getOwnPropertyNames(P).forEach(function(e){"valuesToStrings"===e?Object.getOwnPropertyNames(P.valuesToStrings).forEach(function(e){T.isIE11()||null===P.valuesToStrings[e]||Object.freeze(P.valuesToStrings[e])}):"styleRules"===e||T.isIE11()||null===P[e]||Object.freeze(P[e])}),Object.freeze(P),Object.defineProperty(O,"options",{configurable:!1,writable:!1}),O.defaultSettings={allowDecimalPadding:O.options.allowDecimalPadding.always,alwaysAllowDecimalCharacter:O.options.alwaysAllowDecimalCharacter.doNotAllow,caretPositionOnFocus:O.options.caretPositionOnFocus.doNoForceCaretPosition,createLocalList:O.options.createLocalList.createList,currencySymbol:O.options.currencySymbol.none,currencySymbolPlacement:O.options.currencySymbolPlacement.prefix,decimalCharacter:O.options.decimalCharacter.dot,decimalCharacterAlternative:O.options.decimalCharacterAlternative.none,decimalPlaces:O.options.decimalPlaces.two,decimalPlacesRawValue:O.options.decimalPlacesRawValue.useDefault,decimalPlacesShownOnBlur:O.options.decimalPlacesShownOnBlur.useDefault,decimalPlacesShownOnFocus:O.options.decimalPlacesShownOnFocus.useDefault,defaultValueOverride:O.options.defaultValueOverride.doNotOverride,digitalGroupSpacing:O.options.digitalGroupSpacing.three,digitGroupSeparator:O.options.digitGroupSeparator.comma,divisorWhenUnfocused:O.options.divisorWhenUnfocused.none,emptyInputBehavior:O.options.emptyInputBehavior.focus,eventBubbles:O.options.eventBubbles.bubbles,eventIsCancelable:O.options.eventIsCancelable.isCancelable,failOnUnknownOption:O.options.failOnUnknownOption.ignore,formatOnPageLoad:O.options.formatOnPageLoad.format,formulaMode:O.options.formulaMode.disabled,historySize:O.options.historySize.medium,invalidClass:O.options.invalidClass,isCancellable:O.options.isCancellable.cancellable,leadingZero:O.options.leadingZero.deny,maximumValue:O.options.maximumValue.tenTrillions,minimumValue:O.options.minimumValue.tenTrillions,modifyValueOnWheel:O.options.modifyValueOnWheel.modifyValue,negativeBracketsTypeOnBlur:O.options.negativeBracketsTypeOnBlur.none,negativePositiveSignPlacement:O.options.negativePositiveSignPlacement.none,negativeSignCharacter:O.options.negativeSignCharacter.hyphen,noEventListeners:O.options.noEventListeners.addEvents,onInvalidPaste:O.options.onInvalidPaste.error,outputFormat:O.options.outputFormat.none,overrideMinMaxLimits:O.options.overrideMinMaxLimits.doNotOverride,positiveSignCharacter:O.options.positiveSignCharacter.plus,rawValueDivisor:O.options.rawValueDivisor.none,readOnly:O.options.readOnly.readWrite,roundingMethod:O.options.roundingMethod.halfUpSymmetric,saveValueToSessionStorage:O.options.saveValueToSessionStorage.doNotSave,selectNumberOnly:O.options.selectNumberOnly.selectNumbersOnly,selectOnFocus:O.options.selectOnFocus.select,serializeSpaces:O.options.serializeSpaces.plus,showOnlyNumbersOnFocus:O.options.showOnlyNumbersOnFocus.showAll,showPositiveSign:O.options.showPositiveSign.hide,showWarnings:O.options.showWarnings.show,styleRules:O.options.styleRules.none,suffixText:O.options.suffixText.none,symbolWhenUnfocused:O.options.symbolWhenUnfocused.none,unformatOnHover:O.options.unformatOnHover.unformat,unformatOnSubmit:O.options.unformatOnSubmit.keepCurrentValue,valuesToStrings:O.options.valuesToStrings.none,watchExternalChanges:O.options.watchExternalChanges.doNotWatch,wheelOn:O.options.wheelOn.focus,wheelStep:O.options.wheelStep.progressive},Object.freeze(O.defaultSettings),Object.defineProperty(O,"defaultSettings",{configurable:!1,writable:!1});var t={digitGroupSeparator:O.options.digitGroupSeparator.dot,decimalCharacter:O.options.decimalCharacter.comma,decimalCharacterAlternative:O.options.decimalCharacterAlternative.dot,currencySymbol:" €",currencySymbolPlacement:O.options.currencySymbolPlacement.suffix,negativePositiveSignPlacement:O.options.negativePositiveSignPlacement.prefix},k={digitGroupSeparator:O.options.digitGroupSeparator.comma,decimalCharacter:O.options.decimalCharacter.dot,currencySymbol:O.options.currencySymbol.dollar,currencySymbolPlacement:O.options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:O.options.negativePositiveSignPlacement.right},H={digitGroupSeparator:O.options.digitGroupSeparator.comma,decimalCharacter:O.options.decimalCharacter.dot,currencySymbol:O.options.currencySymbol.yen,currencySymbolPlacement:O.options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:O.options.negativePositiveSignPlacement.right},Z=(T.cloneObject(t).formulaMode=O.options.formulaMode.enabled,T.cloneObject(t)),N=(Z.minimumValue=0,T.cloneObject(t)),E=(N.maximumValue=0,N.negativePositiveSignPlacement=O.options.negativePositiveSignPlacement.prefix,T.cloneObject(t)),q=(E.digitGroupSeparator=O.options.digitGroupSeparator.normalSpace,T.cloneObject(E)),_=(q.minimumValue=0,T.cloneObject(E)),C=(_.maximumValue=0,_.negativePositiveSignPlacement=O.options.negativePositiveSignPlacement.prefix,T.cloneObject(t)),F=(C.currencySymbol=O.options.currencySymbol.none,C.suffixText=" ".concat(O.options.suffixText.percentage),C.wheelStep=1e-4,C.rawValueDivisor=O.options.rawValueDivisor.percentage,T.cloneObject(C)),x=(F.minimumValue=0,T.cloneObject(C)),$=(x.maximumValue=0,x.negativePositiveSignPlacement=O.options.negativePositiveSignPlacement.prefix,T.cloneObject(C)),J=($.decimalPlaces=3,T.cloneObject(F)),Y=(J.decimalPlaces=3,T.cloneObject(x)),Q=(Y.decimalPlaces=3,T.cloneObject(k).formulaMode=O.options.formulaMode.enabled,T.cloneObject(k)),V=(Q.minimumValue=0,T.cloneObject(k)),X=(V.maximumValue=0,V.negativePositiveSignPlacement=O.options.negativePositiveSignPlacement.prefix,T.cloneObject(V)),A=(X.negativeBracketsTypeOnBlur=O.options.negativeBracketsTypeOnBlur.parentheses,T.cloneObject(k)),L=(A.currencySymbol=O.options.currencySymbol.none,A.suffixText=O.options.suffixText.percentage,A.wheelStep=1e-4,A.rawValueDivisor=O.options.rawValueDivisor.percentage,T.cloneObject(A)),I=(L.minimumValue=0,T.cloneObject(A)),ee=(I.maximumValue=0,I.negativePositiveSignPlacement=O.options.negativePositiveSignPlacement.prefix,T.cloneObject(A)),te=(ee.decimalPlaces=3,T.cloneObject(L)),ie=(te.decimalPlaces=3,T.cloneObject(I)),ne=(ie.decimalPlaces=3,T.cloneObject(t));ne.currencySymbol=O.options.currencySymbol.lira,O.predefinedOptions={euro:t,euroPos:Z,euroNeg:N,euroSpace:E,euroSpacePos:q,euroSpaceNeg:_,percentageEU2dec:C,percentageEU2decPos:F,percentageEU2decNeg:x,percentageEU3dec:$,percentageEU3decPos:J,percentageEU3decNeg:Y,dollar:k,dollarPos:Q,dollarNeg:V,dollarNegBrackets:X,percentageUS2dec:A,percentageUS2decPos:L,percentageUS2decNeg:I,percentageUS3dec:ee,percentageUS3decPos:te,percentageUS3decNeg:ie,French:t,Spanish:t,NorthAmerican:k,British:{digitGroupSeparator:O.options.digitGroupSeparator.comma,decimalCharacter:O.options.decimalCharacter.dot,currencySymbol:O.options.currencySymbol.pound,currencySymbolPlacement:O.options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:O.options.negativePositiveSignPlacement.right},Swiss:{digitGroupSeparator:O.options.digitGroupSeparator.apostrophe,decimalCharacter:O.options.decimalCharacter.dot,currencySymbol:" CHF",currencySymbolPlacement:O.options.currencySymbolPlacement.suffix,negativePositiveSignPlacement:O.options.negativePositiveSignPlacement.prefix},Japanese:H,Chinese:H,Brazilian:{digitGroupSeparator:O.options.digitGroupSeparator.dot,decimalCharacter:O.options.decimalCharacter.comma,currencySymbol:O.options.currencySymbol.real,currencySymbolPlacement:O.options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:O.options.negativePositiveSignPlacement.right},Turkish:ne,dotDecimalCharCommaSeparator:{digitGroupSeparator:O.options.digitGroupSeparator.comma,decimalCharacter:O.options.decimalCharacter.dot},commaDecimalCharDotSeparator:{digitGroupSeparator:O.options.digitGroupSeparator.dot,decimalCharacter:O.options.decimalCharacter.comma,decimalCharacterAlternative:O.options.decimalCharacterAlternative.dot},integer:{decimalPlaces:0},integerPos:{minimumValue:O.options.minimumValue.zero,decimalPlaces:0},integerNeg:{maximumValue:O.options.maximumValue.zero,decimalPlaces:0},float:{allowDecimalPadding:O.options.allowDecimalPadding.never},floatPos:{allowDecimalPadding:O.options.allowDecimalPadding.never,minimumValue:O.options.minimumValue.zero,maximumValue:O.options.maximumValue.tenTrillions},floatNeg:{allowDecimalPadding:O.options.allowDecimalPadding.never,minimumValue:O.options.minimumValue.tenTrillions,maximumValue:O.options.maximumValue.zero},numeric:{digitGroupSeparator:O.options.digitGroupSeparator.noSeparator,decimalCharacter:O.options.decimalCharacter.dot,currencySymbol:O.options.currencySymbol.none},numericPos:{digitGroupSeparator:O.options.digitGroupSeparator.noSeparator,decimalCharacter:O.options.decimalCharacter.dot,currencySymbol:O.options.currencySymbol.none,minimumValue:O.options.minimumValue.zero,maximumValue:O.options.maximumValue.tenTrillions},numericNeg:{digitGroupSeparator:O.options.digitGroupSeparator.noSeparator,decimalCharacter:O.options.decimalCharacter.dot,currencySymbol:O.options.currencySymbol.none,minimumValue:O.options.minimumValue.tenTrillions,maximumValue:O.options.maximumValue.zero}},Object.getOwnPropertyNames(O.predefinedOptions).forEach(function(e){Object.freeze(O.predefinedOptions[e])}),Object.freeze(O.predefinedOptions),Object.defineProperty(O,"predefinedOptions",{configurable:!1,writable:!1});const ae=O;return e.default})());
//# sourceMappingURL=autoNumeric.min.js.map