/**
 * NextGEN Gallery Optimizer Basic
 *
 * NextGEN Gallery Optimizer improves your site's page load speed, by
 * preventing NextGEN's scripts and stylesheets from loading on posts and pages
 * *without* NextGEN Gallery content.
 *
 * Additionally...
 *
 * If you're using NextGEN v2.x.xx, Optimizer also provides you with complete
 * granular control of the scripts and stylesheets that load on posts and pages
 * *with* NextGEN Gallery content. For a live example of these settings in action,
 * please view the source of Optimizer's homepage (a NextGEN v2.x.xx gallery
 * page with AJAX pagination) in your browser.
 *
 * If you're using NextGEN Legacy (v1.6.2 to v1.9.13) or the NextCellent
 * Gallery fork, Optimizer will intelligently fine-tune all your posts and pages
 * *with* NextGEN Gallery content automatically... detecting every shortcode
 * and setting, to only load the scripts and stylesheets required on each page.
 *
 * For a full overview of the optimization process, please see...
 * http://www.nextgengalleryoptimizer.com/optimization-flowcharts/
 *
 * Optimizer also includes an *enhanced* version of the fantastic Fancybox
 * lightbox script, and only loads it on appropriate posts and pages *with*
 * NextGEN Gallery content. The result? Gorgeous galleries *and* a speedy site.
 *
 * Optimizer v2.1.5 currently supports (and is tested compatible with) NextGEN
 * Gallery (v2.0.0 to v2.1.60), NextGEN Legacy (v1.6.2 to v1.9.13) and
 * NextCellent Gallery (v1.9.14 to v1.9.31).
 *
 * NextGEN Gallery Optimizer Pro
 *
 * Upgrade to Optimizer Pro for the new "NextGEN Gallery Deactivator" feature.
 * A whole new level of speed optimization.
 * Only load NextGEN's PHP *code* on posts/pages *with* NextGEN Gallery content.
 * http://www.nextgengalleryoptimizer.com/#nextgen-gallery-deactivator
 *
 * Upgrade to Optimizer Pro for the new "Dynamic Fancybox Settings Interface".
 * The fastest and easiest way to customize Fancybox.
 * Set title styles, background color & opacity, make Fancybox responsive & more.
 * http://www.nextgengalleryoptimizer.com/#dynamic-fancybox-settings-interface
 *
 * For more information, please see the following...
 * http://www.nextgengalleryoptimizer.com
 * http://www.nextgengalleryoptimizer.com/documentation/
 * http://www.nextgengalleryoptimizer.com/nextgen-gallery-optimizer-pro/
 * http://www.nextgengalleryoptimizer.com/purchase/
 *
 * @package		NextGEN_Gallery_Optimizer_Basic
 * @author		Mark Jeldi | Helpful Media <http://www.nextgengalleryoptimizer.com/contact/>
 * @link				http://www.nextgengalleryoptimizer.com
 * @copyright	2012 - 2016 Mark Jeldi | Helpful Media
 */

/**
 * Optimizer Basic's Dynamic Fancybox Settings Interface Demo JavaScript
 *
 * Requires jQuery v1.4.4+ as included in WordPress v3.1.
 *
 * @package		NextGEN_Gallery_Optimizer_Basic
 * @author		Mark Jeldi | Helpful Media <http://www.nextgengalleryoptimizer.com/contact/>
 * @link				http://www.nextgengalleryoptimizer.com
 * @copyright	2012 - 2016 Mark Jeldi | Helpful Media
 * @since 			2.0.0
 */
;(function(f,a,oa){var E,u,v,w,R,F,r,$,S,K,s,e,G,x,l,k,y,T,n,p,z,h,U,H,q,V,M,b,A,I,B=parent.nggobasicDFSIDemoVars.pluginDirUrl,m,C,t,W,N,O,aa,la=function(){parent.jQuery("#nggobasic-fancybox-wrap").append(parent.jQuery('<div class="nggobasic-fancybox-title nggobasic-fancybox-title-float"><table id="nggobasic-fancybox-title-float-wrap" cellpadding="0" cellspacing="0"><tbody><tr><td id="nggobasic-fancybox-title-float-left"></td><td id="nggobasic-fancybox-title-float-main"><span class="nggobasic-dfsi-title-text"></span></td><td id="nggobasic-fancybox-title-float-right"></td></tr></tbody></table></div>'),
parent.jQuery('<div class="nggobasic-fancybox-title"><div class="nggobasic-fancybox-title-outside" style="padding-left:10px;"><span class="nggobasic-dfsi-title-text"></span></div></div>'));parent.jQuery("#nggobasic-fancybox-outer").append(parent.jQuery('<div class="nggobasic-fancybox-title nggobasic-fancybox-title-over" style="margin-left: 10px; width: '+a(window).width()+'px; bottom: 10px; display: block;"><div id="nggobasic-fancybox-title-over"><span class="nggobasic-dfsi-title-text"></span></div>'),
parent.jQuery('<div class="nggobasic-fancybox-title nggobasic-fancybox-title-inside"><div id="nggobasic-fancybox-title-inside"><span class="nggobasic-dfsi-title-text"></span></div></div>'));parent.jQuery(".nggobasic-fancybox-title-float").add(".nggobasic-fancybox-title-over").add(".nggobasic-fancybox-title-inside").add(".nggobasic-fancybox-title-outside").hide();parent.jQuery(".nggobasic-fancybox-title").css({"font-family":"Helvetica","font-size":"12px","z-index":"100002"});E=parent.jQuery("#nggobasic-fancybox-frame");
u=parent.jQuery(".nggobasic-fancybox-title-float");v=parent.jQuery(".nggobasic-fancybox-title-over");w=parent.jQuery(".nggobasic-fancybox-title-inside");R=parent.jQuery(".nggobasic-fancybox-title-outside");F=parent.jQuery(".nggobasic-dfsi-title-text");r=parent.jQuery("#nggobasic-fancybox-overlay");$=parent.jQuery("#nggobasic-fancybox-loading").find("div");S=parent.jQuery("a#nggobasic-fancybox-close");K=a("body");s=a("#nggobasic-dfsi-bg");e=a("#nggobasic-dfsi-wrap");G=a("#nggobasic-dfsi-responsive-grid");
x=a(".nggobasic-dfsi-input");l=a('select[ id$="[fancybox_title_position]" ]');k=a('input[ type=text ][ id$="[fancybox_overlay_color]" ]');y=a('select[ id$="[fancybox_overlay_opacity]" ]');T=a('input[ id$="[fancybox_responsive_resize]" ]');n=a('input[ id$="[fancybox_image_counter]" ]');p=a('input[ id$="[fancybox_title_from_alt]" ]');z=a("#nggobasic-dfsi-mini-modal-box");h=a("#nggobasic-dfsi-mini-modal-overlay");U=a("#nggobasic-dfsi-mini-modal-wrap");H=a("#nggobasic-dfsi-color-picker");q=a("#nggobasic-dfsi-help");
V=a("#nggobasic-dfsi-save-button");M=a("#nggobasic-dfsi-reset-button");b=l.find(":selected").val().toLowerCase();-1!=navigator.appVersion.indexOf("MSIE 6")&&(m=!0);-1!=navigator.appVersion.indexOf("MSIE 7")&&(C=!0);-1!=navigator.appVersion.indexOf("MSIE 8")&&(t=!0);a(window).resize(function(){X();Y()});e.bind("touchstart.nggobasicDFSI",function(){var d=document.getElementById("nggobasic-dfsi-wrap").scrollTop,g=document.getElementById("nggobasic-dfsi-wrap").scrollHeight,b=document.getElementById("nggobasic-dfsi-wrap").offsetHeight,
g=g-b;0===a(this).scrollTop()&&a(this).scrollTop(1);g==d&&a(this).scrollTop(d-1)});a("#wpcontent").unwrap();a("#wpbody").unwrap();a("#wpbody-content").unwrap();a("#nggobasic-dfsi-wrap").unwrap();a("#screen-meta").remove();a("#adminmenuwrap").remove();a(".screen-reader-shortcut").remove();a("#adminmenuback").remove();if(m||C||t)a("#nggobasic-dfsi-color-picker").add("#nggobasic-dfsi-help ").add("#nggobasic-dfsi-box").add("#nggobasic-dfsi-box-inner").add(".nggobasic-dfsi-option-bg").add("#nggobasic-dfsi-footer-buttons").css("filter",
'progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'+B+'admin/assets/images/transparent-pixel.png", sizingMethod="scale")'),a("#nggobasic-dfsi-mini-modal-close").css("filter",'progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'+B+'fancybox/fancy_close.png", sizingMethod="scale")'),a("#nggobasic-dfsi-color-picker").add("#nggobasic-dfsi-help ").add("#nggobasic-dfsi-box").add("#nggobasic-dfsi-box-inner").add(".nggobasic-dfsi-option-bg").add("#nggobasic-dfsi-footer-buttons").add("#nggobasic-dfsi-mini-modal-close").css({background:"transparent",
zoom:"1"});t&&a(".nggobasic-dfsi-help-link").css("background","url(about:blank)");if(C||t)parent.jQuery("#nggobasic-fancybox-title-float-left").css("filter",'progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'+B+'fancybox/fancy_title_left.png", sizingMethod="scale")'),parent.jQuery("#nggobasic-fancybox-title-float-main").css("filter",'progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'+B+'fancybox/fancy_title_main.png", sizingMethod="scale")'),parent.jQuery("#nggobasic-fancybox-title-float-right").css("filter",
'progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'+B+'fancybox/fancy_title_right.png", sizingMethod="scale")'),parent.jQuery("#nggobasic-fancybox-title-over").css("filter",'progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'+B+'fancybox/fancy_title_over.png", sizingMethod="scale")'),parent.jQuery("#nggobasic-fancybox-title-float-left").add("#nggobasic-fancybox-title-float-main").add("#nggobasic-fancybox-title-float-right").add("#nggobasic-fancybox-title-over").css({background:"transparent",
zoom:"1"});if(m||C)a("#nggobasic-dfsi-wrap").css("margin","0 -9px"),a("html").css("overflow","hidden");if(m){a("#nggobasic-dfsi-bg").css({position:"absolute",top:'expression(0+((e=document.documentElement.scrollTop)?e:document.body.scrollTop)+"px")',left:'expression(0+((e=document.documentElement.scrollLeft)?e:document.body.scrollLeft)+"px")'});a("#nggobasic-dfsi-logo-inner").css({filter:'progid:DXImageTransform.Microsoft.AlphaImageLoader(src="'+B+'admin/assets/images/nextgen-gallery-optimizer.png", sizingMethod="scale")',
cursor:"pointer",background:"url(about:blank)"});a("#nggobasic-dfsi-logo-inner img").css({visibility:"hidden"});a('select[ id$="[fancybox_title_position]" ]').hide();a('select[ id$="[fancybox_overlay_opacity]" ]').hide();try{document.execCommand("BackgroundImageCache",!1,!0)}catch(d){}}da();ea();ba(b);fa();J("init");X();Y();ga();ha();ia();ja();ka()},da=function(){E.get(0).contentWindow.focus();parent.jQuery(".nggobasic-fancybox-title").add("#nggobasic-fancybox-wrap").bind("click.nggobasicDFSIDemo",
function(){E.get(0).contentWindow.focus()})},ka=function(){e.add(G).add(x).add(z).add(h).css("opacity","0");z.add(h).css("display","block");a(window).load(function(){$.fadeOut(function(){parent.jQuery.nggobasicDFSIDemoFancybox.hideActivity();X();s.fadeIn(700,function(){e.css("overflow-y","scroll");e.fadeTo(700,1,function(){"undefined"!==typeof a("body")[0].style["-webkit-overflow-scrolling"]?e.css({"overflow-y":"scroll","-webkit-overflow-scrolling":"touch"}):(e.css("overflow-y",""),K.css("overflow-y",
"scroll"));m&&(l.show(),y.show())});Y();x.fadeTo(700,1);G.fadeTo(700,1,function(){P(b);(m||C||t)&&x.css("filter",0)})})})})},P=function(d,c){function g(){"titleFromAlt"===c?(clearTimeout(aa),aa=setTimeout(function(){f.animateTitle(b,b,"titleFromAltEnd",J)},1E3)):"titleFromAltEnd"===c?(I=A=!1,("enabled"===O&&!p[0].checked||"disabled"===O&&p[0].checked)&&f.animateTitle(b,b,"titleFromAlt",J),e()):"imageCounter"===c?(I=A=!1,("enabled"===N&&!n[0].checked||"disabled"===N&&n[0].checked)&&f.animateTitle(b,
b,c,J),e()):(A=!1,I&&L(c))}function e(){l.find(":selected").val().toLowerCase()!==b&&L("titlePosition")}ma();"none"===d&&g();"float"===d&&(u.css("left",-1*parseInt((u.width()-E.width()-60)/2,10)),u.fadeIn(g));"over"===d&&(v.css("width",a(window).width()+"px"),v.fadeIn(g));"inside"===d&&w.css("opacity","0").slideDown(function(){w.hide().css("opacity",1).fadeIn(g)});"outside"===d&&R.fadeIn(g)},L=function(a){I=!0;A||("imageCounter"===a||"titleFromAlt"===a?(f.animateTitle(b,b,a,J),A=!0,I=!1):(a=l.find(":selected").val().toLowerCase(),
f.animateTitle(b,a,"onChange",ca),A=!0,I=!1,b=a,parent.nggobasicDFSIDemoVars.titlePosition=a))},ca=function(a,c,g){"reset"===g&&J(g);"over"===c&&"none"===a||"float"===c&&"inside"===a||"inside"===c&&"float"===a||"float"===c&&"float"===a?P(c):"none"===c&&"over"===a?A=!1:f.resizeLightbox(c)},ea=function(){l.change(function(){L("titlePosition")});y.change(function(){r.fadeTo(500,y.val())});T.change(function(){this.checked&&f.animateTitle(b,b,"resize",f.resizeLightbox);parent.nggobasicDFSIDemoVars.responsiveResize=
this.checked?!0:!1});n.change(function(){L("imageCounter")});p.change(function(){L("titleFromAlt")})},ba=function(a){"none"===a?(n.add(p).attr("disabled",!0),n.attr("title",'Image counter is disabled when "Title position" is set to "None".'),p.attr("title",'Title from Alt is disabled when "Title position" is set to "None".')):n.add(p).removeAttr("disabled").removeAttr("title")},fa=function(){M.click(function(){confirm("Are you sure you want to reset Fancybox to default settings?")&&(l.val("Float"),
f.animateTitle(b,"float","reset",ca),b="float",parent.nggobasicDFSIDemoVars.titlePosition=b,k.val("#666"),k.css("background-color",k.val()),r.css("background-color",k.val()),y.val("0.3"),r.fadeTo(600,"0.3"),T[0].checked=!1,parent.nggobasicDFSIDemoVars.responsiveResize=!1,n[0].checked=!1,p[0].checked=!1);a(this).blur()})},J=function(a){"titleFromAlt"===a&&(p[0].checked?(F.html("Fallback title enabled"),O="enabled"):(F.html("Fallback title disabled"),O="disabled"));if("init"===a||"imageCounter"===a||
"titleFromAltEnd"===a)n[0].checked?(F.text("Image 1 of 1 | Brooklyn Bridge"),N="enabled"):(F.text("Brooklyn Bridge"),N="disabled");"reset"===a&&F.text("Brooklyn Bridge");u.css("left",-1*parseInt((u.width()-E.width()-60)/2,10));"init"!==a&&"reset"!==a&&P(b,a)},X=function(){var d=a(window).width()/a(window).height(),c=s.width()/s.height();d>c?s.css("width",parent.jQuery("#nggobasic-fancybox-content").width()+"px").css("height",""):d<c&&s.css("height",parent.jQuery("#nggobasic-fancybox-content").height()+
"px").css("width","")},ma=function(){if(a(window).height()>=a("#nggobasic-dfsi-box").height()+75){var d=a(window).height()-a("#nggobasic-dfsi-box").height();a("#nggobasic-dfsi-mobile-spacer").css("height",d+"px")}else a("#nggobasic-dfsi-mobile-spacer").css("height","0");a(window).bind("orientationchange.nggobasicDFSI",function(){window.scrollTo(0,0)})},ga=function(){/iP(hone|od|ad)/.test(navigator.platform)&&/\sSafari\//.test(navigator.userAgent)&&a(window).bind("orientationchange.nggobasicDFSI",
function(){a("#nggobasic-dfsi-bg").css({top:"0",bottom:""});90===Math.abs(window.orientation)?a("#nggobasic-dfsi-mini-modal-box").css("top",(a(window).height()-244)/2+"px"):a("#nggobasic-dfsi-mini-modal-box").css("top","50%")})},Y=function(){var d=a("#nggobasic-dfsi-logo-inner"),c=a("#nggobasic-dfsi-logo-inner img"),g=a("#nggobasic-dfsi-upgrade-text"),b=a("#nggobasic-dfsi-download-button"),e=a(".nggobasic-dfsi-option-box"),f=a(".nggobasic-dfsi-option-spacer"),l=parent.jQuery(".nggobasic-fancybox-title-over"),
k=a("#nggobasic-dfsi-footer-buttons");662>=a(parent.window).width()?d.add(c).css("width","100%"):d.add(c).css("width","398px");h.css("height",a(window).height());if(m||t)l.css("margin-bottom","-1px"),s.css("margin-bottom","-1px"),E.get(0).contentWindow.focus();890>=a(parent.window).width()?(G.css("padding","0"),e.css("width","100%"),f.remove(),b.css({padding:"8px 0",display:"block"}),g.css("width",""),k.css("margin","47px 0 0")):(G.css("padding","0 4.01%"),e.css("width","30.66%"),f.length||a(".nggobasic-dfsi-option-middle").before('<div class="nggobasic-dfsi-option-spacer">&nbsp</div>').after('<div class="nggobasic-dfsi-option-spacer">&nbsp</div>'),
b.css({padding:"8px 100px",display:""}),g.css("width","500px"),k.css("margin-top",G.css("padding-left")));410>=a(parent.window).width()?b.css("font-size","14px"):b.css("font-size","18px");350>=a(parent.window).width()?(V.css({margin:"0 auto 10px",display:"block"}),M.css({margin:"0 auto",display:"block"})):(V.css({margin:"0 6px 0 0",display:"inline"}),M.css({margin:"0",display:"inline"}));v.css("width",a(window).width()+"px")},na=function(){a("#nggobasic-dfsi-mini-modal-close").bind("click.nggobasicDFSIDemo",
function(){Q()});h.bind("click.nggobasicDFSIDemo",function(){Q()});a(parent.window).add(document).bind("keydown.nggobasicDFSIDemoMiniModal",function(a){27==a.keyCode&&(a.preventDefault(),Q())});a("#nggobasic-dfsi-mini-modal-inner").bind("click.nggobasicDFSIDemo",function(a){a.target===this&&Q()})},D=function(){"undefined"==typeof a("body")[0].style["-webkit-overflow-scrolling"]&&(W=0<a(window).scrollTop()?a(window).scrollTop():K.scrollTop(),K.css("overflow-y",""),e.css("overflow-y","scroll"));e.animate({scrollTop:W},
0,function(){e.animate({opacity:0},700);x.animate({opacity:0},700);m&&(l.hide(),y.hide());"over"===b&&v.fadeOut();na();h.css("cursor","pointer");h.add(z).css("z-index","100000");h.animate({opacity:.5},700);z.animate({opacity:1},700)})},Q=function(){a("#nggobasic-dfsi-mini-modal-close").unbind("click.nggobasicDFSIDemo");h.unbind("click.nggobasicDFSIDemo");a(parent.window).add(document).unbind("keydown.nggobasicDFSIDemoMiniModal");a("#nggobasic-dfsi-mini-modal-inner").unbind("click.nggobasicDFSIDemo");
h.css("cursor","");H.fadeOut();q.fadeOut();h.add(z).animate({opacity:0},700);h.add(z).css("z-index","-1");(m||C||t)&&H.add(q).css("display","none");U.css("cursor","");x.animate({opacity:1},700);e.animate({opacity:1},700,function(){"undefined"!==typeof a("body")[0].style["-webkit-overflow-scrolling"]?e.css({"overflow-y":"scroll","-webkit-overflow-scrolling":"touch"}):(K.css("overflow-y","scroll"),e.css("overflow-y",""));a("html, body").animate({scrollTop:W},0);m&&(l.show(),y.show())});"over"===b&&
v.fadeIn();(m||C||t)&&x.css("filter",0)},ha=function(){a("#nggobasic-dfsi-color-picker-link").click(function(){D();H.fadeIn();U.css("cursor","crosshair")});H.farbtastic(k).mouseup(function(){r.css("background-color",a.farbtastic(H).color)});k.keyup(function(){r.css("background-color",k.val())});k.keyup(function(){var d=a(this).val(),c=d;"#"!=c.charAt(0)&&(c="#"+c);c=c.replace(/[^#a-fA-F0-9]+/,"");c=c.substr(0,7);c!=d&&a(this).val(c)})},ia=function(){var d=a("#nggobasic-dfsi-help-text");a("#nggobasic-dfsi-help-title-position").click(function(){d.html('<div id="nggobasic-dfsi-help-title">Help &raquo; Title position</div><p>This option lets you select your preferred Fancybox title position.</p><p>Choose between "None", "Float", "Over", "Inside" or "Outside".</p><p>The default is "Float".</p>');
D();q.fadeIn()});a("#nggobasic-dfsi-help-overlay-color").click(function(){d.html('<div id="nggobasic-dfsi-help-title">Help &raquo; Overlay color</div><p>This option lets you change the color of Fancybox\'s background overlay.</p><p>Simply enter a preferred CSS hex color code (Eg. #fff for white / #000 for black), or click the "Pick" link to launch the built-in color picker.</p><p>The default is #666.</p>');D();q.fadeIn()});a("#nggobasic-dfsi-help-overlay-opacity").click(function(){d.html('<div id="nggobasic-dfsi-help-title">Help &raquo; Overlay opacity</div><p>This option lets you change the opacity level of Fancybox\'s background overlay in 11 stops.</p><p>0 = completely transparent.</p><p>1 = completely opaque.</p><p>The default is 0.3.</p>');
D();q.fadeIn()});a("#nggobasic-dfsi-help-responsive-resize").click(function(){d.html('<div id="nggobasic-dfsi-help-title">Help &raquo; Responsive resize</div><p>This option lets you activate Optimizer Pro\'s responsive resize feature.</p><p>This feature automatically resizes Fancybox when the browser window is resized, or when the orientation is changed on mobile devices.</p>');D();q.fadeIn()});a("#nggobasic-dfsi-help-image-counter").click(function(){d.html('<div id="nggobasic-dfsi-help-title">Help &raquo; Image counter</div><p>If you have large galleries, you may like to add an image counter to improve user experience.</p><p>This option will prepend a counter (Eg. Image 1 of 30) to each of your image titles to enhance navigation.</p>');
D();q.fadeIn()});a("#nggobasic-dfsi-help-title-from-alt").click(function(){d.html('<div id="nggobasic-dfsi-help-title">Help &raquo; Title from Alt</div><p>By default, Fancybox uses NextGEN\'s description fields at <b><a href="'+parent.nggobasicDFSIDemoVars.adminUrl+'admin.php?page=nggallery-manage-gallery" target="_blank">Gallery &raquo; Manage Gallery</a></b> for titles.</p><p>This option lets you fall back on the Alt text (Eg. "brooklyn-bridge.jpg") for images that don\'t have manually entered descriptions.</p>');
D();q.fadeIn()})},ja=function(){a(parent.window).add(document).bind("keydown.nggobasicDFSIDemo",function(a){27==a.keyCode&&(a.preventDefault(),"0"===h.css("opacity")&&Z())});r.unbind("click").bind("click.nggobasicDFSIDemo",function(){Z()});S.unbind("click").bind("click.nggobasicDFSIDemo",function(a){a.preventDefault();Z()})},Z=function(){a(parent.window).unbind("resize.nggobasicDFSIDemo");a(parent.window).add(document).unbind("keydown.nggobasicDFSIDemo");r.unbind("click.nggobasicDFSIDemo");S.unbind("click.nggobasicDFSIDemo");
parent.jQuery("html, body").unbind("touchmove.nggobasicDFSIDemo");s.unbind("click.nggobasicDFSIDemo");parent.jQuery(".nggobasic-fancybox-title").add("#nggobasic-fancybox-wrap").unbind("click.nggobasicDFSIDemo");parent.jQuery("html, body, #wpwrap").removeAttr("style");parent.jQuery("body").css("overflow-x","hidden");parent.jQuery(".nggobasic-fancybox-title").remove();parent.jQuery("html, body").unbind("touchmove.nggobasicDFSI");e.unbind("touchstart.nggobasicDFSI");parent.nggobasicDFSIDemoVars.titlePosition=
"float";parent.nggobasicDFSIDemoVars.responsiveResize=!1;parent.jQuery.nggobasicDFSIDemoFancybox.close();parent.jQuery("#nggobasic-fancybox-title").length||parent.jQuery("a#nggobasic-fancybox-close").after('<div id="nggobasic-fancybox-title"></div>')};f.animateTitle=function(a,c,b,e){function f(){if(e)return"imageCounter"===b||"titleFromAlt"===b||"titleFromAltEnd"===b?e(b):e(a,c,b)}"none"===a&&f();"float"===a&&u.fadeOut(f);"over"===a&&v.fadeOut(f);"outside"===a&&R.fadeOut(f);"inside"===a&&("resize"===
b||"imageCounter"===b||"titleFromAlt"===b||"titleFromAltEnd"===b?w.slideUp(f):w.fadeTo("400",0,function(){w.slideUp(function(){w.hide(f)})}));ba(c)};f.resizeLightbox=function(a){parent.jQuery.nggobasicDFSIDemoFancybox.responsiveResize(a,P)};a(document).ready(function(){la()})})(window.nggobasicDFSIDemo=window.nggobasicDFSIDemo||{},jQuery);