<?php
add_action('init', 'ninja_forms_register_save_sub');
function ninja_forms_register_save_sub(){
	add_action('ninja_forms_post_process', 'ninja_forms_save_sub');
}

function ninja_forms_save_sub(){
	global $ninja_forms_processing, $ninja_forms_fields;
	
	if($ninja_forms_processing->get_form_setting('save_subs') == 1){

		$action = $ninja_forms_processing->get_action();
		$user_id = $ninja_forms_processing->get_user_ID();
		
		$sub_id = $ninja_forms_processing->get_form_setting( 'sub_id' );
		$form_id = $ninja_forms_processing->get_form_ID();
		
		$field_data = $ninja_forms_processing->get_all_fields();

		$sub_data = array();

		if(is_array($field_data) AND !empty($field_data)){
			foreach($field_data as $field_id => $user_value){
				$field_row = ninja_forms_get_field_by_id($field_id);
				$field_type = $field_row['type'];
				$save_sub = $ninja_forms_fields[$field_type]['save_sub'];
				
				if($save_sub){
					ninja_forms_remove_from_array($sub_data, "field_id", $field_id, TRUE);
					$user_value = apply_filters('ninja_forms_save_sub', $user_value, $field_id);
					array_push( $sub_data, array( 'field_id' => $field_id, 'user_value' => $user_value ) );
				}
			}
		}

		$args = array(
			'form_id' => $form_id,
			'user_id' => $user_id,
			'action' => $action,
			'data' => serialize( $sub_data ),
			'status' => 1,
		);

		$args = apply_filters( 'ninja_forms_save_sub_args', $args );
	
		if($sub_id != ''){
			$args['sub_id'] = $sub_id;
			ninja_forms_update_sub($args);	
		}else{
			ninja_forms_insert_sub($args);
		}
	}
}