<?php

if( isset( $_POST['_ninja_forms_display_submit'] ) AND $_POST['_ninja_forms_display_submit'] == 1 ){
	$form_row = ninja_forms_get_form_by_id( $_POST['_form_id'] );
	if( isset( $form_row['data']['ajax'] ) ){
		$ajax = $form_row['data']['ajax'];
	}else{
		$ajax = '';
	}
	if( $ajax != 1 ){
		add_action( 'init', 'ninja_forms_setup_processing_class', 5 );
		add_action( 'init', 'ninja_forms_pre_process', 999 );
	}
}

add_action('wp_head', 'ninja_forms_page_append_check');

function ninja_forms_page_append_check(){
	global $post, $ninja_forms_append_page_form_id;

	if(is_array($ninja_forms_append_page_form_id)){
		unset($ninja_forms_append_page_form_id);
	}
	if(!isset($ninja_forms_append_page_form_id)){
		$ninja_forms_append_page_form_id = array();
	}

	if( !is_admin() AND is_main_query() AND ( is_page() OR is_single() ) ){
		$form_ids = ninja_forms_get_form_ids_by_post_id($post->ID);
		if(is_array($form_ids) AND !empty($form_ids)){
			foreach($form_ids as $form_id){
				$ninja_forms_append_page_form_id[] = $form_id;
				add_filter('the_content', 'ninja_forms_append_to_page');
			}
		}
	}
}

function ninja_forms_append_to_page($content){
	global $ninja_forms_append_page_form_id;
	$form = '';
	if(is_array($ninja_forms_append_page_form_id) AND !empty($ninja_forms_append_page_form_id)){
		foreach($ninja_forms_append_page_form_id as $form_id){
			$form .= ninja_forms_return_echo('ninja_forms_display_form', $form_id);
		}
	}else{
		$form = ninja_forms_return_echo('ninja_forms_display_form', $ninja_forms_append_page_form_id);
	}
	$content .= $form;
	return $content;
}

/**
 * Main function used to display a Ninja Form.
 * ninja_forms_display_form() can be called anywhere on in a WordPress template.
 * By default it's called by the ninja_forms_append_to_page() function in the main ninja_forms.php file.
 * 
**/

function ninja_forms_display_form($form_id = ''){
	//Define our global variables
	global $post, $wpdb, $ninja_forms_fields, $ninja_forms_processing;
	//Get the settings telling us whether or not we should clear/hide the completed form.
	//Check to see if the form_id has been sent.
	if($form_id == ''){
		$function = false;
		if(isset($_REQUEST['form_id'])){ //If it hasn't, set it to our requested form_id. Sometimes this function can be called without an expressly passed form_id.
			$form_id = $_REQUEST['form_id'];
		}
	}else{
		$function = true;
	}
	if($form_id != ''){ //Make sure that we have an active form_id.
		$form_row = ninja_forms_get_form_by_id($form_id);
		if( isset( $form_row['data']['ajax'] ) ){
			$ajax = $form_row['data']['ajax'];
		}else{
			$ajax = 0;
		}
		
		if($ajax == 1){
			$url = admin_url( 'admin-ajax.php' );
			$url = add_query_arg('action', 'ninja_forms_ajax_submit', $url);
		}else{
			$url = '';
		}

		do_action( 'ninja_forms_before_form_display', $form_id );
		
		do_action('ninja_forms_display_before_form_wrap', $form_id);
		do_action('ninja_forms_display_open_form_wrap', $form_id);

		do_action('ninja_forms_display_before_form_title', $form_id);
		do_action('ninja_forms_display_form_title', $form_id);
		do_action('ninja_forms_display_after_form_title', $form_id);
				
		do_action('ninja_forms_display_before_form', $form_id);
		do_action('ninja_forms_display_open_form_tag', $form_id);
		do_action('ninja_forms_display_after_open_form_tag', $form_id);

		do_action('ninja_forms_display_before_fields', $form_id);
		do_action('ninja_forms_display_fields', $form_id);
		do_action('ninja_forms_display_after_fields', $form_id);

		do_action('ninja_forms_display_close_form_tag', $form_id);
		do_action('ninja_forms_display_after_form', $form_id);		

		do_action('ninja_forms_display_close_form_wrap', $form_id);
		do_action('ninja_forms_display_after_form_wrap', $form_id);

		do_action( 'ninja_forms_display_js', $form_id );
		do_action( 'ninja_forms_display_css', $form_id );
	}
}