<?php
/**
 * Loop start template
 */
$settings = $this->get_settings();

$options = array(
	'slidesToShow'   => array(
		'desktop' => absint( $settings['slides_to_show'] ),
		'tablet'  => absint( $settings['slides_to_show_tablet'] ),
		'mobile'  => absint( $settings['slides_to_show_mobile'] ),
	),
	'autoplaySpeed'  => absint( $settings['autoplay_speed'] ),
	'autoplay'       => filter_var( $settings['autoplay'], FILTER_VALIDATE_BOOLEAN ),
	'infinite'       => filter_var( $settings['infinite'], FILTER_VALIDATE_BOOLEAN ),
	'pauseOnHover'   => filter_var( $settings['pause_on_hover'], FILTER_VALIDATE_BOOLEAN ),
	'speed'          => absint( $settings['speed'] ),
	'arrows'         => filter_var( $settings['arrows'], FILTER_VALIDATE_BOOLEAN ),
	'dots'           => filter_var( $settings['dots'], FILTER_VALIDATE_BOOLEAN ),
	'slidesToScroll' => absint( $settings['slides_to_scroll'] ),
	'prevArrow'      => jet_elements_tools()->get_carousel_arrow(
		array( $settings['prev_arrow'], 'prev-arrow' )
	),
	'nextArrow'      => jet_elements_tools()->get_carousel_arrow(
		array( $settings['next_arrow'], 'next-arrow' )
	),
);

if ( 1 === absint( $settings['slides_to_show'] ) ) {
	$options['fade'] = ( 'fade' === $settings['effect'] );
}

?>
<div class="jet-carousel jet-carousel elementor-slick-slider" data-slider_options='<?php echo json_encode( $options ); ?>' dir="ltr">