<?php

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'Jet_Elements_Compatibility' ) ) {

	/**
	 * Define Jet_Elements_Compatibility class
	 */
	class Jet_Elements_Compatibility {

		/**
		 * A reference to an instance of this class.
		 *
		 * @since 1.0.0
		 * @var   object
		 */
		private static $instance = null;

		/**
		 * Constructor for the class
		 */
		public function init() {

			// WPML String Translation plugin exist check
			if ( defined( 'WPML_ST_VERSION' ) ) {
				$this->load_files();
				add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'add_translatable_nodes' ) );
			}
		}

		/**
		 * Load required files.
		 *
		 * @return void
		 */
		public function load_files() {
			require jet_elements()->plugin_path( 'includes/lib/compatibility/modules/class-wpml-jet-elements-advanced-carousel.php' );
			require jet_elements()->plugin_path( 'includes/lib/compatibility/modules/class-wpml-jet-elements-map.php' );
			require jet_elements()->plugin_path( 'includes/lib/compatibility/modules/class-wpml-jet-elements-animated-text.php' );
			require jet_elements()->plugin_path( 'includes/lib/compatibility/modules/class-wpml-jet-elements-brands.php' );
			require jet_elements()->plugin_path( 'includes/lib/compatibility/modules/class-wpml-jet-elements-images-layout.php' );
			require jet_elements()->plugin_path( 'includes/lib/compatibility/modules/class-wpml-jet-elements-pricing-table.php' );
			require jet_elements()->plugin_path( 'includes/lib/compatibility/modules/class-wpml-jet-elements-slider.php' );
			require jet_elements()->plugin_path( 'includes/lib/compatibility/modules/class-wpml-jet-elements-team-member.php' );
			require jet_elements()->plugin_path( 'includes/lib/compatibility/modules/class-wpml-jet-elements-testimonials.php' );
		}

		/**
		 * Add jet elements translation nodes
		 *
		 * @param array
		 */
		public function add_translatable_nodes( $nodes_to_translate ) {

			$nodes_to_translate[ 'jet-animated-box' ] = array(
				'conditions' => array( 'widgetType' => 'jet-animated-box' ),
				'fields'     => array(
					array(
						'field'       => 'front_side_title',
						'type'        => esc_html__( 'Jet Animated Box: Front Title', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'front_side_subtitle',
						'type'        => esc_html__( 'Jet Animated Box: Front SubTitle', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'front_side_description',
						'type'        => esc_html__( 'Jet Animated Box: Front Description', 'jet-elements' ),
						'editor_type' => 'VISUAL',
					),
					array(
						'field'       => 'back_side_title',
						'type'        => esc_html__( 'Jet Animated Box: Back Title', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'back_side_subtitle',
						'type'        => esc_html__( 'Jet Animated Box: Back SubTitle', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'back_side_description',
						'type'        => esc_html__( 'Jet Animated Box: Back Description', 'jet-elements' ),
						'editor_type' => 'VISUAL',
					),
				),
			);

			$nodes_to_translate[ 'jet-banner' ] = array(
				'conditions' => array( 'widgetType' => 'jet-banner' ),
				'fields'     => array(
					array(
						'field'       => 'banner_title',
						'type'        => esc_html__( 'Jet Banner: Title', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'banner_text',
						'type'        => esc_html__( 'Jet Banner: Description', 'jet-elements' ),
						'editor_type' => 'VISUAL',
					),
				),
			);

			$nodes_to_translate[ 'jet-countdown-timer' ] = array(
				'conditions' => array( 'widgetType' => 'jet-countdown-timer' ),
				'fields'     => array(
					array(
						'field'       => 'label_days',
						'type'        => esc_html__( 'Jet Countdown Timer: Label Days', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'label_hours',
						'type'        => esc_html__( 'Jet Countdown Timer: Label Hours', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'label_min',
						'type'        => esc_html__( 'Jet Countdown Timer: Label Min', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'label_sec',
						'type'        => esc_html__( 'Jet Countdown Timer: Label Sec', 'jet-elements' ),
						'editor_type' => 'LINE',
					),

				),
			);

			$nodes_to_translate[ 'jet-download-button' ] = array(
				'conditions' => array( 'widgetType' => 'jet-download-button' ),
				'fields'     => array(
					array(
						'field'       => 'download_label',
						'type'        => esc_html__( 'Jet Download Button: Label', 'jet-elements' ),
						'editor_type' => 'LINE',
					),

				),
			);

			$nodes_to_translate[ 'jet-circle-progress' ] = array(
				'conditions' => array( 'widgetType' => 'jet-circle-progress' ),
				'fields'     => array(
					array(
						'field'       => 'title',
						'type'        => esc_html__( 'Jet Circle Progress: Title', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'subtitle',
						'type'        => esc_html__( 'Jet Circle Progress: Subtitle', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
				),
			);

			$nodes_to_translate[ 'jet-posts' ] = array(
				'conditions' => array( 'widgetType' => 'jet-posts' ),
				'fields'     => array(
					array(
						'field'       => 'more_text',
						'type'        => esc_html__( 'Jet Posts: Read More Button Text', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
				),
			);

			$nodes_to_translate[ 'jet-animated-text' ] = array(
				'conditions' => array( 'widgetType' => 'jet-animated-text' ),
				'fields'     => array(
					array(
						'field'       => 'before_text_content',
						'type'        => esc_html__( 'Jet Animated Text: Before Text', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'after_text_content',
						'type'        => esc_html__( 'Jet Animated Text: After Text', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
				),
				'integration-class' => 'WPML_Jet_Elements_Animated_Text',
			);

			$nodes_to_translate[ 'jet-carousel' ] = array(
				'conditions'        => array( 'widgetType' => 'jet-carousel' ),
				'fields'            => array(),
				'integration-class' => 'WPML_Jet_Elements_Advanced_Carousel',
			);

			$nodes_to_translate[ 'jet-map' ] = array(
				'conditions'        => array( 'widgetType' => 'jet-map' ),
				'fields'            => array(),
				'integration-class' => 'WPML_Jet_Elements_Map',
			);

			$nodes_to_translate[ 'jet-brands' ] = array(
				'conditions'        => array( 'widgetType' => 'jet-brands' ),
				'fields'            => array(),
				'integration-class' => 'WPML_Jet_Elements_Brands',
			);

			$nodes_to_translate[ 'jet-images-layout' ] = array(
				'conditions'        => array( 'widgetType' => 'jet-images-layout' ),
				'fields'            => array(),
				'integration-class' => 'WPML_Jet_Elements_Images_Layout',
			);

			$nodes_to_translate[ 'jet-pricing-table' ] = array(
				'conditions' => array( 'widgetType' => 'jet-pricing-table' ),
				'fields'     => array(
					array(
						'field'       => 'title',
						'type'        => esc_html__( 'Jet Pricing Table: Title', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'subtitle',
						'type'        => esc_html__( 'Jet Pricing Table: Subtitle', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'price_suffix',
						'type'        => esc_html__( 'Jet Pricing Table: Price Suffix', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'button_before',
						'type'        => esc_html__( 'Jet Pricing Table: Button Before', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'button_text',
						'type'        => esc_html__( 'Jet Pricing Table: Button Text', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'button_after',
						'type'        => esc_html__( 'Jet Pricing Table: Button After', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
				),
				'integration-class' => 'WPML_Jet_Elements_Pricing_Table',
			);

			$nodes_to_translate[ 'jet-slider' ] = array(
				'conditions'        => array( 'widgetType' => 'jet-slider' ),
				'fields'            => array(),
				'integration-class' => 'WPML_Jet_Elements_Slider',
			);

			$nodes_to_translate[ 'jet-services' ] = array(
				'conditions' => array( 'widgetType' => 'jet-services' ),
				'fields'     => array(
					array(
						'field'       => 'services_title',
						'type'        => esc_html__( 'Jet Services: Title', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'services_description',
						'type'        => esc_html__( 'Jet Services: Description', 'jet-elements' ),
						'editor_type' => 'VISUAL',
					),
					array(
						'field'       => 'button_text',
						'type'        => esc_html__( 'Jet Services: Button Text', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
				),
			);

			$nodes_to_translate[ 'jet-team-member' ] = array(
				'conditions' => array( 'widgetType' => 'jet-team-member' ),
				'fields'     => array(
					array(
						'field'       => 'member_first_name',
						'type'        => esc_html__( 'Jet Team Member: First Name', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'member_last_name',
						'type'        => esc_html__( 'Jet Team Member: Last Name', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'member_position',
						'type'        => esc_html__( 'Jet Team Member: Position', 'jet-elements' ),
						'editor_type' => 'LINE',
					),
					array(
						'field'       => 'member_description',
						'type'        => esc_html__( 'Jet Team Member: Description', 'jet-elements' ),
						'editor_type' => 'VISUAL',
					),
				),
				'integration-class' => 'WPML_Jet_Elements_Team_Member',
			);

			$nodes_to_translate[ 'jet-testimonials' ] = array(
				'conditions' => array( 'widgetType' => 'jet-testimonials' ),
				'fields'     => array(),
				'integration-class' => 'WPML_Jet_Elements_Testimonials',
			);

			return $nodes_to_translate;
		}

		/**
		 * Returns the instance.
		 *
		 * @since  1.0.0
		 * @return object
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
			}
			return self::$instance;
		}
	}

}

/**
 * Returns instance of Jet_Elements_Compatibility
 *
 * @return object
 */
function jet_elements_compatibility() {
	return Jet_Elements_Compatibility::get_instance();
}
