<?php
/**
 * TM-Wizard configuration.
 *
 * @var array
 *
 * @package Trainhard
 */

$plugins = array(
	'cherry-data-importer' => array(
		'name'   => esc_html__( 'Cherry Data Importer', 'trainhard' ),
		'source' => 'remote', // 'local', 'remote', 'wordpress' (default).
		'path'   => 'https://github.com/CherryFramework/cherry-data-importer/archive/master.zip',
		'access' => 'base',
	),
	'cherry-projects' => array(
		'name'   => esc_html__( 'Cherry Projects', 'trainhard' ),
		'access' => 'skins',
	),
	'cherry-popups' => array(
		'name'   => esc_html__( 'Cherry PopUps', 'trainhard' ),
		'access' => 'base',
	),
	'cherry-team-members' => array(
		'name'   => esc_html__( 'Cherry Team Members', 'trainhard' ),
		'access' => 'skins',
	),
	'cherry-testi' => array(
		'name'   => esc_html__( 'Cherry Testimonials', 'trainhard' ),
		'access' => 'skins',
	),
	'cherry-services-list' => array(
		'name'   => esc_html__( 'Cherry Services List', 'trainhard' ),
		'access' => 'skins',
	),
	'cherry-sidebars' => array(
		'name'   => esc_html__( 'Cherry Sidebars', 'trainhard' ),
		'access' => 'base',
	),
	'cherry-socialize' => array(
		'name'   => esc_html__( 'Cherry Socialize', 'trainhard' ),
		'access' => 'base',
	),
	'cherry-trending-posts' => array(
		'name'   => esc_html__( 'Cherry Trending Posts', 'trainhard' ),
		'access' => 'skins',
	),
	'booked' => array(
		'name'   => esc_html__( 'Booked Appointments', 'trainhard' ),
		'source' => 'local',
		'path'   => TRAINHARD_THEME_DIR . '/assets/includes/plugins/booked.zip',
		'access' => 'skins',
	),
	'elementor' => array(
		'name'   => esc_html__( 'Elementor Page Builder', 'trainhard' ),
		'access' => 'base',
	),
	'jet-elements' => array(
		'name'   => esc_html__( 'Jet Elements addon For Elementor', 'trainhard' ),
		'source' => 'local',
		'path'   => TRAINHARD_THEME_DIR . '/assets/includes/plugins/jet-elements.zip',
		'access' => 'base',
	),
	'tm-mega-menu' => array(
		'name'   => esc_html__( 'TM Mega Menu', 'trainhard' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/tm-mega-menu.zip',
		'access' => 'skins',
	),
	'tm-photo-gallery' => array(
		'name'   => esc_html__( 'TM Photo Gallery', 'trainhard' ),
		'access' => 'base',
	),
	'tm-timeline' => array(
		'name'   => esc_html__( 'TM Timeline', 'trainhard' ),
		'access' => 'skins',
	),
	'contact-form-7' => array(
		'name'   => esc_html__( 'Contact Form 7', 'trainhard' ),
		'access' => 'skins',
	),
	'simple-file-downloader' => array(
		'name'   => esc_html__( 'Simple File Downloader', 'trainhard' ),
		'access' => 'skins',
	),
	'shortcode-widget' => array(
		'name'   => esc_html__( 'Shortcode Widget', 'trainhard' ),
		'access' => 'skins',
	),
	'wordpress-social-login' => array(
		'name'   => esc_html__( 'WordPress Social Login', 'trainhard' ),
		'access' => 'skins',
	),
    'smart-slider-3' => array(
        'name'   => esc_html__( 'Smart Slider', 'trainhard' ),
        'access' => 'skins',
    ),
);

/**
 * Skins configuration.
 *
 * @var array
 */
$skins = array(
	'base' => array(
		'cherry-data-importer',
		'cherry-popups',
		'cherry-sidebars',
		'cherry-socialize',
		'elementor',
		'jet-elements',
		'tm-photo-gallery',
	),
	'advanced' => array(
		'default' => array(
			'full'  => array(
				'booked',
				'cherry-projects',
				'cherry-services-list',
				'cherry-team-members',
				'cherry-testi',
				'cherry-trending-posts',
				'tm-mega-menu',
				'tm-timeline',
				'contact-form-7',
				'simple-file-downloader',
				'shortcode-widget',
				'wordpress-social-login',
                'smart-slider-3',
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/wordpress_64790',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/default/default-thumb.png',
			'name'  => esc_html__( 'Trainhard', 'trainhard' ),
		),
	),
);

$texts = array(
	'theme-name' => esc_html__( 'Trainhard', 'trainhard' ),
);
