<?php
/**
 * Template part for displaying posts.
 *
 * @link    https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Trainhard
 */
?>

<?php
	$blog_layout_type    = get_theme_mod( 'blog_layout_type', trainhard_theme()->customizer->get_default( 'blog_layout_type' ) );
	$blog_featured_image = get_theme_mod( 'blog_featured_image', trainhard_theme()->customizer->get_default( 'blog_featured_image' ) );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'posts-list__item card' ); ?>>

	<?php if ( 'default' == $blog_layout_type && 'small' !== $blog_featured_image ) : ?>
		<div class="posts-list__left-col"><?php
			trainhard_get_template_part( 'template-parts/post/post-meta/content-meta-date' );

			if ( 'small' !== $blog_featured_image ) {
				trainhard_share_buttons( 'loop' );
			}
		?></div><!-- .posts-list__left-col -->
	<?php endif; ?>

	<div class="posts-list__right-col">
		<?php
			if ( 'default' !== $blog_layout_type || trainhard_check_for_small_image_default_listing() ) :
				trainhard_get_template_part( 'template-parts/post/post-meta/content-meta-date' );
			endif;
		?>

		<figure class="post-thumbnail"><?php
			trainhard_get_template_part( 'template-parts/post/post-components/post-image' );
			trainhard_get_template_part( 'template-parts/post/post-components/post-sticky' );
		?></figure><!-- .post-thumbnail -->

		<div class="posts-list__item-content">

			<header class="entry-header"><?php
				trainhard_get_template_part( 'template-parts/post/post-meta/content-meta-author' );
				trainhard_get_template_part( 'template-parts/post/post-meta/content-meta-categories' );
				trainhard_get_template_part( 'template-parts/post/post-components/post-title' );
			?></header><!-- .entry-header -->

			<div class="entry-content"><?php
				trainhard_get_template_part( 'template-parts/post/post-components/post-content' );
			?></div><!-- .entry-content -->

			<footer class="entry-footer">
				<div class="entry-meta-container"><?php
					trainhard_get_template_part( 'template-parts/post/post-meta/content-meta-tags' );
					trainhard_get_template_part( 'template-parts/post/post-meta/content-meta-comments' );
				?></div><!-- .entry-meta-container -->

				<div class="entry-footer-bottom"><?php
					trainhard_get_template_part( 'template-parts/post/post-components/post-button' );

					if ( 'default' !== $blog_layout_type || trainhard_check_for_small_image_default_listing() ) :
						trainhard_share_buttons( 'loop' );
					endif;
				?></div><!-- .entry-footer-bottom -->
			</footer><!-- .entry-footer -->
		</div><!-- .posts-list__item-content -->
	</div><!-- .posts-list__right-col -->

</article><!-- #post-## -->
