<?php
/**
 * Integrations list
 *
 * @author  YITH
 * @package YITH\Booking
 */

defined( 'YITH_WCBK' ) || exit;

return array(
	'badge-management'  => array(
		'name'              => 'YITH WooCommerce Badge Management',
		'title'             => 'Badge Management',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-badge-management.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-badge-management/',
		'description'       => __( 'Show badges also on bookable products. Show them on product page, shop page and in the booking search popup', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YITH_WCBM_PREMIUM',
		'installed_version' => 'YITH_WCBM_VERSION',
		'min_version'       => '1.2.0',
		'version_compare'   => '>=',
	),
	'catalog-mode'      => array(
		'name'              => 'YITH WooCommerce Catalog Mode',
		'title'             => 'Catalog Mode',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-catalog-mode.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-catalog-mode/',
		'description'       => __( 'Enable Catalog Mode on bookable products', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YWCTM_PREMIUM',
		'installed_version' => 'YWCTM_VERSION',
		'min_version'       => '1.5.8',
		'version_compare'   => '>=',
	),
	'deposits'          => array(
		'name'              => 'YITH WooCommerce Deposits and Down Payments',
		'title'             => 'Deposits and Down Payments',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-deposits-and-down-payments.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-deposits-and-down-payments/',
		'description'       => __( 'You can allow bookings with deposit/advance payment', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YITH_WCDP_PREMIUM_INIT',
		'installed_version' => 'YITH_WCDP::YITH_WCDP_VERSION',
		'min_version'       => '1.5.0',
		'version_compare'   => '>=',
		'new'               => true,
	),
	'email-templates'   => array(
		'name'              => 'YITH WooCommerce Email Templates',
		'title'             => 'Email Templates',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-email-templates.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-email-templates/',
		'description'       => __( 'You can stylize the Booking email templates', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YITH_WCET_PREMIUM',
		'installed_version' => 'YITH_WCET_VERSION',
		'min_version'       => '1.2.6',
		'version_compare'   => '>=',
	),
	'multi-vendor'      => array(
		'name'              => 'YITH WooCommerce Multi Vendor',
		'title'             => 'Multi Vendor',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-multi-vendor.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-multi-vendor/',
		'description'       => __( 'You can allow Vendor to manage their bookings', 'yith-booking-for-woocommerce' ),
		'optional'          => true,
		'constant'          => 'YITH_WPV_PREMIUM',
		'installed_version' => 'YITH_WPV_VERSION',
		'min_version'       => '1.12.0',
		'version_compare'   => '>=',
	),
	'multi-currency'    => array(
		'name'              => 'YITH Multi Currency Switcher for WooCommerce',
		'title'             => 'Multi Currency Switcher',
		'icon'              => '//yithemes.com/wp-content/uploads/2021/02/currency_switcher.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-multi-currency-switcher-for-woocommerce/',
		'description'       => __( 'Allow users to see and pay for bookable products in their own local currency.', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YITH_WCMCS_VERSION',
		'installed_version' => 'YITH_WCMCS_VERSION',
		'min_version'       => '1.0.5',
		'version_compare'   => '>=',
		'new'               => true,
	),
	'quick-view'        => array(
		'name'              => 'YITH WooCommerce Quick View',
		'title'             => 'Quick View',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-quick-view.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-quick-view/',
		'description'       => __( 'You can enable quick view on your bookable products', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YITH_WCQV_PREMIUM',
		'installed_version' => 'YITH_WCQV_VERSION',
		'min_version'       => '1.1.5',
		'version_compare'   => '>=',
	),
	'request-a-quote'   => array(
		'name'              => 'YITH WooCommerce Request a Quote',
		'title'             => 'Request a Quote',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-request-a-quote.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-request-a-quote/',
		'description'       => __( 'You can allow quote requests on your bookable products', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YITH_YWRAQ_PREMIUM',
		'installed_version' => 'YITH_YWRAQ_VERSION',
		'min_version'       => '1.5.7',
		'version_compare'   => '>=',
	),
	'review-reminder'   => array(
		'name'              => 'YITH WooCommerce Review Reminder',
		'title'             => 'Review Reminder',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-review-reminder.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-review-reminder/',
		'description'       => __( 'You can send an email to your customers and remember them to leave a review for your bookable products', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YWRR_PREMIUM',
		'installed_version' => 'YWRR_VERSION',
		'min_version'       => '1.6.0',
		'version_compare'   => '>=',
	),
	'sms-notifications' => array(
		'name'              => 'YITH WooCommerce Sms Notifications',
		'title'             => 'Sms Notifications',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-woocommerce-sms-notifications.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-sms-notifications/',
		'description'       => __( 'Stay updated with your bookings: receive and send an SMS to your customers every time a booking status changes.', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YWSN_PREMIUM',
		'installed_version' => 'YWSN_VERSION',
		'min_version'       => '1.4.0',
		'version_compare'   => '>=',
	),
	'test-environment'  => array(
		'name'              => 'YITH WordPress Test Environment',
		'title'             => 'Test Environment',
		'icon'              => '//yithemes.com/wp-content/uploads/2019/05/yith-wordpress-test-environment.svg',
		'landing_uri'       => '//yithemes.com/themes/plugins/yith-wordpress-test-environment/',
		'description'       => __( 'You can create sandbox environments and online test environments', 'yith-booking-for-woocommerce' ),
		'optional'          => false,
		'constant'          => 'YWTENV',
		'installed_version' => 'YWTENV_VERSION',
		'min_version'       => '1.0.0',
		'version_compare'   => '>=',
	),
	'wpml'              => array(
		'visible' => false,
	),
	'yith-proteo'       => array(
		'type'        => 'theme',
		'name'        => 'YITH Proteo',
		'title'       => 'Proteo',
		'landing_uri' => '//proteo.yithemes.com/',
		'description' => __( 'A sleek, modern and "Gutenberg-friendly" Free WooCommerce theme.', 'yith-booking-for-woocommerce' ),
		'optional'    => false,
		'visible'     => false,
	),
);
